/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.computer.recipe.ComputerFamilyRecipe;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.adapter.RecipeCraftingShapedJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.item.ItemStack;

public final class TurtleRecipe
extends ComputerFamilyRecipe
implements HasJsonAdapter {
    public TurtleRecipe(int recipeWidth, int recipeHeight, RecipeSymbol[] input, ItemStack output, boolean consumeContainerItem, boolean allowMirrored, ComputerFamily family) {
        super(recipeWidth, recipeHeight, input, output, consumeContainerItem, allowMirrored, family);
    }

    public TurtleRecipe() {
    }

    @Override
    @Nonnull
    protected ItemStack convert(@Nonnull IComputerItem item, @Nonnull ItemStack stack) {
        int computerID = item.getComputerID(stack);
        String label = item.getLabel(stack);
        return Objects.requireNonNull(TurtleItemFactory.create(computerID, label, -1, this.getFamily(), null, null, 0, -1));
    }

    public RecipeJsonAdapter<?> getAdapter() {
        return new TurtleRecipeJsonAdapter();
    }

    private static class TurtleRecipeJsonAdapter
    implements RecipeJsonAdapter<TurtleRecipe> {
        private TurtleRecipeJsonAdapter() {
        }

        public TurtleRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            RecipeEntryCraftingShaped recipeEntryCraftingShaped = new RecipeCraftingShapedJsonAdapter().deserialize(json, typeOfT, context);
            JsonObject obj = json.getAsJsonObject();
            ComputerFamily family = ComputerFamily.getFamily(obj.get("family").getAsString());
            return new TurtleRecipe(recipeEntryCraftingShaped.recipeWidth, recipeEntryCraftingShaped.recipeHeight, (RecipeSymbol[])recipeEntryCraftingShaped.getInput(), (ItemStack)recipeEntryCraftingShaped.getOutput(), recipeEntryCraftingShaped.consumeContainerItem, recipeEntryCraftingShaped.allowMirrored, family);
        }

        public JsonElement serialize(TurtleRecipe src, Type typeOfSrc, JsonSerializationContext context) {
            JsonElement recipeEntryCraftingShaped = new RecipeCraftingShapedJsonAdapter().serialize((RecipeEntryCraftingShaped)src, typeOfSrc, context);
            JsonObject obj = recipeEntryCraftingShaped.getAsJsonObject();
            obj.add("family", context.serialize((Object)src.getFamily().name()));
            return obj;
        }
    }
}

