/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.fabric.Helper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerCrafting;
import net.minecraft.core.world.World;

public class TurtleInventoryCrafting
extends ContainerCrafting {
    private final ITurtleAccess turtle;
    private int xStart;
    private int yStart;

    public TurtleInventoryCrafting(ITurtleAccess turtle) {
        super(null, 0, 0);
        this.turtle = turtle;
        this.xStart = 0;
        this.yStart = 0;
    }

    @Nullable
    private ItemStack tryCrafting(int xStart, int yStart) {
        this.xStart = xStart;
        this.yStart = yStart;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (x >= this.xStart && x < this.xStart + 3 && y >= this.yStart && y < this.yStart + 3 || this.turtle.getInventory().getItem(x + y * 4) == null) continue;
                return null;
            }
        }
        return Registries.RECIPES.findMatchingRecipe((ContainerCrafting)this);
    }

    @Nullable
    public List<ItemStack> doCrafting(World world, int maxCount) {
        if (Helper.isClientWorld()) {
            return null;
        }
        ItemStack recipe = this.tryCrafting(0, 0);
        if (recipe == null) {
            recipe = this.tryCrafting(0, 1);
        }
        if (recipe == null) {
            recipe = this.tryCrafting(1, 0);
        }
        if (recipe == null) {
            recipe = this.tryCrafting(1, 1);
        }
        if (recipe == null) {
            return null;
        }
        if (maxCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        ItemStack result = Registries.RECIPES.findMatchingRecipe((ContainerCrafting)this);
        for (int i = 0; i < maxCount && result != null && result.itemID == recipe.itemID; ++i) {
            Registries.RECIPES.onCraftResult((ContainerCrafting)this);
            results.add(result);
            result = Registries.RECIPES.findMatchingRecipe((ContainerCrafting)this);
        }
        return results;
    }

    public boolean stillValid(Player entityplayer) {
        return this.turtle.getInventory().stillValid(entityplayer);
    }

    private int modifyIndex(int index) {
        int x = this.xStart + index % this.getWidth();
        int y = this.yStart + index / this.getHeight();
        return x >= 0 && x < 4 && y >= 0 && y < 4 ? x + y * 4 : -1;
    }

    private int getHeight() {
        return 3;
    }

    private int getWidth() {
        return 3;
    }

    public int getContainerSize() {
        return this.getWidth() * this.getHeight();
    }

    @Nullable
    public ItemStack getItem(int i) {
        i = this.modifyIndex(i);
        return this.turtle.getInventory().getItem(i);
    }

    public ItemStack getItemStackAt(int i, int j) {
        if (i >= 0 && i < this.getHeight()) {
            int k = i + j * this.getHeight();
            return this.getItem(k);
        }
        return null;
    }

    @Nullable
    public ItemStack removeItem(int i, int j) {
        i = this.modifyIndex(i);
        return this.turtle.getInventory().removeItem(i, j);
    }

    public void setItem(int i, @Nullable ItemStack stack) {
        i = this.modifyIndex(i);
        this.turtle.getInventory().setItem(i, stack);
    }

    public void setSlotContentsAt(int i, int j, ItemStack itemStack) {
        if (i >= 0 && i < this.getWidth()) {
            int k = i + j * this.getHeight();
            this.setItem(k, itemStack);
        }
    }

    public void setChanged() {
        this.turtle.getInventory().setChanged();
    }
}

