/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.Colour;
import net.minecraft.core.util.helper.DyeColor;

public class ColourTracker {
    private int total;
    private int totalR;
    private int totalG;
    private int totalB;
    private int count;

    public void addColour(float r, float g2, float b) {
        this.addColour((int)(r * 255.0f), (int)(g2 * 255.0f), (int)(b * 255.0f));
    }

    public void addColour(int r, int g2, int b) {
        this.total += Math.max(r, Math.max(g2, b));
        this.totalR += r;
        this.totalG += g2;
        this.totalB += b;
        ++this.count;
    }

    public void addColour(DyeColor dye) {
        Colour colour = Colour.VALUES[15 - dye.blockMeta];
        this.addColour(colour.getR(), colour.getG(), colour.getB());
    }

    public boolean hasColour() {
        return this.count > 0;
    }

    public int getColour() {
        int avgR = this.totalR / this.count;
        int avgG = this.totalG / this.count;
        int avgB = this.totalB / this.count;
        float avgTotal = (float)this.total / (float)this.count;
        float avgMax = Math.max(avgR, Math.max(avgG, avgB));
        avgR = (int)((float)avgR * avgTotal / avgMax);
        avgG = (int)((float)avgG * avgTotal / avgMax);
        avgB = (int)((float)avgB * avgTotal / avgMax);
        return avgR << 16 | avgG << 8 | avgB;
    }
}

