/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.BlockPos;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public final class DropConsumer {
    private static Function<ItemStack, ItemStack> dropConsumer;
    private static List<ItemStack> remainingDrops;
    private static WeakReference<World> dropWorld;
    private static BlockPos dropPos;
    private static AABB dropBounds;
    private static WeakReference<Entity> dropEntity;

    private DropConsumer() {
    }

    public static void set(Entity entity, Function<ItemStack, ItemStack> consumer) {
        dropConsumer = consumer;
        remainingDrops = new ArrayList<ItemStack>();
        dropEntity = new WeakReference<Entity>(entity);
        dropWorld = new WeakReference<World>(entity.world);
        dropPos = null;
        dropBounds = AABB.getPermanentBB((double)entity.x, (double)entity.y, (double)entity.z, (double)entity.x, (double)entity.y, (double)entity.z).expand(2.0, 2.0, 2.0);
    }

    public static void set(World world, BlockPos pos, Function<ItemStack, ItemStack> consumer) {
        dropConsumer = consumer;
        remainingDrops = new ArrayList<ItemStack>(2);
        dropEntity = null;
        dropWorld = new WeakReference<World>(world);
        dropBounds = AABB.getPermanentBB((double)pos.x, (double)pos.y, (double)pos.z, (double)pos.x, (double)pos.y, (double)pos.z).expand(2.0, 2.0, 2.0);
    }

    public static List<ItemStack> clear() {
        List<ItemStack> remainingStacks = remainingDrops;
        dropConsumer = null;
        remainingDrops = null;
        dropEntity = null;
        dropWorld = null;
        dropBounds = null;
        return remainingStacks;
    }

    public static boolean onHarvestDrops(World world, BlockPos pos, ItemStack stack) {
        if (dropWorld != null && dropWorld.get() == world && dropPos != null && dropPos.equals(pos)) {
            DropConsumer.handleDrops(stack);
            return true;
        }
        return false;
    }

    private static void handleDrops(ItemStack stack) {
        ItemStack remaining = dropConsumer.apply(stack);
        if (remaining != null && remaining.stackSize != 0) {
            remainingDrops.add(remaining);
        }
    }

    public static boolean onEntitySpawn(Entity entity) {
        if (dropWorld != null && dropWorld.get() == entity.world && entity instanceof EntityItem && dropBounds.contains(Vec3.getPermanentVec3((double)entity.x, (double)entity.y, (double)entity.z))) {
            DropConsumer.handleDrops(((EntityItem)entity).item);
            return true;
        }
        return false;
    }

    public static boolean onLivingDrops(Entity entity, ItemStack stack) {
        if (dropEntity != null && entity == dropEntity.get()) {
            DropConsumer.handleDrops(stack);
            return true;
        }
        return false;
    }
}

