/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.ItemStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static boolean areItemsStackable(@Nullable ItemStack a, @Nullable ItemStack b) {
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a == b || a.getItem().equals(b.getItem()) && a.getData().equals((Object)b.getData());
    }

    public static Container getInventory(World world, BlockPos pos, Direction side) {
        int y = pos.getY();
        if (y >= 0 && y < 256) {
            TileEntity tileEntity = world.getTileEntity(pos.x, pos.y, pos.z);
            Container inventory = InventoryUtil.getInventory(tileEntity);
            return inventory;
        }
        return null;
    }

    public static Container getInventory(TileEntity tileEntity) {
        if (tileEntity instanceof Container) {
            Container inventory = (Container)tileEntity;
            return inventory;
        }
        return null;
    }

    public static ItemStack storeItems(@Nonnull ItemStack itemstack, ItemStorage inventory, int begin) {
        return InventoryUtil.storeItems(itemstack, inventory, 0, inventory.size(), begin);
    }

    public static ItemStack storeItems(ItemStack stack, ItemStorage inventory, int start, int range, int begin) {
        if (stack == null) {
            return null;
        }
        ItemStack remainder = stack.copy();
        for (int i = 0; i < range; ++i) {
            int slot = start + (i + begin - start) % range;
            if (remainder == null) break;
            remainder = inventory.store(slot, remainder, false);
        }
        return InventoryUtil.areItemsEqual(stack, remainder) ? stack : remainder;
    }

    public static boolean areItemsEqual(ItemStack a, ItemStack b) {
        return a == b || ItemStack.areItemStacksEqual((ItemStack)a, (ItemStack)b);
    }

    public static ItemStack storeItems(@Nonnull ItemStack itemstack, ItemStorage inventory) {
        return InventoryUtil.storeItems(itemstack, inventory, 0, inventory.size(), 0);
    }

    @Nonnull
    public static ItemStack takeItems(int count, ItemStorage inventory, int begin) {
        return InventoryUtil.takeItems(count, inventory, 0, inventory.size(), begin);
    }

    public static ItemStack takeItems(int count, ItemStorage inventory, int start, int range, int begin) {
        ItemStack partialStack = null;
        for (int i = 0; i < range; ++i) {
            int slot = start + (i + begin - start) % range;
            if (count <= 0) break;
            ItemStack extracted = inventory.take(slot, count, partialStack, false);
            if (extracted == null) continue;
            count -= extracted.stackSize;
            if (partialStack == null) {
                partialStack = extracted;
                count = Math.min(count, extracted.getMaxStackSize());
                continue;
            }
            partialStack.stackSize += extracted.stackSize;
        }
        return partialStack;
    }

    public static ItemStack takeItems(int count, ItemStorage inventory) {
        return InventoryUtil.takeItems(count, inventory, 0, inventory.size(), 0);
    }
}

