/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;

public interface ItemStorage {
    public static ItemStorage wrap(Container inventory) {
        return new InventoryWrapper(inventory);
    }

    public static boolean areStackable(ItemStack a, ItemStack b) {
        return a == b || a.getItem().equals(b.getItem()) && a.getData().equals((Object)b.getData());
    }

    public int size();

    public ItemStack getStack(int var1);

    public ItemStack take(int var1, int var2, ItemStack var3, boolean var4);

    public ItemStack store(int var1, ItemStack var2, boolean var3);

    default public ItemStorage view(int start, int size) {
        return new View(this, start, size);
    }

    public static class InventoryWrapper
    implements ItemStorage {
        private final Container inventory;

        InventoryWrapper(Container inventory) {
            this.inventory = inventory;
        }

        @Override
        public int size() {
            return this.inventory.getContainerSize();
        }

        @Override
        public ItemStack getStack(int slot) {
            return this.inventory.getItem(slot);
        }

        @Override
        public ItemStack take(int slot, int limit, ItemStack filter, boolean simulate) {
            ItemStack existing = this.inventory.getItem(slot);
            if (existing == null || existing.stackSize == 0 || !this.canExtract(slot, existing) || filter != null && !ItemStorage.areStackable(existing, filter)) {
                return null;
            }
            if (simulate) {
                existing = existing.copy();
                if (existing.stackSize > limit) {
                    existing.stackSize = limit;
                }
                return existing;
            }
            if (existing.stackSize < limit) {
                this.setAndDirty(slot, null);
                return existing;
            }
            ItemStack result = existing.splitStack(limit);
            this.setAndDirty(slot, existing);
            return result;
        }

        protected boolean canExtract(int slot, ItemStack stack) {
            return true;
        }

        private void setAndDirty(int slot, ItemStack stack) {
            if (stack == null || stack.stackSize == 0) {
                this.inventory.setItem(slot, null);
            } else {
                this.inventory.setItem(slot, stack);
            }
            this.inventory.setChanged();
        }

        @Override
        public ItemStack store(int slot, ItemStack stack, boolean simulate) {
            if (stack == null) {
                return stack;
            }
            ItemStack existing = this.inventory.getItem(slot);
            if (existing == null) {
                int limit = Math.min(stack.getMaxStackSize(), this.inventory.getMaxStackSize());
                if (limit <= 0) {
                    return stack;
                }
                if (stack.stackSize < limit) {
                    if (!simulate) {
                        this.setAndDirty(slot, stack);
                    }
                    return null;
                }
                stack = stack.copy();
                ItemStack insert = stack.splitStack(limit);
                if (!simulate) {
                    this.setAndDirty(slot, insert);
                }
                return stack;
            }
            if (ItemStorage.areStackable(stack, existing)) {
                int limit = Math.min(existing.getMaxStackSize(), this.inventory.getMaxStackSize()) - existing.stackSize;
                if (limit <= 0) {
                    return stack;
                }
                if (stack.stackSize < limit) {
                    if (!simulate) {
                        existing.stackSize += stack.stackSize;
                        this.setAndDirty(slot, existing);
                    }
                    return null;
                }
                stack = stack.copy();
                stack.stackSize -= limit;
                if (!simulate) {
                    existing.stackSize += limit;
                    this.setAndDirty(slot, existing);
                }
                return stack;
            }
            return stack;
        }
    }

    public static class View
    implements ItemStorage {
        private final ItemStorage parent;
        private final int start;
        private final int size;

        View(ItemStorage parent, int start, int size) {
            this.parent = parent;
            this.start = start;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public ItemStack getStack(int slot) {
            if (slot < this.start || slot >= this.start + this.size) {
                return null;
            }
            return this.parent.getStack(slot - this.start);
        }

        @Override
        public ItemStack take(int slot, int limit, ItemStack filter, boolean simulate) {
            if (slot < this.start || slot >= this.start + this.size) {
                return null;
            }
            return this.parent.take(slot - this.start, limit, filter, simulate);
        }

        @Override
        public ItemStack store(int slot, ItemStack stack, boolean simulate) {
            if (slot < this.start || slot >= this.start + this.size) {
                return stack;
            }
            return this.parent.store(slot - this.start, stack, simulate);
        }

        @Override
        public ItemStorage view(int start, int size) {
            return new View(this.parent, this.start + start, size);
        }
    }
}

