/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.ByteArrayTag;
import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.DoubleTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.LongArrayTag;
import com.mojang.nbt.tags.LongTag;
import com.mojang.nbt.tags.StringTag;
import com.mojang.nbt.tags.Tag;
import dan200.computercraft.ComputerCraft;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;

public final class NBTUtil {
    public static final int TAG_END = 0;
    public static final int TAG_BYTE = 1;
    public static final int TAG_SHORT = 2;
    public static final int TAG_INT = 3;
    public static final int TAG_LONG = 4;
    public static final int TAG_FLOAT = 5;
    public static final int TAG_DOUBLE = 6;
    public static final int TAG_BYTE_ARRAY = 7;
    public static final int TAG_STRING = 8;
    public static final int TAG_LIST = 9;
    public static final int TAG_COMPOUND = 10;
    public static final int TAG_SHORT_ARRAY = 11;
    public static final int TAG_DOUBLE_ARRAY = 12;
    public static final int TAG_LONG_ARRAY = 13;

    private NBTUtil() {
    }

    private static Tag toNBTTag(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return new ByteTag((byte)((Boolean)object != false ? 1 : 0));
        }
        if (object instanceof Number) {
            return new DoubleTag(((Number)object).doubleValue());
        }
        if (object instanceof String) {
            return new StringTag(object.toString());
        }
        if (object instanceof Map) {
            Map m4 = (Map)object;
            CompoundTag nbt = new CompoundTag();
            int i = 0;
            for (Map.Entry entry : m4.entrySet()) {
                Tag key = NBTUtil.toNBTTag(entry.getKey());
                Tag value = NBTUtil.toNBTTag(entry.getKey());
                if (key == null || value == null) continue;
                nbt.put("k" + i, key);
                nbt.put("v" + i, value);
                ++i;
            }
            nbt.putInt("len", m4.size());
            return nbt;
        }
        return null;
    }

    public static CompoundTag encodeObjects(Object[] objects) {
        if (objects == null || objects.length <= 0) {
            return null;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("len", objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Tag child = NBTUtil.toNBTTag(objects[i]);
            if (child == null) continue;
            nbt.put(Integer.toString(i), child);
        }
        return nbt;
    }

    private static Object fromNBTTag(Tag tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.getId()) {
            case 1: {
                return (Byte)((ByteTag)tag).getValue() > 0;
            }
            case 6: {
                return ((DoubleTag)tag).getValue();
            }
            default: {
                return tag.getValue();
            }
            case 10: 
        }
        CompoundTag c = (CompoundTag)tag;
        int len = c.getInteger("len");
        HashMap<Object, Object> map = new HashMap<Object, Object>(len);
        for (int i = 0; i < len; ++i) {
            Object key = NBTUtil.fromNBTTag(c.getTag("k" + i));
            Object value = NBTUtil.fromNBTTag(c.getTag("v" + i));
            if (key == null || value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Object toLua(Tag tag) {
        if (tag == null) {
            return null;
        }
        byte typeID = tag.getId();
        switch (typeID) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ((LongTag)tag).getValue();
            }
            case 5: 
            case 6: {
                return ((DoubleTag)tag).getValue();
            }
            case 8: {
                return ((StringTag)tag).getValue();
            }
            case 10: {
                CompoundTag compound = (CompoundTag)tag;
                HashMap<String, Object> map = new HashMap<String, Object>(((Map)compound.getValue()).size());
                for (String key : ((Map)compound.getValue()).keySet()) {
                    Object value = NBTUtil.toLua(compound.getTag(key));
                    if (value == null) continue;
                    map.put(key, value);
                }
                return map;
            }
            case 9: {
                ListTag list = (ListTag)tag;
                HashMap<Integer, Object> map = new HashMap<Integer, Object>(((List)list.getValue()).size());
                for (int i2 = 0; i2 < ((List)list.getValue()).size(); ++i2) {
                    map.put(i2, NBTUtil.toLua((Tag)((List)list.getValue()).get(i2)));
                }
                return map;
            }
            case 7: {
                byte[] array = (byte[])((ByteArrayTag)tag).getValue();
                HashMap<Integer, Byte> map = new HashMap<Integer, Byte>(array.length);
                for (int i3 = 0; i3 < array.length; ++i3) {
                    map.put(i3 + 1, array[i3]);
                }
                return map;
            }
            case 13: {
                int[] array = Arrays.stream((long[])((LongArrayTag)tag).getValue()).mapToInt(i -> (int)i).toArray();
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(array.length);
                for (int i4 = 0; i4 < array.length; ++i4) {
                    map.put(i4 + 1, array[i4]);
                }
                return map;
            }
        }
        return null;
    }

    public static Object[] decodeObjects(CompoundTag tag) {
        int len = tag.getInteger("len");
        if (len <= 0) {
            return null;
        }
        Object[] objects = new Object[len];
        for (int i = 0; i < len; ++i) {
            String key = Integer.toString(i);
            if (!tag.containsKey(key)) continue;
            objects[i] = NBTUtil.fromNBTTag(tag.getTag(key));
        }
        return objects;
    }

    @Nullable
    public static String getNBTHash(@Nullable CompoundTag tag) {
        if (tag == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DataOutputStream output = new DataOutputStream(new DigestOutputStream(digest));
            NbtIo.write((CompoundTag)tag, (DataOutput)output);
            byte[] hash = digest.digest();
            return new String(Hex.encodeHex((byte[])hash));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            ComputerCraft.log.error("Cannot hash NBT", (Throwable)e);
            return null;
        }
    }

    private static final class DigestOutputStream
    extends OutputStream {
        private final MessageDigest digest;

        DigestOutputStream(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void write(int b) {
            this.digest.update((byte)b);
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) {
            this.digest.update(b, off, len);
        }
    }
}

