/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.shared.util.Colour;
import java.util.Arrays;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class Palette {
    public static final Palette DEFAULT = new Palette();
    private static final int PALETTE_SIZE = 16;
    private final double[][] colours = new double[16][3];

    public Palette() {
        this.resetColours();
    }

    public static int encodeRGB8(double[] rgb) {
        int r = (int)(rgb[0] * 255.0) & 0xFF;
        int g2 = (int)(rgb[1] * 255.0) & 0xFF;
        int b = (int)(rgb[2] * 255.0) & 0xFF;
        return r << 16 | g2 << 8 | b;
    }

    public static double[] decodeRGB8(int rgb) {
        return new double[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
    }

    public void resetColours() {
        for (int i = 0; i < Colour.VALUES.length; ++i) {
            this.resetColour(i);
        }
    }

    public void resetColour(int i) {
        if (i >= 0 && i < this.colours.length) {
            this.setColour(i, Colour.VALUES[i]);
        }
    }

    public void setColour(int i, Colour colour) {
        this.setColour(i, colour.getR(), colour.getG(), colour.getB());
    }

    public void setColour(int i, double r, double g2, double b) {
        if (i >= 0 && i < this.colours.length) {
            this.colours[i][0] = r;
            this.colours[i][1] = g2;
            this.colours[i][2] = b;
        }
    }

    public double[] getColour(int i) {
        if (i >= 0 && i < this.colours.length) {
            return this.colours[i];
        }
        return null;
    }

    public void write(UniversalPacket buffer) {
        double[][] dArray = this.colours;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] colour;
            for (double channel : colour = dArray[i]) {
                buffer.writeByte((int)(channel * 255.0) & 0xFF);
            }
        }
    }

    public void read(UniversalPacket buffer) {
        for (double[] colour : this.colours) {
            for (int i = 0; i < colour.length; ++i) {
                colour[i] = (double)(buffer.readByte() & 0xFF) / 255.0;
            }
        }
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        int[] rgb8 = new int[this.colours.length];
        for (int i = 0; i < this.colours.length; ++i) {
            rgb8[i] = Palette.encodeRGB8(this.colours[i]);
        }
        nbt.putLongArray("term_palette", Arrays.stream(rgb8).asLongStream().toArray());
        return nbt;
    }

    public void readFromNBT(CompoundTag nbt) {
        if (!nbt.containsKey("term_palette")) {
            return;
        }
        int[] rgb8 = Arrays.stream(nbt.getLongArray("term_palette")).mapToInt(i -> (int)i).toArray();
        if (rgb8.length != this.colours.length) {
            return;
        }
        for (int i2 = 0; i2 < this.colours.length; ++i2) {
            this.colours[i2] = Palette.decodeRGB8(rgb8[i2]);
        }
    }
}

