/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.base.Predicate;
import com.google.common.collect.MapMaker;
import dan200.computercraft.shared.util.BlockPos;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import org.apache.commons.lang3.tuple.Pair;

public final class WorldUtil {
    private static final Predicate<Entity> CAN_COLLIDE = x -> x != null && x.isAlive();
    private static final Map<World, Entity> entityCache = new MapMaker().weakKeys().weakValues().makeMap();

    public static boolean isLiquidBlock(World world, BlockPos pos) {
        if (256 >= pos.y) {
            return false;
        }
        return world.getBlock(pos.x, pos.y, pos.z).getMaterial().isLiquid();
    }

    public static Pair<Entity, Vec3> rayTraceEntities(World world, Vec3 vecStart, Vec3 vecDir, double distance) {
        vecStart = vecStart.add(0.5, 0.5, 0.5);
        Vec3 vecEnd = vecStart.add(vecDir.x * distance, vecDir.y * distance, vecDir.z * distance);
        Vec3 vecStartBlock = vecStart.add(vecDir.x * 0.51, vecDir.y * 0.51, vecDir.z * 0.51);
        HitResult result = world.checkBlockCollisionBetweenPoints(vecStartBlock, vecEnd, true, true, true);
        if (result != null && result.hitType == HitResult.HitType.TILE) {
            distance = vecStart.distanceTo(result.location);
            vecEnd = vecStart.add(vecDir.x * distance, vecDir.y * distance, vecDir.z * distance);
        }
        float xStretch = Math.abs(vecDir.x) > 0.25 ? 0.0f : 1.0f;
        float yStretch = Math.abs(vecDir.y) > 0.25 ? 0.0f : 1.0f;
        float zStretch = Math.abs(vecDir.z) > 0.25 ? 0.0f : 1.0f;
        AABB bigBox = AABB.getPermanentBB((double)(Math.min(vecStart.x, vecEnd.x) - (double)(0.375f * xStretch)), (double)(Math.min(vecStart.y, vecEnd.y) - (double)(0.375f * yStretch)), (double)(Math.min(vecStart.z, vecEnd.z) - (double)(0.375f * zStretch)), (double)(Math.max(vecStart.x, vecEnd.x) + (double)(0.375f * xStretch)), (double)(Math.max(vecStart.y, vecEnd.y) + (double)(0.375f * yStretch)), (double)(Math.max(vecStart.z, vecEnd.z) + (double)(0.375f * zStretch)));
        Entity closest = null;
        double closestDist = 99.0;
        List list = world.getEntitiesWithinAABB(Entity.class, bigBox);
        for (Entity entity : list) {
            AABB littleBox = entity.bb;
            if (littleBox.contains(vecStart)) {
                closest = entity;
                closestDist = 0.0;
                continue;
            }
            HitResult littleBoxResult = littleBox.clip(vecStart, vecEnd);
            if (littleBoxResult != null) {
                double dist = vecStart.distanceTo(littleBoxResult.location);
                if (closest != null && !(dist <= closestDist)) continue;
                closest = entity;
                closestDist = dist;
                continue;
            }
            if (!littleBox.intersects(bigBox) || closest != null) continue;
            closest = entity;
            closestDist = distance;
        }
        if (closest != null && closestDist <= distance) {
            Vec3 closestPos = vecStart.add(vecDir.x * closestDist, vecDir.y * closestDist, vecDir.z * closestDist);
            return Pair.of((Object)closest, (Object)closestPos);
        }
        return null;
    }

    private static synchronized Entity getEntity(World world) {
        Entity entity = entityCache.get(world);
        if (entity != null) {
            return entity;
        }
        entity = new EntityItem(world);
        entityCache.put(world, entity);
        return entity;
    }

    public static Vec3 getRayEnd(Player player) {
        double reach = 5.0;
        Vec3 look = player.getLookAngle();
        return WorldUtil.getRayStart((Mob)player).add(look.x * reach, look.y * reach, look.z * reach);
    }

    public static Vec3 getRayStart(Mob entity) {
        return entity.getViewVector(1.0f);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, BlockPos pos) {
        WorldUtil.dropItemStack(stack, world, pos, null);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, BlockPos pos, Direction direction) {
        double zDir;
        double yDir;
        double xDir;
        if (direction != null) {
            xDir = direction.getOffsetX();
            yDir = direction.getOffsetY();
            zDir = direction.getOffsetZ();
        } else {
            xDir = 0.0;
            yDir = 0.0;
            zDir = 0.0;
        }
        double xPos = (double)pos.getX() + 0.5 + xDir * 0.4;
        double yPos = (double)pos.getY() + 0.5 + yDir * 0.4;
        double zPos = (double)pos.getZ() + 0.5 + zDir * 0.4;
        WorldUtil.dropItemStack(stack, world, Vec3.getPermanentVec3((double)xPos, (double)yPos, (double)zPos), xDir, yDir, zDir);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, Vec3 pos, double xDir, double yDir, double zDir) {
        EntityItem item = new EntityItem(world, pos.x, pos.y, pos.z, stack.copy());
        item.xd = xDir * 0.7 + (double)world.rand.nextFloat() * 0.2 - 0.1;
        item.yd = yDir * 0.7 + (double)world.rand.nextFloat() * 0.2 - 0.1;
        item.zd = zDir * 0.7 + (double)world.rand.nextFloat() * 0.2 - 0.1;
        item.pickupDelay = 40;
        world.entityJoinedWorld((Entity)item);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, World world, Vec3 pos) {
        WorldUtil.dropItemStack(stack, world, pos, 0.0, 0.0, 0.0);
    }
}

