/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.wired;

import dan200.computercraft.api.network.wired.IWiredNetworkChange;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.wired.WiredNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public final class WiredNetworkChange
implements IWiredNetworkChange {
    private static final WiredNetworkChange EMPTY = new WiredNetworkChange(Collections.emptyMap(), Collections.emptyMap());
    private final Map<String, IPeripheral> removed;
    private final Map<String, IPeripheral> added;

    private WiredNetworkChange(Map<String, IPeripheral> removed, Map<String, IPeripheral> added) {
        this.removed = removed;
        this.added = added;
    }

    public static WiredNetworkChange added(Map<String, IPeripheral> added) {
        return added.isEmpty() ? EMPTY : new WiredNetworkChange(Collections.emptyMap(), Collections.unmodifiableMap(added));
    }

    public static WiredNetworkChange removed(Map<String, IPeripheral> removed) {
        return removed.isEmpty() ? EMPTY : new WiredNetworkChange(Collections.unmodifiableMap(removed), Collections.emptyMap());
    }

    public static WiredNetworkChange changeOf(Map<String, IPeripheral> oldPeripherals, Map<String, IPeripheral> newPeripherals) {
        if (oldPeripherals.isEmpty() && newPeripherals.isEmpty()) {
            return EMPTY;
        }
        if (oldPeripherals.isEmpty()) {
            return new WiredNetworkChange(Collections.emptyMap(), newPeripherals);
        }
        if (newPeripherals.isEmpty()) {
            return new WiredNetworkChange(oldPeripherals, Collections.emptyMap());
        }
        HashMap<String, IPeripheral> added = new HashMap<String, IPeripheral>(newPeripherals);
        HashMap<String, IPeripheral> removed = new HashMap<String, IPeripheral>();
        for (Map.Entry<String, IPeripheral> entry : oldPeripherals.entrySet()) {
            String oldKey = entry.getKey();
            IPeripheral oldValue = entry.getValue();
            if (newPeripherals.containsKey(oldKey)) {
                IPeripheral rightValue = (IPeripheral)added.get(oldKey);
                if (oldValue.equals(rightValue)) {
                    added.remove(oldKey);
                    continue;
                }
                removed.put(oldKey, oldValue);
                continue;
            }
            removed.put(oldKey, oldValue);
        }
        return WiredNetworkChange.changed(removed, added);
    }

    public static WiredNetworkChange changed(Map<String, IPeripheral> removed, Map<String, IPeripheral> added) {
        return new WiredNetworkChange(Collections.unmodifiableMap(removed), Collections.unmodifiableMap(added));
    }

    @Override
    @Nonnull
    public Map<String, IPeripheral> peripheralsRemoved() {
        return this.removed;
    }

    @Override
    @Nonnull
    public Map<String, IPeripheral> peripheralsAdded() {
        return this.added;
    }

    void broadcast(Iterable<WiredNode> nodes) {
        if (!this.isEmpty()) {
            for (WiredNode node : nodes) {
                node.element.networkChanged(this);
            }
        }
    }

    public boolean isEmpty() {
        return this.added.isEmpty() && this.removed.isEmpty();
    }

    void broadcast(WiredNode node) {
        if (!this.isEmpty()) {
            node.element.networkChanged(this);
        }
    }
}

