/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.debug.DebugHelpers;
import org.squiddev.cobalt.lib.UncheckedLuaError;

public final class LuaError
extends Exception {
    private static final long serialVersionUID = 3065540200206862088L;
    public LuaValue value;
    public String traceback;
    private final int level;
    private final boolean calculateLevel;

    public LuaError(Throwable cause) {
        super(cause);
        this.level = 1;
        this.calculateLevel = true;
        this.value = ValueFactory.valueOf("vm error: " + cause.toString());
    }

    public LuaError(String message) {
        super(message);
        this.level = 1;
        this.calculateLevel = true;
        this.value = ValueFactory.valueOf(message);
    }

    public LuaError(String message, int level) {
        super(message);
        this.level = level;
        this.calculateLevel = false;
        this.value = ValueFactory.valueOf(message);
    }

    public LuaError(LuaValue message) {
        super(LuaError.rawToString(message));
        this.level = 1;
        this.calculateLevel = true;
        this.value = message;
    }

    public LuaError(LuaValue message, int level) {
        super(LuaError.rawToString(message));
        this.level = level;
        this.calculateLevel = false;
        this.value = message;
    }

    public static LuaError wrap(Throwable error) {
        if (error instanceof LuaError) {
            return (LuaError)error;
        }
        if (error instanceof UncheckedLuaError) {
            return ((UncheckedLuaError)error).getCause();
        }
        return new LuaError(error);
    }

    public static LuaError wrapMessage(Throwable error) {
        if (error instanceof LuaError) {
            return (LuaError)error;
        }
        if (error instanceof UncheckedLuaError) {
            return ((UncheckedLuaError)error).getCause();
        }
        String message = error.getMessage();
        return new LuaError(message == null ? Constants.NIL : LuaString.valueOf(message));
    }

    public static LuaValue getMessage(Exception error) {
        if (error instanceof LuaError) {
            return ((LuaError)error).value;
        }
        if (error instanceof UncheckedLuaError) {
            return ((UncheckedLuaError)error).getCause().value;
        }
        String message = error.getMessage();
        return message == null ? Constants.NIL : LuaString.valueOf(message);
    }

    @Override
    public String getMessage() {
        return this.traceback != null ? this.traceback : LuaError.rawToString(this.value);
    }

    public void fillTracebackNoHandler(LuaState state) {
        if (this.traceback != null) {
            return;
        }
        this.fillTracebackImpl(state);
        if (state.getCurrentThread().getErrorFunc() != null) {
            throw new IllegalStateException("Thread has no error function");
        }
    }

    public void fillTraceback(LuaState state) throws UnwindThrowable {
        if (this.traceback != null) {
            return;
        }
        this.fillTracebackImpl(state);
        if (state.getCurrentThread().getErrorFunc() != null) {
            LuaValue errFunc = state.getCurrentThread().setErrorFunc(null);
            try {
                this.value = OperationHelper.call(state, errFunc, this.value);
            }
            catch (Exception | VirtualMachineError t2) {
                this.value = ValueFactory.valueOf("error in error handling");
                state.getCurrentThread().setErrorFunc(errFunc);
            }
        }
    }

    private void fillTracebackImpl(LuaState state) {
        String fileLine;
        LuaThread thread = state.getCurrentThread();
        if (this.level > 0 && this.value.isString() && (fileLine = this.calculateLevel ? DebugHelpers.fileLine(thread) : DebugHelpers.fileLine(thread, this.level - 1)) != null) {
            this.value = ValueFactory.valueOf(fileLine + ": " + this.value.toString());
        }
        this.traceback = this.getMessage() + "\n" + DebugHelpers.traceback(thread, this.level - 1);
    }

    private static String rawToString(LuaValue value) {
        switch (value.type()) {
            case 2: 
            case 5: 
            case 7: {
                return value.typeName() + ": " + Integer.toHexString(value.hashCode());
            }
        }
        return value.toString();
    }
}

