/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import java.util.Arrays;
import java.util.List;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaBoolean;
import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaUserdata;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Varargs;

public class ValueFactory {
    private static final int MAX_DEPTH = 5;

    public static LuaBoolean valueOf(boolean b) {
        return b ? Constants.TRUE : Constants.FALSE;
    }

    public static LuaInteger valueOf(int i) {
        return LuaInteger.valueOf(i);
    }

    public static LuaNumber valueOf(double d) {
        return LuaDouble.valueOf(d);
    }

    public static LuaString valueOf(String s2) {
        return LuaString.valueOf(s2);
    }

    public static LuaString valueOf(byte[] bytes) {
        return LuaString.valueOf(bytes);
    }

    public static LuaString valueOf(byte[] bytes, int off, int len) {
        return LuaString.valueOf(bytes, off, len);
    }

    public static LuaTable tableOf() {
        return new LuaTable();
    }

    public static LuaTable tableOf(Varargs varargs, int firstarg) {
        return new LuaTable(varargs, firstarg);
    }

    public static LuaTable tableOf(int narray, int nhash) {
        return new LuaTable(narray, nhash);
    }

    public static LuaTable listOf(LuaValue ... unnamedValues) {
        return new LuaTable(null, unnamedValues, null);
    }

    public static LuaTable listOf(LuaValue[] unnamedValues, Varargs lastarg) {
        return new LuaTable(null, unnamedValues, lastarg);
    }

    public static LuaTable tableOf(LuaValue ... namedValues) {
        return new LuaTable(namedValues, null, null);
    }

    public static LuaTable tableOf(LuaValue[] namedValues, LuaValue[] unnamedValues) {
        return new LuaTable(namedValues, unnamedValues, null);
    }

    public static LuaTable tableOf(LuaValue[] namedValues, LuaValue[] unnamedValues, Varargs lastarg) {
        return new LuaTable(namedValues, unnamedValues, lastarg);
    }

    public static LuaUserdata userdataOf(Object o) {
        return new LuaUserdata(o);
    }

    public static LuaUserdata userdataOf(Object o, LuaTable metatable) {
        return new LuaUserdata(o, metatable);
    }

    @Deprecated
    public static Varargs varargsOf(LuaValue v) {
        return v;
    }

    public static Varargs varargsOf(LuaValue ... v) {
        switch (v.length) {
            case 0: {
                return Constants.NONE;
            }
            case 1: {
                return v[0];
            }
            case 2: {
                return new LuaValue.PairVarargs(v[0], v[1]);
            }
        }
        return new LuaValue.ArrayVarargs(v, Constants.NONE);
    }

    public static Varargs varargsOf(List<LuaValue> v) {
        switch (v.size()) {
            case 0: {
                return Constants.NONE;
            }
            case 1: {
                return v.get(0);
            }
            case 2: {
                return new LuaValue.PairVarargs(v.get(0), v.get(1));
            }
        }
        return new LuaValue.ArrayVarargs(v.toArray(new LuaValue[0]), Constants.NONE);
    }

    public static Varargs varargsOf(LuaValue[] v, Varargs r) {
        if (v.length == 0) {
            return r;
        }
        if (Varargs.DepthVarargs.depth(r) > 5) {
            LuaValue[] values = Arrays.copyOf(v, v.length + r.count());
            r.fill(values, v.length);
            return new LuaValue.ArrayVarargs(values, Constants.NONE);
        }
        return v.length == 1 ? new LuaValue.PairVarargs(v[0], r) : new LuaValue.ArrayVarargs(v, r);
    }

    public static Varargs varargsOf(LuaValue[] v, int offset, int length) {
        switch (length) {
            case 0: {
                return Constants.NONE;
            }
            case 1: {
                return v[offset];
            }
            case 2: {
                return new LuaValue.PairVarargs(v[offset + 0], v[offset + 1]);
            }
        }
        return new LuaValue.ArrayPartVarargs(v, offset, length);
    }

    public static Varargs varargsOf(LuaValue[] v, int offset, int length, Varargs more) {
        if (length == 0) {
            return more;
        }
        if (Varargs.DepthVarargs.depth(more) > 5) {
            LuaValue[] values = new LuaValue[length + more.count()];
            System.arraycopy(v, offset, values, 0, length);
            more.fill(values, length);
            return new LuaValue.ArrayVarargs(values, Constants.NONE);
        }
        return length == 1 ? new LuaValue.PairVarargs(v[offset], more) : new LuaValue.ArrayPartVarargs(v, offset, length, more);
    }

    public static Varargs varargsOf(LuaValue v, Varargs r) {
        if (Varargs.DepthVarargs.depth(r) > 5) {
            LuaValue[] values = new LuaValue[1 + r.count()];
            values[0] = v;
            r.fill(values, 1);
            return new LuaValue.ArrayVarargs(values, Constants.NONE);
        }
        return r.count() == 0 ? v : new LuaValue.PairVarargs(v, r);
    }

    public static Varargs varargsOf(LuaValue v1, LuaValue v2, Varargs v3) {
        if (Varargs.DepthVarargs.depth(v3) > 5) {
            LuaValue[] values = new LuaValue[2 + v3.count()];
            values[0] = v1;
            values[1] = v2;
            v3.fill(values, 2);
            return new LuaValue.ArrayVarargs(values, Constants.NONE);
        }
        return v3.count() == 0 ? new LuaValue.PairVarargs(v1, v2) : new LuaValue.ArrayVarargs(new LuaValue[]{v1, v2}, v3);
    }

    public static LuaTable weakTable(boolean weakKeys, boolean weakValues) {
        LuaTable table = new LuaTable();
        table.useWeak(weakKeys, weakValues);
        return table;
    }
}

