/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.compiler;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.function.LocalVariable;

public class DumpState {
    public static final String LUA_SIGNATURE = "\u001bLua";
    public static final int LUAC_VERSION = 81;
    public static final int LUAC_FORMAT = 0;
    public static final int LUAC_HEADERSIZE = 12;
    private static final byte[] LUAC_HEADER_SIGNATURE = new byte[]{27, 76, 117, 97};
    public static boolean ALLOW_INTEGER_CASTING = false;
    public static final int NUMBER_FORMAT_FLOATS_OR_DOUBLES = 0;
    public static final int NUMBER_FORMAT_INTS_ONLY = 1;
    public static final int NUMBER_FORMAT_NUM_PATCH_INT32 = 4;
    public static final int NUMBER_FORMAT_DEFAULT = 0;
    private boolean IS_LITTLE_ENDIAN = true;
    private int NUMBER_FORMAT = 0;
    private int SIZEOF_LUA_NUMBER = 8;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_SIZET = 4;
    private static final int SIZEOF_INSTRUCTION = 4;
    DataOutputStream writer;
    boolean strip;
    int status;

    public DumpState(OutputStream w, boolean strip) {
        this.writer = new DataOutputStream(w);
        this.strip = strip;
        this.status = 0;
    }

    void dumpBlock(byte[] b, int size) throws IOException {
        this.writer.write(b, 0, size);
    }

    void dumpChar(int b) throws IOException {
        this.writer.write(b);
    }

    void dumpInt(int x) throws IOException {
        if (this.IS_LITTLE_ENDIAN) {
            this.writer.writeByte(x & 0xFF);
            this.writer.writeByte(x >> 8 & 0xFF);
            this.writer.writeByte(x >> 16 & 0xFF);
            this.writer.writeByte(x >> 24 & 0xFF);
        } else {
            this.writer.writeInt(x);
        }
    }

    void dumpString(LuaString s2) throws IOException {
        int len = s2.length();
        this.dumpInt(len + 1);
        s2.write(this.writer, 0, len);
        this.writer.write(0);
    }

    void dumpDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        if (this.IS_LITTLE_ENDIAN) {
            this.dumpInt((int)l);
            this.dumpInt((int)(l >> 32));
        } else {
            this.writer.writeLong(l);
        }
    }

    void dumpCode(Prototype f) throws IOException {
        int[] code = f.code;
        int n = code.length;
        this.dumpInt(n);
        for (int aCode : code) {
            this.dumpInt(aCode);
        }
    }

    void dumpConstants(Prototype f) throws IOException {
        int i;
        LuaValue[] k = f.k;
        int n = k.length;
        this.dumpInt(n);
        block11: for (i = 0; i < n; ++i) {
            LuaValue o = k[i];
            switch (o.type()) {
                case 0: {
                    this.writer.write(0);
                    continue block11;
                }
                case 1: {
                    this.writer.write(1);
                    this.dumpChar(o.toBoolean() ? 1 : 0);
                    continue block11;
                }
                case 3: {
                    switch (this.NUMBER_FORMAT) {
                        case 0: {
                            this.writer.write(3);
                            this.dumpDouble(o.toDouble());
                            continue block11;
                        }
                        case 1: {
                            if (!ALLOW_INTEGER_CASTING && !o.isInteger()) {
                                throw new IllegalArgumentException("not an integer: " + o);
                            }
                            this.writer.write(3);
                            this.dumpInt(o.toInteger());
                            continue block11;
                        }
                        case 4: {
                            if (o.isInteger()) {
                                this.writer.write(-2);
                                this.dumpInt(o.toInteger());
                                continue block11;
                            }
                            this.writer.write(3);
                            this.dumpDouble(o.toDouble());
                            continue block11;
                        }
                    }
                    throw new IllegalArgumentException("number format not supported: " + this.NUMBER_FORMAT);
                }
                case 4: {
                    this.writer.write(4);
                    this.dumpString((LuaString)o);
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("bad type for " + o);
                }
            }
        }
        n = f.p.length;
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            this.dumpFunction(f.p[i], f.source);
        }
    }

    void dumpDebug(Prototype f) throws IOException {
        int i;
        int n = this.strip ? 0 : f.lineinfo.length;
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            this.dumpInt(f.lineinfo[i]);
        }
        n = this.strip ? 0 : f.locvars.length;
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            LocalVariable lvi = f.locvars[i];
            this.dumpString(lvi.name);
            this.dumpInt(lvi.startpc);
            this.dumpInt(lvi.endpc);
        }
        n = this.strip ? 0 : f.upvalues.length;
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            this.dumpString(f.upvalues[i]);
        }
    }

    void dumpFunction(Prototype f, LuaString string) throws IOException {
        if (f.source == null || f.source.equals(string) || this.strip) {
            this.dumpInt(0);
        } else {
            this.dumpString(f.source);
        }
        this.dumpInt(f.linedefined);
        this.dumpInt(f.lastlinedefined);
        this.dumpChar(f.nups);
        this.dumpChar(f.numparams);
        this.dumpChar(f.is_vararg);
        this.dumpChar(f.maxstacksize);
        this.dumpCode(f);
        this.dumpConstants(f);
        this.dumpDebug(f);
    }

    void dumpHeader() throws IOException {
        this.writer.write(LUAC_HEADER_SIGNATURE);
        this.writer.write(81);
        this.writer.write(0);
        this.writer.write(this.IS_LITTLE_ENDIAN ? 1 : 0);
        this.writer.write(4);
        this.writer.write(4);
        this.writer.write(4);
        this.writer.write(this.SIZEOF_LUA_NUMBER);
        this.writer.write(this.NUMBER_FORMAT);
    }

    public static int dump(Prototype f, OutputStream w, boolean strip) throws IOException {
        DumpState D = new DumpState(w, strip);
        D.dumpHeader();
        D.dumpFunction(f, null);
        return D.status;
    }

    public static int dump(Prototype f, OutputStream w, boolean stripDebug, int numberFormat, boolean littleendian) throws IOException {
        switch (numberFormat) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("number format not supported: " + numberFormat);
            }
        }
        DumpState D = new DumpState(w, stripDebug);
        D.IS_LITTLE_ENDIAN = littleendian;
        D.NUMBER_FORMAT = numberFormat;
        D.SIZEOF_LUA_NUMBER = numberFormat == 1 ? 4 : 8;
        D.dumpHeader();
        D.dumpFunction(f, null);
        return D.status;
    }
}

