/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.compiler;

import java.io.IOException;
import java.io.InputStream;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.compiler.BytecodeLoader;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.LuaInterpretedFunction;

public final class LoadState {
    private static final byte[] LUA_SIGNATURE = new byte[]{27, 76, 117, 97};
    public static final LuaString SOURCE_BINARY_STRING = ValueFactory.valueOf("=?");
    private static final int NAME_LENGTH = 60;
    private static final int FILE_LENGTH = 60 - " '...' ".length() - 1;
    private static final int STRING_LENGTH = 60 - " [string \"...\"] ".length() - 1;
    private static final LuaString REMAINING = ValueFactory.valueOf("...");
    private static final LuaString STRING = ValueFactory.valueOf("[string \"");
    private static final LuaString EMPTY_STRING = ValueFactory.valueOf("[string \"\"]");
    private static final LuaString NEW_LINES = ValueFactory.valueOf("\r\n");

    public static LuaFunction load(LuaState state, InputStream stream, String name, LuaTable env) throws IOException, CompileException {
        return LoadState.load(state, stream, ValueFactory.valueOf(name), env);
    }

    public static LuaFunction load(LuaState state, InputStream stream, LuaString name, LuaTable env) throws IOException, CompileException {
        return LoadState.load(state, stream, name, null, env);
    }

    public static LuaFunction load(LuaState state, InputStream stream, LuaString name, LuaString mode, LuaTable env) throws IOException, CompileException {
        if (state.compiler != null) {
            return state.compiler.load(stream, name, mode, env);
        }
        int firstByte = stream.read();
        if (firstByte != LUA_SIGNATURE[0]) {
            throw new CompileException("no compiler");
        }
        LoadState.checkMode(mode, "binary");
        Prototype p = LoadState.loadBinaryChunk(firstByte, stream, name);
        LuaInterpretedFunction closure = new LuaInterpretedFunction(p, env);
        closure.nilUpvalues();
        return closure;
    }

    public static Prototype loadBinaryChunk(int firstByte, InputStream stream, LuaString name) throws IOException, CompileException {
        name = LoadState.getSourceName(name);
        if (firstByte != LUA_SIGNATURE[0] || stream.read() != LUA_SIGNATURE[1] || stream.read() != LUA_SIGNATURE[2] || stream.read() != LUA_SIGNATURE[3]) {
            throw new IllegalArgumentException("bad signature");
        }
        BytecodeLoader s2 = new BytecodeLoader(stream);
        s2.loadHeader();
        return s2.loadFunction(name);
    }

    public static LuaString getSourceName(LuaString name) {
        if (name.length > 0) {
            byte first = name.bytes[name.offset];
            switch (first) {
                case 61: 
                case 64: {
                    return name.substring(1);
                }
                case 27: {
                    return SOURCE_BINARY_STRING;
                }
            }
            return name;
        }
        return name;
    }

    public static LuaString getShortName(LuaString name) {
        if (name.length == 0) {
            return EMPTY_STRING;
        }
        switch (name.luaByte(0)) {
            case 61: {
                return name.substring(1, Math.min(60, name.length));
            }
            case 64: {
                if (name.length - 1 > FILE_LENGTH) {
                    byte[] bytes = new byte[FILE_LENGTH + 3];
                    REMAINING.copyTo(bytes, 0);
                    name.copyTo(name.length - FILE_LENGTH, bytes, LoadState.REMAINING.length, FILE_LENGTH);
                    return ValueFactory.valueOf(bytes);
                }
                return name.substring(1);
            }
        }
        int len = name.indexOfAny(NEW_LINES);
        boolean truncate = false;
        if (len < 0) {
            len = name.length;
        } else {
            truncate = true;
        }
        if (len > STRING_LENGTH) {
            truncate = true;
            len = STRING_LENGTH;
        }
        byte[] out = new byte[60];
        STRING.copyTo(out, 0);
        int offset = LoadState.STRING.length;
        offset = name.copyTo(0, out, offset, len);
        if (truncate) {
            offset = REMAINING.copyTo(out, offset);
        }
        out[offset++] = 34;
        out[offset++] = 93;
        return LuaString.valueOf(out, 0, offset);
    }

    public static void checkMode(LuaString mode, String current) throws CompileException {
        if (mode != null && mode.indexOf((byte)current.charAt(0), 0) == -1) {
            throw new CompileException("attempt to load a " + current + " chunk (mode is " + mode + ")");
        }
    }

    public static interface LuaCompiler {
        public LuaFunction load(InputStream var1, LuaString var2, LuaString var3, LuaTable var4) throws IOException, CompileException;
    }
}

