/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.NonResumableException;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.ResumableVarArgFunction;
import org.squiddev.cobalt.lib.LuaLibrary;

public class CoroutineLib
extends ResumableVarArgFunction<Object>
implements LuaLibrary {
    private static final int CREATE = 0;
    private static final int RESUME = 1;
    private static final int RUNNING = 2;
    private static final int STATUS = 3;
    private static final int YIELD = 4;
    private static final int WRAP = 5;
    private static final int WRAPPED = 6;
    private final LuaThread thread;

    public CoroutineLib() {
        this.thread = null;
    }

    private CoroutineLib(LuaThread thread) {
        this.thread = thread;
    }

    @Override
    public LuaValue add(LuaState state, LuaTable env) {
        LuaTable t2 = new LuaTable();
        CoroutineLib.bind(t2, CoroutineLib::new, new String[]{"create", "resume", "running", "status", "yield", "wrap"});
        env.rawset("coroutine", (LuaValue)t2);
        state.loadedPackages.rawset("coroutine", (LuaValue)t2);
        return t2;
    }

    @Override
    public Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
        switch (this.opcode) {
            case 0: {
                LuaFunction func = args.arg(1).checkFunction();
                return new LuaThread(state, func, state.getCurrentThread().getfenv());
            }
            case 1: {
                di.flags |= 0x10;
                LuaThread thread = args.arg(1).checkThread();
                try {
                    Varargs result = LuaThread.resume(state, thread, args.subargs(2));
                    return ValueFactory.varargsOf((LuaValue)Constants.TRUE, result);
                }
                catch (LuaError le) {
                    return ValueFactory.varargsOf((LuaValue)Constants.FALSE, (Varargs)le.value);
                }
            }
            case 2: {
                LuaThread r = state.getCurrentThread();
                return r.isMainThread() ? Constants.NIL : r;
            }
            case 3: {
                return ValueFactory.valueOf(args.arg(1).checkThread().getStatus());
            }
            case 4: {
                return LuaThread.yield(state, args);
            }
            case 5: {
                LuaFunction func = args.arg(1).checkFunction();
                LuaTable env = func.getfenv();
                LuaThread thread = new LuaThread(state, func, env);
                CoroutineLib cl = new CoroutineLib(thread);
                cl.setfenv(env);
                cl.name = "wrapped";
                cl.opcode = 6;
                return cl;
            }
            case 6: {
                return LuaThread.resume(state, this.thread, args);
            }
        }
        return Constants.NONE;
    }

    @Override
    public Varargs resumeThis(LuaState state, Object object, Varargs value) {
        switch (this.opcode) {
            case 4: 
            case 6: {
                return value;
            }
            case 1: {
                return ValueFactory.varargsOf((LuaValue)Constants.TRUE, value);
            }
        }
        throw new NonResumableException("Cannot resume " + this.debugName());
    }

    @Override
    public Varargs resumeErrorThis(LuaState state, Object object, LuaError error) {
        switch (this.opcode) {
            case 1: {
                return ValueFactory.varargsOf((LuaValue)Constants.FALSE, (Varargs)error.value);
            }
        }
        throw new NonResumableException("Cannot resume " + this.debugName());
    }
}

