/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import java.util.Random;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.OneArgFunction;
import org.squiddev.cobalt.function.TwoArgFunction;
import org.squiddev.cobalt.function.VarArgFunction;
import org.squiddev.cobalt.lib.LuaLibrary;

public class MathLib
implements LuaLibrary {
    @Override
    public LuaValue add(LuaState state, LuaTable env) {
        LuaTable t2 = new LuaTable(0, 30);
        t2.rawset("pi", (LuaValue)ValueFactory.valueOf(Math.PI));
        t2.rawset("huge", (LuaValue)LuaDouble.POSINF);
        LibFunction.bind(t2, () -> new MathLib1(), new String[]{"abs", "ceil", "cos", "deg", "exp", "floor", "rad", "sin", "sqrt", "tan", "acos", "asin", "atan", "cosh", "exp", "log10", "sinh", "tanh"});
        LibFunction.bind(t2, () -> new MathLib2(), new String[]{"fmod", "ldexp", "pow", "atan2", "log"});
        LibFunction.bind(t2, () -> new MathLibV(), new String[]{"frexp", "max", "min", "modf", "randomseed", "random"});
        t2.rawset("mod", t2.rawget("fmod"));
        env.rawset("math", (LuaValue)t2);
        state.loadedPackages.rawset("math", (LuaValue)t2);
        return t2;
    }

    private static final class MathLibV
    extends VarArgFunction {
        private MathLibV() {
        }

        @Override
        public Varargs invoke(LuaState state, Varargs args) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    double x = args.arg(1).checkDouble();
                    if (x == 0.0) {
                        return ValueFactory.varargsOf((LuaValue)Constants.ZERO, (Varargs)Constants.ZERO);
                    }
                    long bits = Double.doubleToLongBits(x);
                    double m4 = (double)((bits & 0xFFFFFFFFFFFFFL) + 0x10000000000000L) * (bits >= 0L ? (double)1.110223E-16f : (double)-1.110223E-16f);
                    double e = ((int)(bits >> 52) & 0x7FF) - 1022;
                    return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(m4), (Varargs)ValueFactory.valueOf(e));
                }
                case 1: {
                    double m5 = args.arg(1).checkDouble();
                    int n = args.count();
                    for (int i = 2; i <= n; ++i) {
                        m5 = Math.max(m5, args.arg(i).checkDouble());
                    }
                    return ValueFactory.valueOf(m5);
                }
                case 2: {
                    double m6 = args.arg(1).checkDouble();
                    int n = args.count();
                    for (int i = 2; i <= n; ++i) {
                        m6 = Math.min(m6, args.arg(i).checkDouble());
                    }
                    return ValueFactory.valueOf(m6);
                }
                case 3: {
                    double x = args.arg(1).checkDouble();
                    double intPart = x > 0.0 ? Math.floor(x) : Math.ceil(x);
                    double fracPart = x - intPart;
                    return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(intPart), (Varargs)ValueFactory.valueOf(fracPart));
                }
                case 4: {
                    long seed = args.arg(1).checkLong();
                    state.random = new Random(seed);
                    return Constants.NONE;
                }
                case 5: {
                    if (state.random == null) {
                        state.random = new Random();
                    }
                    switch (args.count()) {
                        case 0: {
                            return ValueFactory.valueOf(state.random.nextDouble());
                        }
                        case 1: {
                            int m7 = args.arg(1).checkInteger();
                            if (m7 < 1) {
                                throw ErrorFactory.argError(1, "interval is empty");
                            }
                            return ValueFactory.valueOf(1 + state.random.nextInt(m7));
                        }
                    }
                    int m8 = args.arg(1).checkInteger();
                    int n = args.arg(2).checkInteger();
                    if (n < m8) {
                        throw ErrorFactory.argError(2, "interval is empty");
                    }
                    return ValueFactory.valueOf(m8 + state.random.nextInt(n + 1 - m8));
                }
            }
            return Constants.NONE;
        }
    }

    private static final class MathLib2
    extends TwoArgFunction {
        private MathLib2() {
        }

        @Override
        public LuaValue call(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    double x = arg1.checkDouble();
                    double y = arg2.checkDouble();
                    double q = x / y;
                    double f = x - y * (q >= 0.0 ? Math.floor(q) : Math.ceil(q));
                    return ValueFactory.valueOf(f);
                }
                case 1: {
                    double x = arg1.checkDouble();
                    double y = arg2.checkDouble() + 1023.5;
                    long e = (long)(0 != (1 & (int)y) ? Math.floor(y) : Math.ceil(y - 1.0));
                    return ValueFactory.valueOf(x * Double.longBitsToDouble(e << 52));
                }
                case 2: {
                    return ValueFactory.valueOf(Math.pow(arg1.checkDouble(), arg2.checkDouble()));
                }
                case 3: {
                    return ValueFactory.valueOf(Math.atan2(arg1.checkDouble(), arg2.checkDouble()));
                }
                case 4: {
                    if (arg2.isNil()) {
                        return ValueFactory.valueOf(Math.log(arg1.checkDouble()));
                    }
                    return ValueFactory.valueOf(Math.log(arg1.checkDouble()) / Math.log(arg2.checkDouble()));
                }
            }
            return Constants.NIL;
        }
    }

    private static final class MathLib1
    extends OneArgFunction {
        private MathLib1() {
        }

        @Override
        public LuaValue call(LuaState state, LuaValue arg) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    return ValueFactory.valueOf(Math.abs(arg.checkDouble()));
                }
                case 1: {
                    return ValueFactory.valueOf(Math.ceil(arg.checkDouble()));
                }
                case 2: {
                    return ValueFactory.valueOf(Math.cos(arg.checkDouble()));
                }
                case 3: {
                    return ValueFactory.valueOf(Math.toDegrees(arg.checkDouble()));
                }
                case 4: {
                    return ValueFactory.valueOf(Math.exp(arg.checkDouble()));
                }
                case 5: {
                    return ValueFactory.valueOf(Math.floor(arg.checkDouble()));
                }
                case 6: {
                    return ValueFactory.valueOf(Math.toRadians(arg.checkDouble()));
                }
                case 7: {
                    return ValueFactory.valueOf(Math.sin(arg.checkDouble()));
                }
                case 8: {
                    return ValueFactory.valueOf(Math.sqrt(arg.checkDouble()));
                }
                case 9: {
                    return ValueFactory.valueOf(Math.tan(arg.checkDouble()));
                }
                case 10: {
                    return ValueFactory.valueOf(Math.acos(arg.checkDouble()));
                }
                case 11: {
                    return ValueFactory.valueOf(Math.asin(arg.checkDouble()));
                }
                case 12: {
                    return ValueFactory.valueOf(Math.atan(arg.checkDouble()));
                }
                case 13: {
                    return ValueFactory.valueOf(Math.cosh(arg.checkDouble()));
                }
                case 14: {
                    return ValueFactory.valueOf(Math.exp(arg.checkDouble()));
                }
                case 15: {
                    return ValueFactory.valueOf(Math.log10(arg.checkDouble()));
                }
                case 16: {
                    return ValueFactory.valueOf(Math.sinh(arg.checkDouble()));
                }
                case 17: {
                    return ValueFactory.valueOf(Math.tanh(arg.checkDouble()));
                }
            }
            return Constants.NIL;
        }
    }
}

