/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaBoolean;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.OneArgFunction;
import org.squiddev.cobalt.function.VarArgFunction;
import org.squiddev.cobalt.lib.BaseLib;
import org.squiddev.cobalt.lib.LuaLibrary;

public class PackageLib
implements LuaLibrary {
    private static final LuaString _M = ValueFactory.valueOf("_M");
    private static final LuaString _NAME = ValueFactory.valueOf("_NAME");
    private static final LuaString _PACKAGE = ValueFactory.valueOf("_PACKAGE");
    private static final LuaString _DOT = ValueFactory.valueOf(".");
    private static final LuaString _LOADERS = ValueFactory.valueOf("loaders");
    private static final LuaString _LOADED = ValueFactory.valueOf("loaded");
    private static final LuaString _LOADLIB = ValueFactory.valueOf("loadlib");
    private static final LuaString _PRELOAD = ValueFactory.valueOf("preload");
    private static final LuaString _PATH = ValueFactory.valueOf("path");
    private static final LuaString _PATH_DEFAULT = ValueFactory.valueOf("?.lua");
    private static final LuaString _CPATH = ValueFactory.valueOf("cpath");
    private static final LuaString _CPATH_DEFAULT = Constants.EMPTYSTRING;
    private static final LuaString _SEEALL = ValueFactory.valueOf("seeall");
    private static final int OP_MODULE = 0;
    private static final int OP_REQUIRE = 1;
    private static final int OP_LOADLIB = 2;
    private static final int OP_SEEALL = 3;
    private static final int OP_PRELOAD_LOADER = 4;
    private static final int OP_LUA_LOADER = 5;
    private static final int OP_JAVA_LOADER = 6;
    private LuaTable packageTbl;
    private final LuaValue sentinel = ValueFactory.userdataOf(new Object());

    @Override
    public LuaValue add(LuaState state, LuaTable env) {
        env.rawset("require", (LuaValue)new PkgLib1(env, "require", 1, this));
        env.rawset("module", (LuaValue)new PkgLibV(env, "module", 0, this));
        this.packageTbl = ValueFactory.tableOf(_LOADED, state.loadedPackages, _PRELOAD, ValueFactory.tableOf(), _PATH, _PATH_DEFAULT, _LOADLIB, new PkgLibV(env, "loadlib", 2, this), _SEEALL, new PkgLib1(env, "seeall", 3, this), _CPATH, _CPATH_DEFAULT, _LOADERS, ValueFactory.listOf(new PkgLibV(env, "preload_loader", 4, this), new PkgLibV(env, "lua_loader", 5, this), new PkgLibV(env, "java_loader", 6, this)));
        env.rawset("package", (LuaValue)this.packageTbl);
        state.loadedPackages.rawset("package", (LuaValue)this.packageTbl);
        return env;
    }

    public static void setIsLoaded(LuaState state, String name, LuaTable value) {
        state.loadedPackages.rawset(name, (LuaValue)value);
    }

    public void setLuaPath(LuaState state, String newLuaPath) {
        this.packageTbl.rawset(_PATH, (LuaValue)ValueFactory.valueOf(newLuaPath));
    }

    public String toString() {
        return "package";
    }

    private Varargs module(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
        LuaFunction f;
        LuaTable module;
        LuaString modname = args.arg(1).checkLuaString();
        int n = args.count();
        LuaValue value = OperationHelper.getTable(state, state.loadedPackages, modname);
        if (!value.isTable()) {
            LuaTable globals = state.getCurrentThread().getfenv();
            module = PackageLib.findtable(state, globals, modname);
            if (module == null) {
                throw new LuaError("name conflict for module '" + modname + "'");
            }
            OperationHelper.setTable(state, state.loadedPackages, modname, module);
        } else {
            module = (LuaTable)value;
        }
        LuaValue name = OperationHelper.getTable(state, module, _NAME);
        if (name.isNil()) {
            PackageLib.modinit(state, module, modname);
        }
        if ((f = LuaThread.getCallstackFunction(state, 0)) == null) {
            throw new LuaError("no calling function");
        }
        if (!f.isClosure()) {
            throw new LuaError("'module' not called from a Lua function");
        }
        f.setfenv(module);
        for (int i = 2; i <= n; ++i) {
            OperationHelper.call(state, args.arg(i), module);
        }
        return Constants.NONE;
    }

    private static LuaTable findtable(LuaState state, LuaTable table, LuaString fname) throws LuaError, UnwindThrowable {
        int e = -1;
        do {
            LuaString key;
            LuaValue val;
            int b;
            if ((e = fname.indexOf(_DOT, b = e + 1)) < 0) {
                e = fname.length;
            }
            if ((val = table.rawget(key = fname.substring(b, e))).isNil()) {
                LuaTable field = new LuaTable();
                OperationHelper.setTable(state, table, key, field);
                table = field;
                continue;
            }
            if (!val.isTable()) {
                return null;
            }
            table = (LuaTable)val;
        } while (e < fname.length);
        return table;
    }

    private static void modinit(LuaState state, LuaValue module, LuaString modname) throws LuaError, UnwindThrowable {
        OperationHelper.setTable(state, module, _M, module);
        int e = modname.lastIndexOf(_DOT);
        OperationHelper.setTable(state, module, _NAME, modname);
        LuaString value = e < 0 ? Constants.EMPTYSTRING : modname.substring(0, e + 1);
        OperationHelper.setTable(state, module, _PACKAGE, value);
    }

    LuaValue require(LuaState state, LuaValue arg) throws LuaError, UnwindThrowable {
        LuaValue chunk;
        LuaString name = arg.checkLuaString();
        LuaValue loaded = OperationHelper.getTable(state, state.loadedPackages, name);
        if (loaded.toBoolean()) {
            if (loaded == this.sentinel) {
                throw new LuaError("loop or previous error loading module '" + name + "'");
            }
            return loaded;
        }
        LuaTable tbl = OperationHelper.getTable(state, this.packageTbl, _LOADERS).checkTable();
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (true) {
            LuaValue loader;
            if ((loader = tbl.rawget(i)).isNil()) {
                throw new LuaError("module '" + name + "' not found: " + name + sb);
            }
            chunk = OperationHelper.call(state, loader, name);
            if (chunk.isFunction()) break;
            if (chunk.isString()) {
                sb.append(chunk.toString());
            }
            ++i;
        }
        OperationHelper.setTable(state, state.loadedPackages, name, this.sentinel);
        LuaValue result = OperationHelper.call(state, chunk, name);
        if (!result.isNil()) {
            OperationHelper.setTable(state, state.loadedPackages, name, result);
        } else {
            result = OperationHelper.getTable(state, state.loadedPackages, name);
            if (result == this.sentinel) {
                result = Constants.TRUE;
                LuaBoolean value = result;
                OperationHelper.setTable(state, state.loadedPackages, name, value);
            }
        }
        return result;
    }

    public static Varargs loadlib(Varargs args) throws LuaError {
        args.arg(1).checkLuaString();
        return ValueFactory.varargsOf(Constants.NIL, (LuaValue)ValueFactory.valueOf("dynamic libraries not enabled"), (Varargs)ValueFactory.valueOf("absent"));
    }

    LuaValue loader_preload(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
        LuaString name = args.arg(1).checkLuaString();
        LuaTable preload = OperationHelper.getTable(state, this.packageTbl, _PRELOAD).checkTable();
        LuaValue val = OperationHelper.getTable(state, preload, name);
        return val.isNil() ? ValueFactory.valueOf("\n\tno field package.preload['" + name + "']") : val;
    }

    LuaValue loader_Lua(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
        String name = args.arg(1).checkString();
        LuaValue pp = OperationHelper.getTable(state, this.packageTbl, _PATH);
        if (!pp.isString()) {
            return ValueFactory.valueOf("package.path is not a string");
        }
        String path = pp.toString();
        int e = -1;
        int n = path.length();
        StringBuffer sb = null;
        name = name.replace('.', '/');
        while (e < n) {
            String template;
            String filename;
            Varargs v;
            int b = e + 1;
            if ((e = path.indexOf(59, b)) < 0) {
                e = path.length();
            }
            if ((v = BaseLib.loadFile(state, filename = (template = path.substring(b, e)).replace("?", name))).first().isFunction()) {
                return v.first();
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append("\n\t'").append(filename).append("': ").append(v.arg(2));
        }
        return ValueFactory.valueOf(sb.toString());
    }

    private LuaValue loader_Java(Varargs args, LuaTable env) throws LuaError {
        String name = args.arg(1).checkString();
        String classname = PackageLib.toClassname(name);
        try {
            Class<?> c = Class.forName(classname);
            LuaValue v = (LuaValue)c.newInstance();
            v.setfenv(env);
            return v;
        }
        catch (ClassNotFoundException cnfe) {
            return ValueFactory.valueOf("\n\tno class '" + classname + "'");
        }
        catch (Exception e) {
            return ValueFactory.valueOf("\n\tjava load failed on '" + classname + "', " + e);
        }
    }

    public static String toClassname(String filename) {
        int n;
        int j = n = filename.length();
        if (filename.endsWith(".lua")) {
            j -= 4;
        }
        for (int k = 0; k < j; ++k) {
            int c = filename.charAt(k);
            if (PackageLib.isClassnamePart((char)c) && c != 47 && c != 92) continue;
            StringBuilder sb = new StringBuilder(j);
            for (int i = 0; i < j; ++i) {
                c = filename.charAt(i);
                sb.append((char)(PackageLib.isClassnamePart((char)c) ? c : (c == 47 || c == 92 ? 46 : 95)));
            }
            return sb.toString();
        }
        return n == j ? filename : filename.substring(0, j);
    }

    private static boolean isClassnamePart(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case '$': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    static final class PkgLibV
    extends VarArgFunction {
        PackageLib lib;

        public PkgLibV(LuaTable env, String name, int opcode, PackageLib lib) {
            this.env = env;
            this.name = name;
            this.opcode = opcode;
            this.lib = lib;
        }

        @Override
        public Varargs invoke(LuaState state, Varargs args) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    return OperationHelper.noUnwind(state, () -> this.lib.module(state, args));
                }
                case 2: {
                    return PackageLib.loadlib(args);
                }
                case 4: {
                    return OperationHelper.noUnwind(state, () -> this.lib.loader_preload(state, args));
                }
                case 5: {
                    return OperationHelper.noUnwind(state, () -> this.lib.loader_Lua(state, args));
                }
                case 6: {
                    return this.lib.loader_Java(args, this.getfenv());
                }
            }
            return Constants.NONE;
        }
    }

    static final class PkgLib1
    extends OneArgFunction {
        PackageLib lib;

        public PkgLib1(LuaTable env, String name, int opcode, PackageLib lib) {
            this.env = env;
            this.name = name;
            this.opcode = opcode;
            this.lib = lib;
        }

        @Override
        public LuaValue call(LuaState state, LuaValue arg) throws LuaError {
            switch (this.opcode) {
                case 1: {
                    return OperationHelper.noUnwind(state, () -> this.lib.require(state, arg));
                }
                case 3: {
                    LuaTable t2 = arg.checkTable();
                    LuaTable m4 = t2.getMetatable(state);
                    if (m4 == null) {
                        m4 = ValueFactory.tableOf();
                        t2.setMetatable(state, m4);
                    }
                    LuaTable mt = m4;
                    OperationHelper.noUnwind(state, () -> OperationHelper.setTable(state, mt, Constants.INDEX, state.getCurrentThread().getfenv()));
                    return Constants.NONE;
                }
            }
            return Constants.NIL;
        }
    }
}

