/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.lib.FormatDesc;

class StringFormat {
    StringFormat() {
    }

    static Varargs format(LuaState state, FormatState format) throws LuaError, UnwindThrowable {
        LuaString fmt = format.format;
        int n = fmt.length();
        Buffer result = format.buffer;
        int i = format.i;
        block9: while (i < n) {
            int c;
            if ((c = fmt.luaByte(i++)) != 37) {
                result.append((byte)c);
                continue;
            }
            if (i >= n) {
                throw new LuaError("invalid option '%' to 'format'");
            }
            if (fmt.luaByte(i) == 37) {
                ++i;
                result.append((byte)37);
                continue;
            }
            LuaValue value = format.args.arg(++format.arg);
            FormatDesc fdsc = new FormatDesc(fmt, i);
            i += fdsc.length;
            switch (fdsc.conversion) {
                case 99: {
                    fdsc.format(result, (byte)value.checkLong());
                    continue block9;
                }
                case 88: 
                case 100: 
                case 105: 
                case 111: 
                case 117: 
                case 120: {
                    fdsc.format(result, value.checkLong());
                    continue block9;
                }
                case 69: 
                case 71: 
                case 101: 
                case 102: 
                case 103: {
                    fdsc.format(result, value.checkDouble());
                    continue block9;
                }
                case 113: {
                    StringFormat.addQuoted(result, format.arg, value);
                    continue block9;
                }
                case 115: {
                    try {
                        StringFormat.addString(result, fdsc, OperationHelper.checkToString(OperationHelper.toString(state, value)));
                        continue block9;
                    }
                    catch (UnwindThrowable e) {
                        format.current = fdsc;
                        format.i = i;
                        throw e;
                    }
                }
            }
            throw new LuaError("invalid option '%" + (char)fdsc.conversion + "' to 'format'");
        }
        return result.toLuaString();
    }

    static void addString(Buffer result, FormatDesc fdsc, LuaString s2) {
        if (fdsc.precision == -1 && s2.length() >= 100) {
            result.append(s2);
        } else {
            fdsc.format(result, s2);
        }
    }

    private static void addQuoted(Buffer buf, int arg, LuaValue s2) throws LuaError {
        switch (s2.type()) {
            case 4: {
                StringFormat.addQuoted(buf, s2.checkLuaString());
                break;
            }
            case 3: {
                if (s2 instanceof LuaInteger) {
                    buf.append(Integer.toString(s2.checkInteger()));
                    break;
                }
                double value = s2.checkDouble();
                buf.append((double)((long)value) == value ? Long.toString((long)value) : Double.toHexString(value));
                break;
            }
            case 0: 
            case 1: {
                buf.append(s2.toString());
                break;
            }
            default: {
                throw ErrorFactory.argError(arg, "value has no literal representation");
            }
        }
    }

    private static void addQuoted(Buffer buf, LuaString s2) {
        buf.append((byte)34);
        int n = s2.length();
        block5: for (int i = 0; i < n; ++i) {
            int c = s2.luaByte(i);
            switch (c) {
                case 10: 
                case 34: 
                case 92: {
                    buf.append((byte)92);
                    buf.append((byte)c);
                    continue block5;
                }
                case 13: {
                    buf.append("\\r");
                    continue block5;
                }
                case 0: {
                    buf.append("\\000");
                    continue block5;
                }
                default: {
                    buf.append((byte)c);
                }
            }
        }
        buf.append((byte)34);
    }

    static class FormatState {
        final LuaString format;
        int i = 0;
        final Buffer buffer;
        int arg = 1;
        final Varargs args;
        FormatDesc current;

        FormatState(LuaString format, Buffer buffer, Varargs args) {
            this.args = args;
            this.format = format;
            this.buffer = buffer;
        }
    }
}

