/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib.jse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JseProcess {
    private final Process process;
    private final Thread input;
    private final Thread output;
    private final Thread error;

    public JseProcess(String[] cmd, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        this(Runtime.getRuntime().exec(cmd), stdin, stdout, stderr);
    }

    public JseProcess(String cmd, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        this(Runtime.getRuntime().exec(cmd), stdin, stdout, stderr);
    }

    private JseProcess(Process process, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        this.process = process;
        this.input = stdin == null ? null : this.copyBytes(stdin, process.getOutputStream(), null, process.getOutputStream());
        this.output = stdout == null ? null : this.copyBytes(process.getInputStream(), stdout, process.getInputStream(), null);
        this.error = stderr == null ? null : this.copyBytes(process.getErrorStream(), stderr, process.getErrorStream(), null);
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public int waitFor() throws InterruptedException {
        int r = this.process.waitFor();
        if (this.input != null) {
            this.input.join();
        }
        if (this.output != null) {
            this.output.join();
        }
        if (this.error != null) {
            this.error.join();
        }
        this.process.destroy();
        return r;
    }

    private Thread copyBytes(final InputStream input, final OutputStream output, final InputStream ownedInput, final OutputStream ownedOutput) {
        Thread t2 = new Thread(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    try {
                        int r;
                        while ((r = input.read(buf)) >= 0) {
                            output.write(buf, 0, r);
                        }
                    }
                    finally {
                        if (ownedInput != null) {
                            ownedInput.close();
                        }
                        if (ownedOutput != null) {
                            ownedOutput.close();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        t2.start();
        return t2;
    }
}

