/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.mcreator.evilreflections.block.DarkChestBlock;
import net.mcreator.evilreflections.block.DarkChestBlockEntity;
import net.mcreator.evilreflections.block.DarkFragmentOreBlock;
import net.mcreator.evilreflections.block.DarkFragmentOreBlockEntity;
import net.mcreator.evilreflections.block.DarkMushroomBlock;
import net.mcreator.evilreflections.block.DeepslateDarkFragmentOreBlock;
import net.mcreator.evilreflections.block.DeepslateDarkFragmentOreBlockEntity;
import net.mcreator.evilreflections.block.RawDarkFragmentBlock;
import net.mcreator.evilreflections.block.ShadowPrismarineBlock;
import net.mcreator.evilreflections.client.model.DarkBossModel;
import net.mcreator.evilreflections.client.model.DarkLightningBoltModel;
import net.mcreator.evilreflections.client.model.EvilReflectionModel;
import net.mcreator.evilreflections.client.renderer.DarkBossRenderer;
import net.mcreator.evilreflections.client.renderer.DarkChestRenderer;
import net.mcreator.evilreflections.client.renderer.DarkFragmentOreRenderer;
import net.mcreator.evilreflections.client.renderer.DarkFragmentRenderer;
import net.mcreator.evilreflections.client.renderer.DeepslateDarkFragmentOreRenderer;
import net.mcreator.evilreflections.client.renderer.EvilReflectionRenderer;
import net.mcreator.evilreflections.effect.MobEffectAnomalousFloat;
import net.mcreator.evilreflections.entity.BlockDarkFragmentEntity;
import net.mcreator.evilreflections.entity.DarkBossEntity;
import net.mcreator.evilreflections.entity.DarkFragmentEntity;
import net.mcreator.evilreflections.entity.DarkLightningBoltEntity;
import net.mcreator.evilreflections.entity.EvilReflectionEntity;
import net.mcreator.evilreflections.item.DarkFragmentItem;
import net.mcreator.evilreflections.item.DarkShieldItem;
import net.mcreator.evilreflections.item.DarkShieldItemRenderer;
import net.mcreator.evilreflections.item.DarkSwordItem;
import net.mcreator.evilreflections.item.RawDarkFragmentItem;
import net.mcreator.evilreflections.network.AnomalousFloatSyncPacket;
import net.mcreator.evilreflections.network.SpawnDarkLightningMessage;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="evil_reflections")
public class EvilReflectionsMod {
    public static final String MODID = "evil_reflections";
    private static EvilReflectionsMod instance;
    private static final Logger LOGGER;
    private static final String PROTOCOL_VERSION = "1";
    private static SimpleChannel NETWORK;
    public static final DeferredRegister<MobEffect> EFFECTS;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<EntityType<?>> ENTITIES;
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    public static final RegistryObject<Block> DARK_CHEST;
    public static final RegistryObject<Block> SHADOW_PRISMARINE;
    public static final RegistryObject<Block> RAW_DARK_FRAGMENT_BLOCK;
    public static final RegistryObject<Block> DARK_FRAGMENT_ORE;
    public static final RegistryObject<Block> DEEPSLATE_DARK_FRAGMENT_ORE;
    public static final RegistryObject<Block> DARK_MUSHROOM;
    public static final RegistryObject<Item> DARK_FRAGMENT;
    public static final RegistryObject<Item> DARK_MUSHROOM_ITEM;
    public static final RegistryObject<Item> RAW_DARK_FRAGMENT;
    public static final RegistryObject<Item> DARK_CHEST_ITEM;
    public static final RegistryObject<Item> SHADOW_PRISMARINE_ITEM;
    public static final RegistryObject<Item> RAW_DARK_FRAGMENT_BLOCK_ITEM;
    public static final RegistryObject<Item> DARK_SHIELD;
    public static final RegistryObject<Item> DARK_FRAGMENT_ORE_ITEM;
    public static final RegistryObject<Item> DEEPSLATE_DARK_FRAGMENT_ORE_ITEM;
    public static final RegistryObject<Item> DARK_SWORD;
    public static final RegistryObject<MobEffect> ANOMALOUS_FLOAT;
    public static final RegistryObject<EntityType<DarkFragmentEntity>> DARK_FRAGMENT_ENTITY;
    public static final RegistryObject<EntityType<BlockDarkFragmentEntity>> BLOCK_DARK_FRAGMENT_ENTITY;
    public static final RegistryObject<EntityType<DarkBossEntity>> DARK_BOSS;
    public static final RegistryObject<EntityType<EvilReflectionEntity>> EVIL_REFLECTION;
    public static final RegistryObject<EntityType<DarkLightningBoltEntity>> DARK_LIGHTNING_BOLT;
    public static final RegistryObject<Item> EVIL_REFLECTION_SPAWN_EGG;
    public static final RegistryObject<BlockEntityType<DarkChestBlockEntity>> DARK_CHEST_ENTITY;
    public static final RegistryObject<BlockEntityType<DarkFragmentOreBlockEntity>> DARK_FRAGMENT_ORE_BLOCK_ENTITY;
    public static final RegistryObject<BlockEntityType<DeepslateDarkFragmentOreBlockEntity>> DEEPSLATE_DARK_FRAGMENT_ORE_BLOCK_ENTITY;
    public static final KeyMapping DARK_BEAM_KEY;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;

    private static Item createSpawnEggItem() {
        return new ForgeSpawnEggItem(EVIL_REFLECTION, -16777012, -13434676, new Item.Properties());
    }

    public EvilReflectionsMod() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        BLOCKS.register(modEventBus);
        ENTITIES.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        EFFECTS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setupNetwork();
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
        EvilReflectionEntity.EvilReflectionSpawnHandler.registerSpawnHandler();
    }

    private void setupNetwork() {
        NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        int messageId = 0;
        NETWORK.registerMessage(messageId++, SpawnDarkLightningMessage.class, SpawnDarkLightningMessage::encode, SpawnDarkLightningMessage::decode, SpawnDarkLightningMessage::handle);
        NETWORK.registerMessage(messageId++, AnomalousFloatSyncPacket.class, AnomalousFloatSyncPacket::encode, AnomalousFloatSyncPacket::decode, AnomalousFloatSyncPacket::handle);
    }

    public static EvilReflectionsMod get() {
        return instance;
    }

    public static SimpleChannel getNetwork() {
        return NETWORK;
    }

    public static void sendToServer(Object msg) {
        NETWORK.sendToServer(msg);
    }

    public static void sendToTracking(Object msg, ServerPlayer player) {
        NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), msg);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)DARK_FRAGMENT_ENTITY.get()), DarkFragmentRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BLOCK_DARK_FRAGMENT_ENTITY.get()), DarkFragmentRenderer::new);
        event.enqueueWork(() -> MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler()));
    }

    private void addCreative(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == CreativeModeTabs.f_256791_) {
            event.accept(DARK_CHEST_ITEM);
        }
        if (event.getTab() == CreativeModeTabs.f_256968_) {
            event.accept(DARK_FRAGMENT);
            event.accept(RAW_DARK_FRAGMENT);
        }
        if (event.getTab() == CreativeModeTabs.f_256788_) {
            event.accept(SHADOW_PRISMARINE_ITEM);
        }
        if (event.getTab() == CreativeModeTabs.f_256797_) {
            event.accept(DARK_SHIELD);
            event.accept(DARK_SWORD);
        }
        if (event.getTab() == CreativeModeTabs.f_256776_) {
            event.accept(RAW_DARK_FRAGMENT_BLOCK_ITEM);
        }
        if (event.getTab() == CreativeModeTabs.f_256776_) {
            event.accept(DARK_FRAGMENT_ORE_ITEM);
            event.accept(DEEPSLATE_DARK_FRAGMENT_ORE_ITEM);
            event.accept(DARK_MUSHROOM_ITEM);
        }
        if (event.getTab() == CreativeModeTabs.f_256731_) {
            event.accept(EVIL_REFLECTION_SPAWN_EGG);
        }
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<AbstractMap.SimpleEntry<Runnable, Integer>> iterator = workQueue.iterator();
            while (iterator.hasNext()) {
                AbstractMap.SimpleEntry<Runnable, Integer> work = iterator.next();
                work.setValue(work.getValue() - 1);
                if (work.getValue() != 0) continue;
                work.getKey().run();
                iterator.remove();
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)MODID);
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MODID);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)MODID);
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)MODID);
        DARK_CHEST = BLOCKS.register("dark_chest", DarkChestBlock::new);
        SHADOW_PRISMARINE = BLOCKS.register("shadow_prismarine", ShadowPrismarineBlock::new);
        RAW_DARK_FRAGMENT_BLOCK = BLOCKS.register("raw_dark_fragment_block", RawDarkFragmentBlock::new);
        DARK_FRAGMENT_ORE = BLOCKS.register("dark_fragment_ore", DarkFragmentOreBlock::new);
        DEEPSLATE_DARK_FRAGMENT_ORE = BLOCKS.register("deepslate_dark_fragment_ore", DeepslateDarkFragmentOreBlock::new);
        DARK_MUSHROOM = BLOCKS.register("dark_mushroom", DarkMushroomBlock::new);
        DARK_FRAGMENT = ITEMS.register("dark_fragment", DarkFragmentItem::new);
        DARK_MUSHROOM_ITEM = ITEMS.register("dark_mushroom", () -> new BlockItem((Block)DARK_MUSHROOM.get(), new Item.Properties()));
        RAW_DARK_FRAGMENT = ITEMS.register("raw_dark_fragment", RawDarkFragmentItem::new);
        DARK_CHEST_ITEM = ITEMS.register("dark_chest", () -> new BlockItem((Block)DARK_CHEST.get(), new Item.Properties()));
        SHADOW_PRISMARINE_ITEM = ITEMS.register("shadow_prismarine", () -> new BlockItem((Block)SHADOW_PRISMARINE.get(), new Item.Properties()));
        RAW_DARK_FRAGMENT_BLOCK_ITEM = ITEMS.register("raw_dark_fragment_block", () -> new BlockItem((Block)RAW_DARK_FRAGMENT_BLOCK.get(), new Item.Properties()));
        DARK_SHIELD = ITEMS.register("dark_shield", DarkShieldItem::new);
        DARK_FRAGMENT_ORE_ITEM = ITEMS.register("dark_fragment_ore", () -> new BlockItem((Block)DARK_FRAGMENT_ORE.get(), new Item.Properties()));
        DEEPSLATE_DARK_FRAGMENT_ORE_ITEM = ITEMS.register("deepslate_dark_fragment_ore", () -> new BlockItem((Block)DEEPSLATE_DARK_FRAGMENT_ORE.get(), new Item.Properties()));
        DARK_SWORD = ITEMS.register("dark_sword", () -> new DarkSwordItem());
        ANOMALOUS_FLOAT = EFFECTS.register("anomalous_float", () -> new MobEffectAnomalousFloat());
        DARK_FRAGMENT_ENTITY = ENTITIES.register("dark_fragment", () -> EntityType.Builder.m_20704_(DarkFragmentEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20717_(1).m_20712_("dark_fragment"));
        BLOCK_DARK_FRAGMENT_ENTITY = ENTITIES.register("block_dark_fragment", () -> EntityType.Builder.m_20704_(BlockDarkFragmentEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20717_(1).m_20712_("block_dark_fragment"));
        DARK_BOSS = ENTITIES.register("dark_boss", () -> EntityType.Builder.m_20704_(DarkBossEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.5f, 4.0f).m_20712_("dark_boss"));
        EVIL_REFLECTION = ENTITIES.register("evil_reflection", () -> EntityType.Builder.m_20704_(EvilReflectionEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.8f).m_20712_("evil_reflection"));
        DARK_LIGHTNING_BOLT = ENTITIES.register("dark_lightning_bolt", () -> EntityType.Builder.m_20704_(DarkLightningBoltEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.0f, 0.0f).m_20712_("dark_lightning_bolt"));
        EVIL_REFLECTION_SPAWN_EGG = ITEMS.register("evil_reflection_spawn_egg", () -> EvilReflectionsMod.createSpawnEggItem());
        DARK_CHEST_ENTITY = BLOCK_ENTITIES.register("dark_chest", () -> BlockEntityType.Builder.m_155273_(DarkChestBlockEntity::new, (Block[])new Block[]{(Block)DARK_CHEST.get()}).m_58966_(null));
        DARK_FRAGMENT_ORE_BLOCK_ENTITY = BLOCK_ENTITIES.register("dark_fragment_ore", () -> BlockEntityType.Builder.m_155273_(DarkFragmentOreBlockEntity::new, (Block[])new Block[]{(Block)DARK_FRAGMENT_ORE.get()}).m_58966_(null));
        DEEPSLATE_DARK_FRAGMENT_ORE_BLOCK_ENTITY = BLOCK_ENTITIES.register("deepslate_dark_fragment_ore", () -> BlockEntityType.Builder.m_155273_(DeepslateDarkFragmentOreBlockEntity::new, (Block[])new Block[]{(Block)DEEPSLATE_DARK_FRAGMENT_ORE.get()}).m_58966_(null));
        DARK_BEAM_KEY = new KeyMapping("key.evil_reflections.dark_beam", 90, "key.categories.evil_reflections");
        workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    }

    @Mod.EventBusSubscriber(modid="evil_reflections", value={Dist.CLIENT})
    public static class KeyInputHandler {
        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(DARK_BEAM_KEY);
        }

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            LocalPlayer player;
            if (DARK_BEAM_KEY.m_90859_() && (player = Minecraft.m_91087_().f_91074_) != null) {
                if (DarkFragmentItem.hasSufficientDarkFragments((Player)player)) {
                    NETWORK.sendToServer((Object)new SpawnDarkLightningMessage(player.m_20185_(), player.m_20186_(), player.m_20189_()));
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.evil_reflections.insufficient_dark_fragments"), true);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void addEntityAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)DARK_BOSS.get(), DarkBossEntity.createAttributes().m_22265_());
            event.put((EntityType)EVIL_REFLECTION.get(), EvilReflectionEntity.createAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)DARK_BOSS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DarkBossEntity::checkSpawnRules));
        }
    }

    @Mod.EventBusSubscriber(modid="evil_reflections", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)DARK_CHEST_ENTITY.get(), DarkChestRenderer::new);
            event.registerEntityRenderer((EntityType)DARK_BOSS.get(), DarkBossRenderer::new);
            event.registerEntityRenderer((EntityType)EVIL_REFLECTION.get(), EvilReflectionRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)DARK_FRAGMENT_ORE_BLOCK_ENTITY.get(), DarkFragmentOreRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)DEEPSLATE_DARK_FRAGMENT_ORE_BLOCK_ENTITY.get(), DeepslateDarkFragmentOreRenderer::new);
        }
    }

    @Mod.EventBusSubscriber(modid="evil_reflections", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientSetup {
        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(DarkBossModel.LAYER_LOCATION, DarkBossModel::createBodyLayer);
            event.registerLayerDefinition(EvilReflectionModel.LAYER_LOCATION, EvilReflectionModel::createBodyLayer);
            event.registerLayerDefinition(DarkLightningBoltModel.LAYER_LOCATION, DarkLightningBoltModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            DarkShieldItemRenderer.registerPropertyOverrides(event);
        }
    }
}

