/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.block;

import java.util.UUID;
import net.mcreator.evilreflections.EvilReflectionsMod;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DarkChestBlockEntity
extends ChestBlockEntity
implements LidBlockEntity {
    private int tickCounter = 0;
    private UUID placerUUID;
    private float lidAngle;
    private float prevLidAngle;
    private int numPlayersUsing;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            DarkChestBlockEntity.this.updateBlockState(state, true);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            DarkChestBlockEntity.this.updateBlockState(state, false);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int oldCount, int newCount) {
            DarkChestBlockEntity.this.m_142151_(level, pos, state, oldCount, newCount);
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof AbstractContainerMenu) {
                return player.f_36096_.m_6875_(player);
            }
            return false;
        }
    };

    public DarkChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EvilReflectionsMod.DARK_CHEST_ENTITY.get(), pos, state);
    }

    public void setPlacerUUID(UUID uuid) {
        this.placerUUID = uuid;
    }

    protected void m_142151_(Level level, BlockPos pos, BlockState state, int oldOpenCount, int openCount) {
        super.m_142151_(level, pos, state, oldOpenCount, openCount);
        if (oldOpenCount != openCount) {
            level.m_7696_(pos, state.m_60734_(), 1, openCount);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DarkChestBlockEntity blockEntity) {
        blockEntity.prevLidAngle = blockEntity.lidAngle;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        blockEntity.lidAngle = blockEntity.numPlayersUsing > 0 ? (blockEntity.lidAngle += 0.1f) : (blockEntity.lidAngle -= 0.1f);
        blockEntity.lidAngle = Math.max(0.0f, Math.min(1.0f, blockEntity.lidAngle));
        if (!level.m_5776_()) {
            ++blockEntity.tickCounter;
            if (blockEntity.tickCounter >= 600) {
                Player player = level.m_46003_(blockEntity.placerUUID);
                if (player != null) {
                    for (int i = 0; i < blockEntity.m_6643_(); ++i) {
                        ItemStack stack = blockEntity.m_8020_(i);
                        if (stack.m_41619_()) continue;
                        player.m_150109_().m_36054_(stack);
                        blockEntity.m_6836_(i, ItemStack.f_41583_);
                    }
                }
                blockEntity.tickCounter = 0;
            }
        }
    }

    public float m_6683_(float partialTicks) {
        return this.prevLidAngle + (this.lidAngle - this.prevLidAngle) * partialTicks;
    }

    private void updateBlockState(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), state, 3);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.tickCounter = nbt.m_128451_("TickCounter");
        if (nbt.m_128403_("PlacerUUID")) {
            this.placerUUID = nbt.m_128342_("PlacerUUID");
        }
        this.numPlayersUsing = nbt.m_128451_("NumPlayersUsing");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("TickCounter", this.tickCounter);
        if (this.placerUUID != null) {
            nbt.m_128362_("PlacerUUID", this.placerUUID);
        }
        nbt.m_128405_("NumPlayersUsing", this.numPlayersUsing);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    private void onOpenOrClose() {
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 1, this.numPlayersUsing);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.m_7531_(id, type);
    }
}

