/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mcreator.evilreflections.EvilReflectionsMod;
import net.mcreator.evilreflections.block.DarkFragmentOreBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="evil_reflections")
public class DarkFragmentOreBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public DarkFragmentOreBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(3.0f, 3.0f).m_60999_().m_60955_().m_60924_((bs, br, bp) -> false).m_60918_(SoundType.f_56742_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.f_46443_ && (double)(level = event.player.f_19853_).m_213780_().m_188501_() < 0.001 && level.m_46472_() == Level.f_46428_) {
            int x = event.player.m_20183_().m_123341_() + level.m_213780_().m_188503_(32) - 16;
            int z = event.player.m_20183_().m_123343_() + level.m_213780_().m_188503_(32) - 16;
            int y = 2 + level.m_213780_().m_188503_(7);
            BlockPos pos = new BlockPos(x, y, z);
            if (level.m_8055_(pos).m_60713_(Blocks.f_50069_)) {
                DarkFragmentOreBlock.generateOreCluster(level, pos);
            }
        }
    }

    private static void generateOreCluster(Level level, BlockPos center) {
        int oresGenerated = 0;
        int maxOres = 3 + level.m_213780_().m_188503_(3);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos pos;
                    if (oresGenerated >= maxOres) {
                        return;
                    }
                    if (!((double)level.m_213780_().m_188501_() < 0.02) || !level.m_8055_(pos = center.m_7918_(dx, dy, dz)).m_60713_(Blocks.f_50069_)) continue;
                    level.m_7731_(pos, ((Block)EvilReflectionsMod.DARK_FRAGMENT_ORE.get()).m_49966_(), 3);
                    ++oresGenerated;
                }
            }
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        Item item = player.m_150109_().m_36056_().m_41720_();
        if (item instanceof PickaxeItem) {
            PickaxeItem tieredItem = (PickaxeItem)item;
            return tieredItem.m_43314_().m_6604_() >= Tiers.DIAMOND.m_6604_();
        }
        return false;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        float baseSpeed = super.m_5880_(state, player, worldIn, pos);
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof PickaxeItem) {
            int efficiencyLevel;
            PickaxeItem pickaxe = (PickaxeItem)item;
            int harvestLevel = pickaxe.m_43314_().m_6604_();
            if (harvestLevel >= Tiers.DIAMOND.m_6604_()) {
                baseSpeed *= 1.0f + (float)(harvestLevel - Tiers.DIAMOND.m_6604_()) * 0.5f;
            }
            if ((efficiencyLevel = heldItem.getEnchantmentLevel(Enchantments.f_44984_)) > 0) {
                baseSpeed *= 1.0f + (float)efficiencyLevel * 0.2f;
            }
        }
        if (player.m_21023_(MobEffects.f_19598_)) {
            int amplifier = player.m_21124_(MobEffects.f_19598_).m_19564_();
            baseSpeed *= 1.0f + (float)(amplifier + 1) * 0.2f;
        }
        return baseSpeed;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack tool = (ItemStack)builder.m_78970_(LootContextParams.f_81463_);
        if (tool != null && tool.getEnchantmentLevel(Enchantments.f_44985_) > 0) {
            drops.add(new ItemStack((ItemLike)this));
            return drops;
        }
        int fortune = 0;
        if (tool != null) {
            fortune = tool.getEnchantmentLevel(Enchantments.f_44987_);
        }
        int count = 1 + (fortune > 0 ? new Random().nextInt(fortune + 1) : 0);
        drops.add(new ItemStack((ItemLike)EvilReflectionsMod.RAW_DARK_FRAGMENT.get(), count));
        RandomSource random = RandomSource.m_216327_();
        float chance = random.m_188501_();
        ItemStack additionalDrop = chance < 0.4f ? new ItemStack((ItemLike)Items.f_42416_) : (chance < 0.7f ? new ItemStack((ItemLike)Items.f_42417_) : (chance < 0.9f ? new ItemStack((ItemLike)Items.f_42415_) : (chance < 0.95f ? new ItemStack((ItemLike)Items.f_42616_) : new ItemStack((ItemLike)Items.f_42418_))));
        int additionalCount = 1 + random.m_188503_(fortune + 1);
        additionalDrop.m_41764_(additionalCount);
        drops.add(additionalDrop);
        return drops;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DarkFragmentOreBlockEntity(pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        Player player = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 4.0, false);
        if (player != null) {
            for (int i = 0; i < 5; ++i) {
                double x = (double)pos.m_123341_() + random.m_188500_();
                double y = (double)pos.m_123342_() + random.m_188500_();
                double z = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 0.0, 0.05, 0.0);
            }
        }
    }
}

