/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mcreator.evilreflections.EvilReflectionsMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="evil_reflections", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DarkMushroomBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0);
    private static final List<BlockPos> mushroomPositions = Collections.synchronizedList(new ArrayList());
    private static final List<ChunkPos> infestedChunks = Collections.synchronizedList(new ArrayList());

    public DarkMushroomBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76365_).m_60910_().m_60966_().m_60953_(state -> 3).m_60918_(SoundType.f_56711_));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Level level;
        if (world instanceof Level && (level = (Level)world).m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        BlockState belowState = world.m_8055_(pos.m_7495_());
        return belowState.m_60713_(Blocks.f_50195_) || belowState.m_60713_(Blocks.f_50599_) || world.m_45524_(pos, 0) < 15 && (belowState.m_60713_(Blocks.f_50493_) || belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_50546_));
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return super.m_7381_(state, builder);
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player instanceof Player) {
            Player player = event.player;
            Level level = player.f_19853_;
            if (!level.m_5776_() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ChunkPos currentChunkPos = new ChunkPos(player.m_20183_());
                if (level.m_204166_(player.m_20183_()).m_203565_(Biomes.f_48151_) && !infestedChunks.contains(currentChunkPos)) {
                    List<ChunkPos> list = infestedChunks;
                    synchronized (list) {
                        infestedChunks.add(currentChunkPos);
                    }
                    DarkMushroomBlock.generateMushroomsInChunk(serverLevel, currentChunkPos, player.m_217043_());
                }
            }
        }
    }

    private static void generateMushroomsInChunk(ServerLevel level, ChunkPos chunkPos, RandomSource random) {
        int generationAttempts = 15;
        block0: for (int i = 0; i < generationAttempts; ++i) {
            int x = chunkPos.m_45604_() + random.m_188503_(16);
            int z = chunkPos.m_45605_() + random.m_188503_(16);
            for (int y = level.m_151558_() - 1; y > level.m_141937_(); --y) {
                BlockState stateBelow;
                BlockPos position = new BlockPos(x, y, z);
                if (!level.m_46859_(position) || !level.m_8055_(position.m_7494_()).m_60783_((BlockGetter)level, position.m_7494_(), Direction.DOWN) || !(stateBelow = level.m_8055_(position.m_7495_())).m_60713_(Blocks.f_50493_) && !stateBelow.m_60713_(Blocks.f_50440_) && !stateBelow.m_60713_(Blocks.f_50195_) && !stateBelow.m_60713_(Blocks.f_50069_) && !stateBelow.m_60713_(Blocks.f_49994_) || level.m_45524_(position, 0) >= 15) continue;
                level.m_7731_(position, ((Block)EvilReflectionsMod.DARK_MUSHROOM.get()).m_49966_(), 2);
                continue block0;
            }
        }
    }
}

