/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class DarkBossModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("evil_reflections", "dark_boss"), "main");
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart body;
    private final ModelPart head;

    public DarkBossModel(ModelPart root) {
        this.right_leg = root.m_171324_("right_leg");
        this.left_leg = root.m_171324_("left_leg");
        this.left_arm = root.m_171324_("left_arm");
        this.right_arm = root.m_171324_("right_arm");
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(48, 53).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 25.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-1.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(72, 27).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 25.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-1.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)15.75f, (float)-28.0f, (float)0.75f, (float)-0.48f, (float)0.0f, (float)0.0f));
        left_arm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(24, 77).m_171488_(-3.0f, -1.3119f, -4.9679f, 6.0f, 25.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)17.0f, (float)13.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        left_arm.m_171599_("left_arm_r2", CubeListBuilder.m_171558_().m_171514_(72, 58).m_171488_(-3.0f, -1.0f, -3.0f, 6.0f, 25.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.25f, (float)0.0f, (float)-2.0f, (float)0.7418f, (float)0.0f, (float)-0.2182f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-17.0f, (float)-28.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        right_arm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-3.0f, -1.0f, -3.0f, 6.0f, 25.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.2182f));
        right_arm.m_171599_("right_arm_r2", CubeListBuilder.m_171558_().m_171514_(48, 84).m_171488_(-3.0f, -1.3119f, -4.9679f, 6.0f, 25.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.75f, (float)17.0f, (float)15.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-10.0f, 0.0f, -5.0f, 20.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-14.0f, -13.0f, -7.0f, 28.0f, 13.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-17.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 53).m_171488_(-6.0f, -12.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-30.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.right_arm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.0f * limbSwingAmount - 0.5236f;
        this.left_arm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.0f * limbSwingAmount - 0.48f;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

