/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DarkChestRenderer
implements BlockEntityRenderer<ChestBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("evil_reflections", "textures/item/dark_chest.png");
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;

    public DarkChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(ModelLayers.f_171275_);
        this.bottom = modelpart.m_171324_("bottom");
        this.lid = modelpart.m_171324_("lid");
        this.lock = modelpart.m_171324_("lock");
    }

    public void render(ChestBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? blockEntity.m_58900_() : (BlockState)blockEntity.m_58900_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        Block block = blockstate.m_60734_();
        if (block instanceof ChestBlock) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? ((ChestBlock)block).m_5641_(blockstate, level, blockEntity.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)neighborcombineresult.m_5649_(ChestBlock.m_51517_((LidBlockEntity)blockEntity))).get(partialTick);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)neighborcombineresult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
            VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
            this.render(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, f1, i, packedOverlay);
            poseStack.m_85849_();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float lidAngle, int packedLight, int packedOverlay) {
        lockPart.f_104203_ = lidPart.f_104203_ = -(lidAngle * 1.5707964f);
        lidPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        lockPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        bottomPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }
}

