/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.evilreflections.EvilReflectionsMod;
import net.mcreator.evilreflections.network.AnomalousFloatSyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="evil_reflections")
public class MobEffectAnomalousFloat
extends MobEffect {
    private static final ResourceLocation EFFECT_ICON = new ResourceLocation("evilreflections:textures/mob_effect/anomalousfloat.png");
    private static final Map<UUID, PlayerRotationData> playerDataMap = new ConcurrentHashMap<UUID, PlayerRotationData>();
    private static final float ROTATION_SPEED_DEGREES_PER_SECOND = 90.0f;
    private static final float SMOOTH_FACTOR = 0.15f;
    private static final float ROTATION_AXIS_X = 1.0f;
    private static final float ROTATION_AXIS_Y = 1.0f;
    private static final float ROTATION_AXIS_Z = 1.0f;
    private static final float ROTATION_CENTER_X = 0.0f;
    private static final float ROTATION_CENTER_Y = 1.5f;
    private static final float ROTATION_CENTER_Z = 0.0f;
    private static final float FLOAT_HEIGHT = 2.0f;

    public MobEffectAnomalousFloat() {
        super(MobEffectCategory.HARMFUL, 0x9900FF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6385_(entity, attributeMap, amplifier);
        if (entity instanceof Player && !entity.f_19853_.f_46443_) {
            PlayerRotationData data;
            Player player = (Player)entity;
            UUID playerId = player.m_20148_();
            PlayerRotationData playerRotationData = data = playerDataMap.computeIfAbsent(playerId, k -> new PlayerRotationData());
            synchronized (playerRotationData) {
                data.forceReset();
                data.lastTime = System.currentTimeMillis();
            }
            MobEffectAnomalousFloat.syncPlayerState(playerId, true, 0.0f);
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        if (entity instanceof Player && !entity.f_19853_.f_46443_) {
            Player player = (Player)entity;
            UUID playerId = player.m_20148_();
            MobEffectAnomalousFloat.syncPlayerState(playerId, false, 0.0f);
            playerDataMap.remove(playerId);
        }
        super.m_6386_(entity, attributeMap, amplifier);
    }

    private static void syncPlayerState(UUID playerId, boolean active, float rotation) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            try {
                EvilReflectionsMod.getNetwork().send(PacketDistributor.ALL.noArg(), (Object)new AnomalousFloatSyncPacket(playerId, active, rotation));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player && !event.getEntity().f_19853_.f_46443_) {
            Player player = (Player)event.getEntity();
            MobEffectAnomalousFloat.syncPlayerState(player.m_20148_(), false, 0.0f);
            playerDataMap.remove(player.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().f_19853_.f_46443_) {
            Player player = event.getEntity();
            MobEffectAnomalousFloat.syncPlayerState(player.m_20148_(), false, 0.0f);
            playerDataMap.remove(player.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getEntity().f_19853_.f_46443_) {
            Player player = event.getEntity();
            MobEffectAnomalousFloat.syncPlayerState(player.m_20148_(), false, 0.0f);
            playerDataMap.remove(player.m_20148_());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.f_46443_ && (player = event.player).m_21023_((MobEffect)EvilReflectionsMod.ANOMALOUS_FLOAT.get())) {
            PlayerRotationData data;
            UUID playerId = player.m_20148_();
            long currentTime = System.currentTimeMillis();
            PlayerRotationData playerRotationData = data = playerDataMap.computeIfAbsent(playerId, k -> new PlayerRotationData());
            synchronized (playerRotationData) {
                long lastTime = data.lastTime;
                float deltaTime = (float)(currentTime - lastTime) / 1000.0f;
                data.updateRotation(deltaTime);
                data.lastTime = currentTime;
                MobEffectAnomalousFloat.syncPlayerState(playerId, true, data.targetRotation);
            }
        }
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Level level = entity.f_19853_;
            try {
                double currentY = player.m_20186_();
                double groundY = this.findGroundPosition(player);
                double targetY = groundY + 2.0;
                Vec3 movement = player.m_20184_();
                if (currentY < targetY - 0.1) {
                    double distance = targetY - currentY;
                    double speed = Math.min(0.1, distance * 0.05);
                    player.m_20334_(movement.f_82479_, speed, movement.f_82481_);
                } else if (currentY > targetY + 0.1) {
                    double distance = currentY - targetY;
                    double speed = Math.min(0.1, distance * 0.05);
                    player.m_20334_(movement.f_82479_, -speed, movement.f_82481_);
                } else {
                    player.m_20334_(movement.f_82479_, movement.f_82480_ * 0.8, movement.f_82481_);
                }
                player.f_19789_ = 0.0f;
                player.m_20256_(player.m_20184_().m_82542_(0.98, 1.0, 0.98));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private double findGroundPosition(Player player) {
        try {
            for (int i = 0; i < 10; ++i) {
                BlockPos checkPos = player.m_20183_().m_6625_(i);
                if (!player.f_19853_.m_8055_(checkPos).m_60767_().m_76333_()) continue;
                return checkPos.m_123342_() + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return player.m_20186_();
    }

    private static float lerp(float start, float end, float factor) {
        float diff;
        factor = Math.max(0.0f, Math.min(1.0f, factor));
        for (diff = end - start; diff > 180.0f; diff -= 360.0f) {
        }
        while (diff < -180.0f) {
            diff += 360.0f;
        }
        return start + diff * factor;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePlayerStateFromPacket(UUID playerId, boolean active, float rotation) {
        PlayerRotationData data;
        if (playerId == null) {
            return;
        }
        PlayerRotationData playerRotationData = data = playerDataMap.computeIfAbsent(playerId, k -> new PlayerRotationData());
        synchronized (playerRotationData) {
            data.setActive(active);
            if (active) {
                data.targetRotation = rotation;
                if (data.displayRotation == 0.0f && rotation != 0.0f) {
                    data.displayRotation = rotation;
                }
            }
        }
    }

    public String m_19481_() {
        return "effect.evilreflections.anomalous_float";
    }

    private static class PlayerRotationData {
        float rotation = 0.0f;
        long lastTime = System.currentTimeMillis();
        float targetRotation = 0.0f;
        float displayRotation = 0.0f;
        boolean isActive = false;

        private PlayerRotationData() {
        }

        synchronized void updateRotation(float deltaTime) {
            this.rotation += 90.0f * deltaTime;
            if (this.rotation > 360.0f) {
                this.rotation -= 360.0f;
            }
            this.targetRotation = this.rotation;
        }

        synchronized void updateDisplayRotation() {
            this.displayRotation = MobEffectAnomalousFloat.lerp(this.displayRotation, this.targetRotation, 0.15f);
            if (this.displayRotation > 360.0f) {
                this.displayRotation -= 360.0f;
            }
            if (this.displayRotation < 0.0f) {
                this.displayRotation += 360.0f;
            }
        }

        synchronized void setActive(boolean active) {
            this.isActive = active;
            if (!active) {
                this.forceReset();
            }
        }

        synchronized void forceReset() {
            this.rotation = 0.0f;
            this.targetRotation = 0.0f;
            this.displayRotation = 0.0f;
        }
    }

    @Mod.EventBusSubscriber(modid="evil_reflections", value={Dist.CLIENT})
    public static class ClientEvents {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
            Player player = event.getEntity();
            UUID playerId = player.m_20148_();
            PlayerRotationData data = playerDataMap.get(playerId);
            if (data != null) {
                PlayerRotationData playerRotationData = data;
                synchronized (playerRotationData) {
                    if (data.isActive) {
                        data.updateDisplayRotation();
                        PoseStack poseStack = event.getPoseStack();
                        poseStack.m_85836_();
                        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(data.displayRotation * 1.0f));
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(data.displayRotation * 1.0f));
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(data.displayRotation * 1.0f));
                        poseStack.m_252880_(-0.0f, -1.5f, -0.0f);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
            Player player = event.getEntity();
            UUID playerId = player.m_20148_();
            PlayerRotationData data = playerDataMap.get(playerId);
            if (data != null) {
                PlayerRotationData playerRotationData = data;
                synchronized (playerRotationData) {
                    if (data.isActive) {
                        event.getPoseStack().m_85849_();
                    }
                }
            }
        }
    }
}

