/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.entity;

import net.mcreator.evilreflections.EvilReflectionsMod;
import net.mcreator.evilreflections.block.ShadowPrismarineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class BlockDarkFragmentEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<BlockPos> BLOCK_POS = SynchedEntityData.m_135353_(BlockDarkFragmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> BLOCK_ID = SynchedEntityData.m_135353_(BlockDarkFragmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_VALID_BLOCK = SynchedEntityData.m_135353_(BlockDarkFragmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private double angle = 0.0;
    private Vec3 velocity = Vec3.f_82478_;
    private double verticalOffset = 0.0;
    private double verticalAngle = 0.0;
    private int effectTimer = 0;
    private int skeletonAttackTimer = 0;

    public BlockDarkFragmentEntity(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
        this.m_20242_(true);
    }

    public BlockDarkFragmentEntity(Level level, BlockPos blockPos) {
        super((EntityType)EvilReflectionsMod.BLOCK_DARK_FRAGMENT_ENTITY.get(), level);
        this.m_20242_(true);
        this.f_19804_.m_135381_(BLOCK_POS, (Object)blockPos);
        this.f_19804_.m_135381_(BLOCK_ID, (Object)(blockPos.m_123341_() ^ blockPos.m_123342_() ^ blockPos.m_123343_()));
        this.f_19804_.m_135381_(HAS_VALID_BLOCK, (Object)true);
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)blockPos);
        this.m_6034_(blockCenter.f_82479_, blockCenter.f_82480_, blockCenter.f_82481_);
    }

    protected Item m_7881_() {
        return (Item)EvilReflectionsMod.DARK_FRAGMENT.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BLOCK_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(BLOCK_ID, (Object)0);
        this.f_19804_.m_135372_(HAS_VALID_BLOCK, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        BlockPos blockPos = this.getBlockPos();
        if (blockPos != null && ((Boolean)this.f_19804_.m_135370_(HAS_VALID_BLOCK)).booleanValue()) {
            compound.m_128405_("BlockX", blockPos.m_123341_());
            compound.m_128405_("BlockY", blockPos.m_123342_());
            compound.m_128405_("BlockZ", blockPos.m_123343_());
            compound.m_128405_("BlockID", ((Integer)this.f_19804_.m_135370_(BLOCK_ID)).intValue());
            BlockState blockState = this.f_19853_.m_8055_(blockPos);
            if (blockState.m_60734_() instanceof ShadowPrismarineBlock) {
                compound.m_128405_("BlockStateId", Block.m_49956_((BlockState)blockState));
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("BlockX") && compound.m_128441_("BlockY") && compound.m_128441_("BlockZ")) {
            int blockX = compound.m_128451_("BlockX");
            int blockY = compound.m_128451_("BlockY");
            int blockZ = compound.m_128451_("BlockZ");
            BlockPos blockPos = new BlockPos(blockX, blockY, blockZ);
            this.f_19804_.m_135381_(BLOCK_POS, (Object)blockPos);
            this.f_19804_.m_135381_(BLOCK_ID, (Object)(blockX ^ blockY ^ blockZ));
            if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
                BlockState blockState = this.f_19853_.m_8055_(blockPos);
                if (compound.m_128441_("BlockStateId")) {
                    int currentBlockStateId;
                    int savedBlockStateId = compound.m_128451_("BlockStateId");
                    if (savedBlockStateId == (currentBlockStateId = Block.m_49956_((BlockState)blockState)) && blockState.m_60734_() instanceof ShadowPrismarineBlock) {
                        this.f_19804_.m_135381_(HAS_VALID_BLOCK, (Object)true);
                        Vec3 blockCenter = Vec3.m_82512_((Vec3i)blockPos);
                        this.m_6034_(blockCenter.f_82479_, blockCenter.f_82480_, blockCenter.f_82481_);
                    } else {
                        this.f_19804_.m_135381_(HAS_VALID_BLOCK, (Object)false);
                    }
                } else if (blockState.m_60734_() instanceof ShadowPrismarineBlock) {
                    this.f_19804_.m_135381_(HAS_VALID_BLOCK, (Object)true);
                    Vec3 blockCenter = Vec3.m_82512_((Vec3i)blockPos);
                    this.m_6034_(blockCenter.f_82479_, blockCenter.f_82480_, blockCenter.f_82481_);
                } else {
                    this.f_19804_.m_135381_(HAS_VALID_BLOCK, (Object)false);
                }
            } else {
                this.f_19804_.m_135381_(HAS_VALID_BLOCK, (Object)true);
                Vec3 blockCenter = Vec3.m_82512_((Vec3i)blockPos);
                this.m_6034_(blockCenter.f_82479_, blockCenter.f_82480_, blockCenter.f_82481_);
            }
        } else {
            this.f_19804_.m_135381_(HAS_VALID_BLOCK, (Object)false);
        }
    }

    public BlockPos getBlockPos() {
        return (Boolean)this.f_19804_.m_135370_(HAS_VALID_BLOCK) != false ? (BlockPos)this.f_19804_.m_135370_(BLOCK_POS) : null;
    }

    public void setBlockPos(BlockPos pos) {
        this.f_19804_.m_135381_(BLOCK_POS, (Object)pos);
        this.f_19804_.m_135381_(BLOCK_ID, (Object)(pos.m_123341_() ^ pos.m_123342_() ^ pos.m_123343_()));
        this.f_19804_.m_135381_(HAS_VALID_BLOCK, (Object)true);
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)pos);
        this.m_6034_(blockCenter.f_82479_, blockCenter.f_82480_, blockCenter.f_82481_);
    }

    public int getBlockId() {
        return (Integer)this.f_19804_.m_135370_(BLOCK_ID);
    }

    public boolean hasValidBlock() {
        return (Boolean)this.f_19804_.m_135370_(HAS_VALID_BLOCK);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.hasValidBlock()) {
            this.m_146870_();
            return;
        }
        BlockPos blockPos = this.getBlockPos();
        if (blockPos == null || !(this.f_19853_.m_8055_(blockPos).m_60734_() instanceof ShadowPrismarineBlock)) {
            this.f_19804_.m_135381_(HAS_VALID_BLOCK, (Object)false);
            this.m_146870_();
            if (this.f_19853_ instanceof ServerLevel) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144050_, SoundSource.BLOCKS, 2.0f, 1.0f);
            }
            return;
        }
        double radius = 1.5;
        this.angle += 0.10471975511965977;
        this.verticalAngle += 0.15707963267948966;
        this.verticalOffset = 0.5 * Math.sin(this.verticalAngle);
        Vec3 orbitCenter = Vec3.m_82512_((Vec3i)blockPos);
        double offsetX = radius * Math.cos(this.angle);
        double offsetZ = radius * Math.sin(this.angle);
        Vec3 targetPosition = orbitCenter.m_82520_(offsetX, this.verticalOffset, offsetZ);
        Vec3 desiredVelocity = targetPosition.m_82546_(this.m_20182_());
        this.velocity = this.velocity.m_82490_(0.9).m_82549_(desiredVelocity.m_82490_(0.1));
        Vec3 newPos = this.m_20182_().m_82549_(this.velocity.m_82490_(0.1));
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        ++this.effectTimer;
        if (this.effectTimer >= 20) {
            this.effectTimer = 0;
            this.applyEffectsToNearbyMobs();
        }
        ++this.skeletonAttackTimer;
        if (this.skeletonAttackTimer >= 60) {
            this.skeletonAttackTimer = 0;
            this.makeSkeletonsAttackNearbyMobs();
        }
        if (this.f_19853_ instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)this.f_19853_;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 0.05, 0.05, 0.05, 0.01);
        }
    }

    private void applyEffectsToNearbyMobs() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        BlockPos blockPos = this.getBlockPos();
        if (blockPos == null) {
            return;
        }
        AABB area = new AABB(blockPos).m_82400_(5.0);
        this.f_19853_.m_45976_(Mob.class, area).forEach(mob -> {
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
        });
    }

    private void makeSkeletonsAttackNearbyMobs() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        BlockPos blockPos = this.getBlockPos();
        if (blockPos == null) {
            return;
        }
        AABB skeletonArea = new AABB(blockPos).m_82400_(10.0);
        this.f_19853_.m_45976_(Skeleton.class, skeletonArea).forEach(skeleton -> {
            AABB mobArea = new AABB(skeleton.m_20183_()).m_82400_(15.0);
            this.f_19853_.m_45976_(Mob.class, mobArea).forEach(mob -> {
                if (!(mob instanceof Skeleton)) {
                    skeleton.m_6710_((LivingEntity)mob);
                }
            });
        });
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

