/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.entity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.evilreflections.EvilReflectionsMod;
import net.mcreator.evilreflections.item.DarkSwordItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="evil_reflections")
public class DarkBossEntity
extends Monster {
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final AttributeModifier KNOCKBACK_RESISTANCE_MODIFIER = new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback resistance", 1.0, AttributeModifier.Operation.ADDITION);
    private final ServerBossEvent bossEvent;
    private static final int BOSS_BAR_VISIBILITY_RANGE = 32;
    private int timeSinceLastHit = 0;
    private int regenTimer = 0;
    private float particleAngle = 0.0f;
    private int combinedAttackCooldown = 0;
    private static final EntityDataAccessor<Boolean> IS_REGENERATING = SynchedEntityData.m_135353_(DarkBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPAWN_COMBINED_PARTICLES = SynchedEntityData.m_135353_(DarkBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMBINED_PARTICLE_TIMER = SynchedEntityData.m_135353_(DarkBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int lightningCounter = 0;

    public DarkBossEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.m_21530_();
        this.bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        this.m_21051_(Attributes.f_22278_).m_22125_(KNOCKBACK_RESISTANCE_MODIFIER);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_REGENERATING, (Object)false);
        this.f_19804_.m_135372_(SPAWN_COMBINED_PARTICLES, (Object)false);
        this.f_19804_.m_135372_(COMBINED_PARTICLE_TIMER, (Object)0);
    }

    public boolean isRegenerating() {
        return (Boolean)this.f_19804_.m_135370_(IS_REGENERATING);
    }

    public void setRegenerating(boolean regenerating) {
        this.f_19804_.m_135381_(IS_REGENERATING, (Object)regenerating);
    }

    public boolean shouldSpawnCombinedParticles() {
        return (Boolean)this.f_19804_.m_135370_(SPAWN_COMBINED_PARTICLES);
    }

    public void setSpawnCombinedParticles(boolean spawn) {
        this.f_19804_.m_135381_(SPAWN_COMBINED_PARTICLES, (Object)spawn);
    }

    public int getCombinedParticleTimer() {
        return (Integer)this.f_19804_.m_135370_(COMBINED_PARTICLE_TIMER);
    }

    public void setCombinedParticleTimer(int timer) {
        this.f_19804_.m_135381_(COMBINED_PARTICLE_TIMER, (Object)timer);
    }

    public static AttributeSupplier.Builder createAttributes() {
        double maxHealth = 259.0;
        double attackDamage = 3.0;
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, maxHealth).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, attackDamage).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22277_, 40.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return !DarkBossEntity.this.m_5912_() && super.m_8036_();
            }
        });
    }

    public static boolean checkSpawnRules(EntityType<DarkBossEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        if (spawnType == MobSpawnType.SPAWNER) {
            return true;
        }
        return DarkBossStructureDetector.isStructureComplete(level, pos) && Monster.m_219013_(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)randomSource);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.level.m_5776_()) {
            ServerLevel serverLevel = (ServerLevel)event.level;
            for (ServerPlayer player : serverLevel.m_6907_()) {
                BlockPos playerPos = player.m_20183_();
                DarkBossStructureDetector.checkStructuresInRange(serverLevel, playerPos, 16);
            }
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        if (this.m_20280_((Entity)player) <= 1024.0) {
            this.bossEvent.m_6543_(player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void m_8119_() {
        super.m_8119_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46461_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 3.0f, -0.6f);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.combinedAttackCooldown > 0) {
                --this.combinedAttackCooldown;
            } else {
                int newCooldown;
                this.performCombinedAttack();
                int minCooldown = 600;
                int maxCooldown = 800;
                if ((double)this.m_21223_() < (double)this.m_21233_() * 0.25) {
                    minCooldown = 75;
                    maxCooldown = 250;
                }
                this.combinedAttackCooldown = newCooldown = minCooldown + this.f_19796_.m_188503_(maxCooldown - minCooldown + 1);
            }
            if (this.getCombinedParticleTimer() > 0) {
                this.setCombinedParticleTimer(this.getCombinedParticleTimer() - 1);
                if (this.getCombinedParticleTimer() == 0) {
                    this.setSpawnCombinedParticles(false);
                }
            }
            for (ServerPlayer player : ((ServerLevel)this.f_19853_).m_6907_()) {
                if (this.m_20280_((Entity)player) <= 1024.0) {
                    if (!this.bossEvent.m_8324_().contains(player)) {
                        this.bossEvent.m_6543_(player);
                    }
                    if (!player.f_8941_.m_9294_()) continue;
                    this.shootLightning(player);
                    continue;
                }
                if (!this.bossEvent.m_8324_().contains(player)) continue;
                this.bossEvent.m_6539_(player);
            }
            if (this.f_19853_ instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)this.f_19853_;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_(), 10, 0.5, 0.5, 0.5, 0.01);
            }
            if (this.f_19797_ % 200 == 0) {
                this.teleport();
            }
            if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                ++this.timeSinceLastHit;
                if (this.timeSinceLastHit >= 200 && !this.isRegenerating()) {
                    this.setRegenerating(true);
                    this.regenTimer = 0;
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12563_, SoundSource.HOSTILE, 1.0f, 0.8f);
                }
                if (this.isRegenerating()) {
                    ++this.regenTimer;
                    if (this.regenTimer >= 20) {
                        this.regenTimer = 0;
                        float currentHealth = this.m_21223_();
                        float maxHealth = this.m_21233_();
                        float healthToRegen = Math.min(100.0f, maxHealth - currentHealth);
                        if (healthToRegen > 0.0f) {
                            this.m_5634_(healthToRegen);
                            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12558_, SoundSource.HOSTILE, 0.8f, 1.2f);
                        }
                        if (this.m_21223_() >= this.m_21233_()) {
                            this.setRegenerating(false);
                            this.timeSinceLastHit = 0;
                            this.regenTimer = 0;
                        }
                    }
                    if (this.f_19797_ % 10 == 0) {
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12286_, SoundSource.HOSTILE, 0.5f, 1.5f);
                    }
                }
            }
        }
        if (this.f_19853_.f_46443_) {
            if (this.isRegenerating()) {
                this.spawnRegenerationParticles();
            }
            if (this.shouldSpawnCombinedParticles()) {
                this.spawnCombinedParticles();
            }
        }
    }

    private void teleport() {
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 16.0;
        double y = this.m_20186_();
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 16.0;
        BlockPos newPos = new BlockPos((int)x, (int)y, (int)z);
        while (newPos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_(newPos).m_60767_().m_76334_()) {
            newPos = newPos.m_7495_();
        }
        if (newPos.m_123342_() <= this.f_19853_.m_141937_()) {
            return;
        }
        this.m_6021_((double)newPos.m_123341_() + 0.5, newPos.m_123342_() + 1, (double)newPos.m_123343_() + 0.5);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, -0.4f);
    }

    private void shootLightning(ServerPlayer player) {
        if (this.f_19797_ % 600 == 0) {
            this.lightningCounter = 4;
        }
        if (this.lightningCounter > 0 && this.f_19797_ % 50 == 0) {
            ServerLevel serverLevel = (ServerLevel)this.f_19853_;
            LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
            lightningBolt.m_6027_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            lightningBolt.m_20879_(player);
            serverLevel.m_7967_((Entity)lightningBolt);
            --this.lightningCounter;
        }
    }

    private boolean isHoldingDarkSword(Player player) {
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        return mainHandItem.m_41720_() instanceof DarkSwordItem || offHandItem.m_41720_() instanceof DarkSwordItem;
    }

    private void performCombinedAttack() {
        List playersInRange = this.f_19853_.m_45976_(Player.class, this.m_20191_().m_82400_(12.0));
        if (!playersInRange.isEmpty()) {
            for (Player player : playersInRange) {
                player.m_7292_(new MobEffectInstance((MobEffect)EvilReflectionsMod.ANOMALOUS_FLOAT.get(), 400, 0));
                if (!this.isHoldingDarkSword(player)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 300, 1));
                }
                this.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12049_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            this.setSpawnCombinedParticles(true);
            this.setCombinedParticleTimer(10);
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.bossEvent.m_7706_();
        this.bossEvent.m_8321_(false);
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5));
            int dropCount = this.f_19796_.m_188503_(19) + 1;
            if (source.m_7639_() instanceof Player) {
                Player player = (Player)source.m_7639_();
                int lootingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44982_, (ItemStack)player.m_21205_());
                dropCount += lootingLevel * 2;
            }
            for (int i = 0; i < dropCount; ++i) {
                this.m_19983_(new ItemStack((ItemLike)EvilReflectionsMod.DARK_FRAGMENT.get()));
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_19385_().equals("magic") || source.m_19385_().equals("lightningBolt") || source.m_19385_().equals("cactus") || source.m_19385_().equals("drown") || source.m_7640_() instanceof AbstractArrow || source.m_7640_() instanceof ThrownTrident) {
            return false;
        }
        this.timeSinceLastHit = 0;
        this.setRegenerating(false);
        return super.m_6469_(source, amount);
    }

    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_19385_().equals("inFire") || source.m_19385_().equals("onFire") || source.m_19385_().equals("lava");
    }

    public boolean m_7301_(MobEffectInstance potioneffect) {
        return false;
    }

    private void spawnRegenerationParticles() {
        this.particleAngle += 0.2f;
        float radius = 2.0f;
        for (int i = 0; i < 2; ++i) {
            float angle = this.particleAngle + (float)i * (float)Math.PI;
            double x = this.m_20185_() + Math.cos(angle) * (double)radius;
            double y = this.m_20186_() + (double)this.m_20192_() - 0.5;
            double z = this.m_20189_() + Math.sin(angle) * (double)radius;
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123755_, true, x, y, z, 0.0, 0.1, 0.0);
        }
    }

    private void spawnCombinedParticles() {
        double zSpeed;
        double ySpeed;
        double xSpeed;
        double zOffset;
        double yOffset;
        double xOffset;
        int i;
        for (i = 0; i < 15; ++i) {
            xOffset = (this.f_19796_.m_188501_() - 0.5f) * 2.0f;
            yOffset = this.m_20206_() / 2.0f + (this.f_19796_.m_188501_() - 0.5f) * 1.0f;
            zOffset = (this.f_19796_.m_188501_() - 0.5f) * 2.0f;
            xSpeed = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
            ySpeed = (this.f_19796_.m_188501_() - 0.5f) * 0.1f;
            zSpeed = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_() + xOffset, this.m_20186_() + yOffset, this.m_20189_() + zOffset, xSpeed, ySpeed, zSpeed);
        }
        for (i = 0; i < 20; ++i) {
            xOffset = (this.f_19796_.m_188501_() - 0.5f) * 2.0f;
            yOffset = this.m_20206_() / 2.0f + (this.f_19796_.m_188501_() - 0.5f) * 1.0f;
            zOffset = (this.f_19796_.m_188501_() - 0.5f) * 2.0f;
            xSpeed = (this.f_19796_.m_188501_() - 0.5f) * 0.1f;
            ySpeed = (this.f_19796_.m_188501_() - 0.5f) * 0.05f;
            zSpeed = (this.f_19796_.m_188501_() - 0.5f) * 0.1f;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_() + xOffset, this.m_20186_() + yOffset, this.m_20189_() + zOffset, xSpeed, ySpeed, zSpeed);
        }
        float radius = 1.5f;
        for (int i2 = 0; i2 < 12; ++i2) {
            float angle = (float)((double)i2 * Math.PI * 2.0 / 12.0);
            double x = this.m_20185_() + Math.cos(angle) * (double)radius;
            double y = this.m_20186_() + (double)(this.m_20206_() / 2.0f);
            double z = this.m_20189_() + Math.sin(angle) * (double)radius;
            if (i2 % 2 == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, x, y, z, 0.0, 0.1, 0.0);
                continue;
            }
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123799_, x, y, z, 0.0, 0.05, 0.0);
        }
    }

    static class DarkBossStructureDetector {
        private static final int TOTAL_BLOCKS = 11;

        DarkBossStructureDetector() {
        }

        public static boolean isStructureComplete(ServerLevelAccessor level, BlockPos pos) {
            return DarkBossStructureDetector.checkStructure(level, pos) == 11;
        }

        public static void checkStructuresInRange(ServerLevel level, BlockPos centerPos, int range) {
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos checkPos = centerPos.m_7918_(x, y, z);
                        if (!DarkBossStructureDetector.isStructureComplete((ServerLevelAccessor)level, checkPos)) continue;
                        DarkBossStructureDetector.removeStructure(level, checkPos);
                        DarkBossStructureDetector.spawnDarkBoss(level, checkPos);
                    }
                }
            }
        }

        public static int checkStructure(ServerLevelAccessor level, BlockPos pos) {
            int blocksPlaced = 0;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, -1, z);
                    if (level.m_8055_(checkPos).m_60734_() != Blocks.f_50080_) continue;
                    ++blocksPlaced;
                }
            }
            for (int y = 0; y <= 1; ++y) {
                BlockPos checkPos = pos.m_6630_(y);
                if (level.m_8055_(checkPos).m_60734_() != Blocks.f_50353_) continue;
                ++blocksPlaced;
            }
            return blocksPlaced;
        }

        private static void removeStructure(ServerLevel level, BlockPos pos) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos removePos = pos.m_7918_(x, -1, z);
                    level.m_7731_(removePos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
            for (int y = 0; y <= 1; ++y) {
                BlockPos removePos = pos.m_6630_(y);
                level.m_7731_(removePos, Blocks.f_50016_.m_49966_(), 3);
            }
        }

        private static void spawnDarkBoss(ServerLevel level, BlockPos pos) {
            DarkBossEntity darkBoss = (DarkBossEntity)((EntityType)EvilReflectionsMod.DARK_BOSS.get()).m_20615_((Level)level);
            if (darkBoss != null) {
                darkBoss.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                Difficulty difficulty = level.m_46791_();
                switch (difficulty) {
                    case PEACEFUL: {
                        darkBoss.m_21051_(Attributes.f_22276_).m_22100_(100.0);
                        darkBoss.m_21051_(Attributes.f_22281_).m_22100_(2.0);
                        darkBoss.m_21153_(100.0f);
                        break;
                    }
                    case EASY: {
                        darkBoss.m_21051_(Attributes.f_22276_).m_22100_(150.0);
                        darkBoss.m_21051_(Attributes.f_22281_).m_22100_(4.0);
                        darkBoss.m_21153_(150.0f);
                        break;
                    }
                    case NORMAL: {
                        darkBoss.m_21051_(Attributes.f_22276_).m_22100_(259.0);
                        darkBoss.m_21051_(Attributes.f_22281_).m_22100_(9.0);
                        darkBoss.m_21153_(259.0f);
                        break;
                    }
                    case HARD: {
                        darkBoss.m_21051_(Attributes.f_22276_).m_22100_(650.0);
                        darkBoss.m_21051_(Attributes.f_22281_).m_22100_(19.5);
                        darkBoss.m_21153_(650.0f);
                    }
                }
                level.m_7967_((Entity)darkBoss);
            }
        }
    }
}

