/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.entity;

import java.util.List;
import java.util.UUID;
import net.mcreator.evilreflections.EvilReflectionsMod;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="evil_reflections")
public class DarkFragmentEntity
extends ThrowableItemProjectile {
    private LivingEntity owner;
    private UUID ownerUUID;
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 400;
    private double angle = 0.0;
    private Vec3 orbitCenter;
    private Vec3 velocity = Vec3.f_82478_;
    private double verticalOffset = 0.0;
    private double verticalAngle = 0.0;
    private Vec3 targetPosition = Vec3.f_82478_;
    private float smoothness = 0.15f;
    private boolean initialized = false;

    public DarkFragmentEntity(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
        this.m_20242_(true);
        this.m_20331_(true);
    }

    public DarkFragmentEntity(LivingEntity owner, Level level) {
        super((EntityType)EvilReflectionsMod.DARK_FRAGMENT_ENTITY.get(), owner, level);
        this.owner = owner;
        this.ownerUUID = owner.m_20148_();
        this.m_20242_(true);
        this.m_20331_(true);
        this.orbitCenter = owner.m_20182_().m_82520_(0.0, 1.0, 0.0);
        this.initialized = true;
        if (level.f_46443_) {
            System.out.println("DarkFragmentEntity creada para el jugador: " + owner.m_7755_().getString());
        }
    }

    protected Item m_7881_() {
        return (Item)EvilReflectionsMod.DARK_FRAGMENT.get();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        compound.m_128347_("Angle", this.angle);
        compound.m_128347_("VerticalAngle", this.verticalAngle);
        compound.m_128405_("Lifetime", this.lifetime);
        compound.m_128379_("Initialized", this.initialized);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        this.angle = compound.m_128459_("Angle");
        this.verticalAngle = compound.m_128459_("VerticalAngle");
        this.lifetime = compound.m_128451_("Lifetime");
        this.initialized = compound.m_128471_("Initialized");
    }

    private void updateOwnerFromUUID() {
        if (this.ownerUUID != null && this.owner == null) {
            AABB searchArea = new AABB(this.m_20182_().f_82479_ - 1000.0, this.m_20182_().f_82480_ - 1000.0, this.m_20182_().f_82481_ - 1000.0, this.m_20182_().f_82479_ + 1000.0, this.m_20182_().f_82480_ + 1000.0, this.m_20182_().f_82481_ + 1000.0);
            List entities = this.f_19853_.m_6249_((Entity)null, searchArea, entity -> true);
            for (Entity entity2 : entities) {
                if (!entity2.m_20148_().equals(this.ownerUUID) || !(entity2 instanceof LivingEntity)) continue;
                this.owner = (LivingEntity)entity2;
                this.initialized = true;
                break;
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.initialized) {
            this.updateOwnerFromUUID();
            if (this.owner != null) {
                this.initialized = true;
                this.orbitCenter = this.owner.m_20182_().m_82520_(0.0, 1.0, 0.0);
            }
        }
        if (this.initialized && this.owner != null && this.owner.m_6084_()) {
            ++this.lifetime;
            if (this.lifetime > 400) {
                this.m_146870_();
                return;
            }
            double radius = 1.5;
            this.angle += 0.10471975511965977;
            this.verticalAngle += 0.15707963267948966;
            this.verticalOffset = 0.5 * Math.sin(this.verticalAngle);
            this.orbitCenter = this.owner.m_20182_().m_82520_(0.0, 1.0, 0.0);
            double offsetX = radius * Math.cos(this.angle);
            double offsetZ = radius * Math.sin(this.angle);
            this.targetPosition = this.orbitCenter.m_82520_(offsetX, this.verticalOffset, offsetZ);
            Vec3 currentPosition = this.m_20182_();
            Vec3 direction = this.targetPosition.m_82546_(currentPosition);
            this.velocity = this.velocity.m_82490_((double)(1.0f - this.smoothness)).m_82549_(direction.m_82490_((double)this.smoothness));
            Vec3 newPos = currentPosition.m_82549_(this.velocity);
            this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            this.m_20242_(true);
            if (this.f_19853_ instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)this.f_19853_;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 0.05, 0.05, 0.05, 0.01);
            }
        } else if (this.lifetime > 100) {
            this.m_146870_();
        }
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (!level.f_46443_) {
            level.m_45976_(DarkFragmentEntity.class, entity.m_20191_().m_82400_(3.0)).stream().filter(darkFragment -> darkFragment.owner == entity).findFirst().ifPresent(darkFragment -> {
                event.setCanceled(true);
                float healAmount = event.getAmount() * 2.0f;
                entity.m_5634_(healAmount);
                level.m_6263_(null, darkFragment.m_20185_(), darkFragment.m_20186_(), darkFragment.m_20189_(), SoundEvents.f_144050_, SoundSource.BLOCKS, 2.0f, 1.0f);
                darkFragment.m_146870_();
            });
        }
    }
}

