/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.mcreator.evilreflections.EvilReflectionsMod;
import net.mcreator.evilreflections.client.model.DarkLightningBoltModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Quaternionf;

public class DarkLightningBoltEntity
extends LightningBolt {
    public DarkLightningBoltEntity(EntityType<? extends LightningBolt> type, Level world) {
        super(type, world);
    }

    public DarkLightningBoltEntity(Level world, double x, double y, double z, boolean visualOnly) {
        super((EntityType)EvilReflectionsMod.DARK_LIGHTNING_BOLT.get(), world);
        this.m_6034_(x, y, z);
        this.m_20874_(visualOnly);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20095_();
        this.removeFire();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
                double d1 = this.m_20186_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
                double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
        if (!this.f_19853_.f_46443_) {
            double radius = 5.0;
            List nearbyEntities = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(radius));
            for (LivingEntity entity : nearbyEntities) {
                if (entity instanceof Player || !entity.m_6084_()) continue;
                entity.m_6469_(this.f_19853_.m_269111_().m_269548_(), 20.0f);
            }
        }
    }

    private void removeFire() {
        if (!this.f_19853_.f_46443_) {
            int radius = 3;
            BlockPos center = this.m_20183_();
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-radius, -radius, -radius), (BlockPos)center.m_7918_(radius, radius, radius))) {
                if (this.f_19853_.m_8055_(pos).m_60734_() != Blocks.f_50083_) continue;
                this.f_19853_.m_7471_(pos, false);
            }
        }
    }

    public static void spawnDarkLightningAroundPlayer(Level world, double x, double y, double z) {
        if (!world.f_46443_) {
            Vec3[] positions;
            for (Vec3 pos : positions = new Vec3[]{new Vec3(x + 2.0, y, z), new Vec3(x - 2.0, y, z), new Vec3(x, y, z + 2.0), new Vec3(x, y, z - 2.0)}) {
                DarkLightningBoltEntity darkLightning = new DarkLightningBoltEntity(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, false);
                world.m_7967_((Entity)darkLightning);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DarkLightningBoltRenderer
    extends EntityRenderer<DarkLightningBoltEntity> {
        private static final ResourceLocation DARK_LIGHTNING_LOCATION = new ResourceLocation("evil_reflections:textures/entities/dark_lightning_bolt.png");
        private final DarkLightningBoltModel<DarkLightningBoltEntity> model;

        public DarkLightningBoltRenderer(EntityRendererProvider.Context context) {
            super(context);
            this.model = new DarkLightningBoltModel(context.m_174023_(DarkLightningBoltModel.LAYER_LOCATION));
        }

        public void render(DarkLightningBoltEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 1.5, 0.0);
            float rotation = ((float)entity.f_19797_ + partialTicks) * 0.5f;
            matrixStack.m_252781_(new Quaternionf().rotationY(rotation));
            matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
            this.model.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, 0.0f, 0.0f);
            this.model.m_7695_(matrixStack, buffer.m_6299_(this.model.m_103119_(DARK_LIGHTNING_LOCATION)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
            super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        }

        public ResourceLocation getTextureLocation(DarkLightningBoltEntity entity) {
            return DARK_LIGHTNING_LOCATION;
        }
    }

    @Mod.EventBusSubscriber(modid="evil_reflections", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientHandler {
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)EvilReflectionsMod.DARK_LIGHTNING_BOLT.get(), DarkLightningBoltRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(DarkLightningBoltModel.LAYER_LOCATION, DarkLightningBoltModel::createBodyLayer);
        }
    }
}

