/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.evilreflections.EvilReflectionsMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class EvilReflectionEntity
extends Monster {
    private int attackAnimationTick;
    private Player nearestPlayer;
    private boolean hasPlayedSpawnEffects = false;
    private static final double SPAWN_CHECK_RADIUS = 32.0;
    private Difficulty spawnDifficulty = null;
    private long lastDamageTime = 0L;
    private int regenerationCooldown = 0;
    private boolean isRegenerating = false;
    private static final int REGENERATION_COOLDOWN_TIME = 100;
    private static final int DAMAGE_WAIT_TIME = 100;
    private static final float REGENERATION_AMOUNT = 4.0f;
    private static final int REGENERATION_INTERVAL = 20;
    private int regenerationTimer = 0;

    public EvilReflectionEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData result = super.m_6518_(level, difficulty, spawnType, spawnData, dataTag);
        this.spawnDifficulty = difficulty.m_19048_();
        this.setMaxHealthBasedOnDifficulty();
        this.setDamageBasedOnDifficulty();
        if (!this.f_19853_.m_5776_() && !this.hasPlayedSpawnEffects) {
            this.playSpawnEffects((ServerLevel)this.f_19853_, this.m_20182_());
            this.hasPlayedSpawnEffects = true;
        }
        return result;
    }

    private void setMaxHealthBasedOnDifficulty() {
        AttributeInstance maxHealthAttr;
        if (this.spawnDifficulty == null) {
            this.spawnDifficulty = this.f_19853_.m_46791_();
        }
        if ((maxHealthAttr = this.m_21051_(Attributes.f_22276_)) != null) {
            double baseValue;
            double newValue = baseValue = maxHealthAttr.m_22115_();
            switch (this.spawnDifficulty) {
                case PEACEFUL: {
                    newValue = 0.0;
                    break;
                }
                case EASY: {
                    newValue = 15.0;
                    break;
                }
                case NORMAL: {
                    newValue = 20.0;
                    break;
                }
                case HARD: {
                    newValue = 50.0;
                }
            }
            maxHealthAttr.m_22100_(newValue);
            this.m_21153_((float)newValue);
            if (!this.f_19853_.m_5776_()) {
                System.out.println("EvilReflection spawn difficulty: " + this.spawnDifficulty + ", Max health set to: " + newValue);
            }
        }
    }

    private void setDamageBasedOnDifficulty() {
        AttributeInstance attackDamageAttr;
        if (this.spawnDifficulty == null) {
            this.spawnDifficulty = this.f_19853_.m_46791_();
        }
        if ((attackDamageAttr = this.m_21051_(Attributes.f_22281_)) != null) {
            double baseValue;
            double newValue = baseValue = attackDamageAttr.m_22115_();
            switch (this.spawnDifficulty) {
                case PEACEFUL: {
                    newValue = 0.0;
                    break;
                }
                case EASY: {
                    newValue = 2.0;
                    break;
                }
                case NORMAL: {
                    newValue = 5.0;
                    break;
                }
                case HARD: {
                    newValue = 10.0;
                }
            }
            attackDamageAttr.m_22100_(newValue);
            if (!this.f_19853_.m_5776_()) {
                System.out.println("EvilReflection spawn difficulty: " + this.spawnDifficulty + ", Attack damage set to: " + newValue);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        AttributeInstance attackDamageAttr;
        super.m_7380_(compound);
        if (this.spawnDifficulty != null) {
            compound.m_128359_("SpawnDifficulty", this.spawnDifficulty.name());
        }
        compound.m_128356_("LastDamageTime", this.lastDamageTime);
        compound.m_128405_("RegenerationCooldown", this.regenerationCooldown);
        compound.m_128379_("IsRegenerating", this.isRegenerating);
        compound.m_128405_("RegenerationTimer", this.regenerationTimer);
        AttributeInstance maxHealthAttr = this.m_21051_(Attributes.f_22276_);
        if (maxHealthAttr != null) {
            compound.m_128347_("MaxHealth", maxHealthAttr.m_22115_());
        }
        if ((attackDamageAttr = this.m_21051_(Attributes.f_22281_)) != null) {
            compound.m_128347_("AttackDamage", attackDamageAttr.m_22115_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("SpawnDifficulty")) {
            try {
                this.spawnDifficulty = Difficulty.valueOf((String)compound.m_128461_("SpawnDifficulty"));
            }
            catch (IllegalArgumentException e) {
                this.spawnDifficulty = this.f_19853_.m_46791_();
            }
        } else {
            this.spawnDifficulty = this.f_19853_.m_46791_();
        }
        this.lastDamageTime = compound.m_128454_("LastDamageTime");
        this.regenerationCooldown = compound.m_128451_("RegenerationCooldown");
        this.isRegenerating = compound.m_128471_("IsRegenerating");
        this.regenerationTimer = compound.m_128451_("RegenerationTimer");
        if (compound.m_128441_("MaxHealth")) {
            double savedMaxHealth = compound.m_128459_("MaxHealth");
            AttributeInstance maxHealthAttr = this.m_21051_(Attributes.f_22276_);
            if (maxHealthAttr != null) {
                maxHealthAttr.m_22100_(savedMaxHealth);
                this.m_21153_((float)savedMaxHealth);
            }
        }
        if (compound.m_128441_("AttackDamage")) {
            double savedAttackDamage = compound.m_128459_("AttackDamage");
            AttributeInstance attackDamageAttr = this.m_21051_(Attributes.f_22281_);
            if (attackDamageAttr != null) {
                attackDamageAttr.m_22100_(savedAttackDamage);
            }
        }
    }

    public void initializeForManualSpawn(ServerLevel level) {
        DifficultyInstance difficulty = level.m_6436_(this.m_20183_());
        this.m_6518_((ServerLevelAccessor)level, difficulty, MobSpawnType.SPAWN_EGG, null, null);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.lastDamageTime = this.f_19853_.m_46467_();
        if (this.isRegenerating) {
            this.isRegenerating = false;
            this.regenerationCooldown = 100;
        }
        if (source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268714_) || source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268434_) || source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268739_) || source.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        ItemStack darkFragment = new ItemStack((ItemLike)EvilReflectionsMod.DARK_FRAGMENT.get());
        int count = 1 + this.f_19796_.m_188503_(1 + looting);
        this.m_19983_(darkFragment.m_41620_(count));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.spawnDifficulty == Difficulty.HARD && !this.f_19853_.f_46443_) {
            long currentTime = this.f_19853_.m_46467_();
            if (this.regenerationCooldown > 0) {
                --this.regenerationCooldown;
            }
            if (currentTime - this.lastDamageTime >= 100L && this.regenerationCooldown <= 0) {
                if (this.m_21223_() < this.m_21233_()) {
                    if (!this.isRegenerating) {
                        this.isRegenerating = true;
                        this.regenerationTimer = 0;
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11862_, SoundSource.HOSTILE, 0.5f, 1.0f);
                    }
                    ++this.regenerationTimer;
                    if (this.regenerationTimer >= 20) {
                        this.m_5634_(4.0f);
                        this.regenerationTimer = 0;
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11865_, SoundSource.HOSTILE, 0.3f, 0.8f);
                        if (this.f_19853_ instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)this.f_19853_;
                            for (int i = 0; i < 5; ++i) {
                                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.8;
                                double offsetY = this.f_19796_.m_188500_() * 0.5;
                                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.8;
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + offsetX, this.m_20186_() + 1.0 + offsetY, this.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                    }
                } else if (this.isRegenerating) {
                    this.isRegenerating = false;
                    this.regenerationCooldown = 100;
                }
            } else if (this.isRegenerating) {
                this.isRegenerating = false;
                this.regenerationCooldown = 100;
            }
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        this.updateNearestPlayer();
        this.copyPlayerArmor();
        if (this.f_19853_.m_46461_() && !this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void updateNearestPlayer() {
        AABB searchArea = this.m_20191_().m_82400_(16.0);
        List nearbyPlayers = this.f_19853_.m_45976_(Player.class, searchArea);
        if (!nearbyPlayers.isEmpty()) {
            this.nearestPlayer = (Player)nearbyPlayers.get(0);
            for (Player player : nearbyPlayers) {
                if (!(this.m_20280_((Entity)player) < this.m_20280_((Entity)this.nearestPlayer))) continue;
                this.nearestPlayer = player;
            }
        } else {
            this.nearestPlayer = null;
        }
    }

    private void copyPlayerArmor() {
        if (this.nearestPlayer != null) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack playerArmor = this.nearestPlayer.m_6844_(slot);
                this.m_8061_(slot, playerArmor.m_41777_());
                this.m_21409_(slot, 0.0f);
            }
        } else {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                this.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        this.attackAnimationTick = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        return super.m_7327_(entity);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.m_7822_(id);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    private void playSpawnEffects(ServerLevel level, Vec3 position) {
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        level.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_12049_, SoundSource.HOSTILE, 1.0f, 1.2f);
        for (i = 0; i < 30; ++i) {
            offsetX = (level.m_213780_().m_188500_() - 0.5) * 2.0;
            offsetY = level.m_213780_().m_188500_() * 2.0;
            offsetZ = (level.m_213780_().m_188500_() - 0.5) * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 15; ++i) {
            offsetX = (level.m_213780_().m_188500_() - 0.5) * 1.5;
            offsetY = level.m_213780_().m_188500_() * 1.5;
            offsetZ = (level.m_213780_().m_188500_() - 0.5) * 1.5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnAroundPlayers(ServerLevel level) {
        if (!level.m_46461_()) {
            ArrayList players = new ArrayList(level.m_6907_());
            Collections.shuffle(players);
            for (Player player : players) {
                if (!((double)level.m_213780_().m_188501_() < 0.1) || EvilReflectionEntity.isEvilReflectionNearPlayer(level, player)) continue;
                Vec3 spawnPos = EvilReflectionEntity.getRandomSpawnPositionAroundPlayer(player, level.m_213780_());
                EvilReflectionEntity evilReflection = (EvilReflectionEntity)((EntityType)EvilReflectionsMod.EVIL_REFLECTION.get()).m_20615_((Level)level);
                if (evilReflection == null) continue;
                evilReflection.m_6027_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
                if (!level.m_45786_((Entity)evilReflection)) continue;
                level.m_7967_((Entity)evilReflection);
                evilReflection.initializeForManualSpawn(level);
                evilReflection.playSpawnEffects(level, spawnPos);
                evilReflection.hasPlayedSpawnEffects = true;
                if (level.m_6907_().size() != 1) continue;
                return;
            }
        }
    }

    private static boolean isEvilReflectionNearPlayer(ServerLevel level, Player player) {
        AABB searchArea = player.m_20191_().m_82400_(32.0);
        List nearbyEntities = level.m_45976_(EvilReflectionEntity.class, searchArea);
        return !nearbyEntities.isEmpty();
    }

    private static Vec3 getRandomSpawnPositionAroundPlayer(Player player, RandomSource random) {
        double angle = random.m_188500_() * 2.0 * Math.PI;
        double distance = random.m_188500_() * 5.0;
        double x = player.m_20185_() + Math.cos(angle) * distance;
        double z = player.m_20189_() + Math.sin(angle) * distance;
        double y = player.m_20186_();
        return new Vec3(x, y, z);
    }

    public static boolean checkSpawnRules(EntityType<EvilReflectionEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return EvilReflectionSpawnHandler.checkSpawnRules(entityType, level, spawnType, pos, random);
    }

    @Mod.EventBusSubscriber(modid="evil_reflections")
    public static class EvilReflectionSpawnHandler {
        private static final int SPAWN_CHANCE = 100;
        private static final int SPAWN_RANGE = 5;
        private static final int SPAWN_COOLDOWN = 300;
        private static long lastSpawnTime = 0L;
        private static final double SPAWN_CHECK_RADIUS = 32.0;

        @SubscribeEvent
        public static void onWorldTick(TickEvent.LevelTickEvent event) {
            ServerLevel serverLevel;
            long currentTime;
            if (event.phase == TickEvent.Phase.END && !event.level.m_5776_() && (currentTime = (serverLevel = (ServerLevel)event.level).m_46467_()) - lastSpawnTime >= 300L) {
                if (!serverLevel.m_46461_()) {
                    ArrayList players = new ArrayList(serverLevel.m_6907_());
                    Collections.shuffle(players);
                    for (ServerPlayer player : players) {
                        EvilReflectionSpawnHandler.trySpawnEvilReflection(serverLevel, player);
                        if (serverLevel.m_6907_().size() != 1) continue;
                        break;
                    }
                }
                lastSpawnTime = currentTime;
            }
        }

        private static void trySpawnEvilReflection(ServerLevel level, ServerPlayer player) {
            if (!EvilReflectionSpawnHandler.isEvilReflectionNearPlayer(level, (Player)player)) {
                EvilReflectionEntity evilReflection;
                Vec3 spawnPos = EvilReflectionSpawnHandler.getRandomSpawnPositionAroundPlayer(player, level.m_213780_());
                BlockPos blockPos = new BlockPos((int)spawnPos.f_82479_, (int)spawnPos.f_82480_, (int)spawnPos.f_82481_);
                if (EvilReflectionSpawnHandler.canEvilReflectionSpawnAt(level, blockPos) && (evilReflection = (EvilReflectionEntity)((EntityType)EvilReflectionsMod.EVIL_REFLECTION.get()).m_20615_((Level)level)) != null) {
                    evilReflection.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0f, 0.0f);
                    level.m_7967_((Entity)evilReflection);
                    evilReflection.initializeForManualSpawn(level);
                    evilReflection.playSpawnEffects(level, spawnPos);
                    evilReflection.hasPlayedSpawnEffects = true;
                }
            }
        }

        private static boolean isEvilReflectionNearPlayer(ServerLevel level, Player player) {
            AABB searchArea = player.m_20191_().m_82400_(32.0);
            List nearbyEntities = level.m_45976_(EvilReflectionEntity.class, searchArea);
            return !nearbyEntities.isEmpty();
        }

        private static Vec3 getRandomSpawnPositionAroundPlayer(ServerPlayer player, RandomSource random) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double distance = random.m_188500_() * 5.0;
            double x = player.m_20185_() + Math.cos(angle) * distance;
            double z = player.m_20189_() + Math.sin(angle) * distance;
            double y = player.m_20186_();
            return new Vec3(x, y, z);
        }

        private static boolean canEvilReflectionSpawnAt(ServerLevel level, BlockPos pos) {
            return level.m_45772_(((EntityType)EvilReflectionsMod.EVIL_REFLECTION.get()).m_20585_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        }

        public static void registerSpawnHandler() {
            MinecraftForge.EVENT_BUS.register(EvilReflectionSpawnHandler.class);
        }

        public static boolean checkSpawnRules(EntityType<EvilReflectionEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
            if (level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos.m_7495_())) {
                return false;
            }
            return level.m_45772_(entityType.m_20585_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5));
        }
    }
}

