/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.item;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class DarkShieldItem
extends ShieldItem {
    private static final int REGEN_COOLDOWN_TICKS = 50;
    private static final String REGEN_COOLDOWN_KEY = "dark_shield_regen_cooldown";

    public DarkShieldItem() {
        super(new Item.Properties().m_41503_(1389));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_21223_() < player.m_21233_()) {
            if (!this.isOnRegenCooldown(player)) {
                float healAmount = Math.min(6.0f, player.m_21233_() - player.m_21223_());
                player.m_5634_(healAmount);
                int healedEntities = this.healNearbyEntities(world, player, healAmount);
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123755_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 20, 0.1, 0.1, 0.1, 0.1);
                }
                int damageAmount = 3 + 2 * healedEntities;
                itemstack.m_41622_(damageAmount, (LivingEntity)player, p -> p.m_21190_(hand));
                this.setRegenCooldown(player);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.evil_reflections.cant_use_dark_shield"), true);
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    private boolean isOnRegenCooldown(Player player) {
        return player.getPersistentData().m_128451_(REGEN_COOLDOWN_KEY) > 0;
    }

    private void setRegenCooldown(Player player) {
        player.getPersistentData().m_128405_(REGEN_COOLDOWN_KEY, 50);
    }

    private int healNearbyEntities(Level world, Player player, float healAmount) {
        List nearbyEntities = world.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(4.0));
        int healedEntities = 0;
        for (LivingEntity entity : nearbyEntities) {
            if (!(entity instanceof TamableAnimal && ((TamableAnimal)entity).m_21824_() && entity.m_21223_() < entity.m_21233_()) && (!(entity instanceof Player) || entity == player || !(entity.m_21223_() < entity.m_21233_()))) continue;
            entity.m_5634_(healAmount);
            ++healedEntities;
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123755_, entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), 20, 0.1, 0.1, 0.1, 0.1);
        }
        return healedEntities;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        int cooldown;
        if (entity instanceof Player && (cooldown = (player = (Player)entity).getPersistentData().m_128451_(REGEN_COOLDOWN_KEY)) > 0) {
            player.getPersistentData().m_128405_(REGEN_COOLDOWN_KEY, cooldown - 1);
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction);
    }

    public static boolean isBlocking(ItemStack stack, Player player) {
        return player.m_6117_() && player.m_21211_() == stack && player.m_21223_() < player.m_21233_();
    }
}

