/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.mcreator.evilreflections.EvilReflectionsMod;
import net.mcreator.evilreflections.effect.MobEffectAnomalousFloat;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class AnomalousFloatSyncPacket {
    private final UUID playerUUID;
    private final boolean isActive;
    private final float rotation;

    public AnomalousFloatSyncPacket(UUID playerUUID, boolean isActive, float rotation) {
        this.playerUUID = playerUUID;
        this.isActive = isActive;
        this.rotation = rotation;
    }

    public static void encode(AnomalousFloatSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.playerUUID);
        buffer.writeBoolean(packet.isActive);
        buffer.writeFloat(packet.rotation);
    }

    public static AnomalousFloatSyncPacket decode(FriendlyByteBuf buffer) {
        return new AnomalousFloatSyncPacket(buffer.m_130259_(), buffer.readBoolean(), buffer.readFloat());
    }

    public static void handle(AnomalousFloatSyncPacket packet, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                MobEffectAnomalousFloat.updatePlayerStateFromPacket(packet.playerUUID, packet.isActive, packet.rotation);
            } else {
                ServerPlayer sender = ctx.getSender();
                if (sender != null) {
                    EvilReflectionsMod.getNetwork().send(PacketDistributor.ALL.noArg(), (Object)packet);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

