/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.evilreflections.network;

import java.util.function.Supplier;
import net.mcreator.evilreflections.entity.DarkLightningBoltEntity;
import net.mcreator.evilreflections.item.DarkFragmentItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class SpawnDarkLightningMessage {
    private final double x;
    private final double y;
    private final double z;

    public SpawnDarkLightningMessage(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void encode(SpawnDarkLightningMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.x);
        buffer.writeDouble(message.y);
        buffer.writeDouble(message.z);
    }

    public static SpawnDarkLightningMessage decode(FriendlyByteBuf buffer) {
        return new SpawnDarkLightningMessage(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static void handle(SpawnDarkLightningMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null && context.getSender().m_9236_() instanceof ServerLevel) {
                ServerLevel level = context.getSender().m_9236_();
                if (DarkFragmentItem.consumeDarkFragments((Player)context.getSender())) {
                    DarkLightningBoltEntity.spawnDarkLightningAroundPlayer((Level)level, message.x, message.y, message.z);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

