/*
 * Decompiled with CFR 0.152.
 */
package com.darsoon.luckycobble.block.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class ItemModBlock
extends Block {
    private static final Map<BlockPos, Boolean> activatedBlocks = new HashMap<BlockPos, Boolean>();
    private static final TagKey<Item> LUCKY_DROPS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"luckycobble:luckydrops"));
    private static final Random RANDOM = new Random();

    public ItemModBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide && hand == InteractionHand.MAIN_HAND && !activatedBlocks.containsKey(pos)) {
            this.dropRandomItemFromTag((ServerLevel)level, pos);
            activatedBlocks.put(pos, true);
            level.destroyBlock(pos, false);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (state.getBlock() != newState.getBlock()) {
                if (!activatedBlocks.containsKey(pos)) {
                    this.dropRandomItemFromTag(serverLevel, pos);
                }
                activatedBlocks.remove(pos);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private void dropRandomItemFromTag(ServerLevel level, BlockPos pos) {
        boolean isMegaShowdownLoaded = ModList.get().isLoaded("mega_showdown");
        List<Item> items = StreamSupport.stream(BuiltInRegistries.ITEM.getTagOrEmpty(LUCKY_DROPS_TAG).spliterator(), false).map(Holder::value).filter(item -> {
            if (!isMegaShowdownLoaded) {
                return !BuiltInRegistries.ITEM.getKey(item).getNamespace().equals("mega_showdown");
            }
            return true;
        }).toList();
        if (!items.isEmpty()) {
            Item selected = items.get(RANDOM.nextInt(items.size()));
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)selected));
            level.addFreshEntity((Entity)itemEntity);
        }
    }
}

