/*
 * Decompiled with CFR 0.152.
 */
package com.darsoon.luckycobble.block.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class LegendaryBlock
extends Block {
    private static final String[] legendarios = new String[]{"Articuno", "Zapdos", "Moltres", "Mewtwo", "Raikou", "Entei", "Suicune", "Lugia", "Ho-Oh", "Regirock", "Regice", "Registeel", "Latias", "Latios", "Kyogre", "Groudon", "Rayquaza", "Uxie", "Mesprit", "Azelf", "Dialga", "Palkia", "Heatran", "Regigigas", "Giratina", "Cresselia", "Cobalion", "Terrakion", "Virizion", "Tornadus", "Thundurus", "Reshiram", "Zekrom", "Landorus", "Kyurem", "Xerneas", "Yveltal", "Zygarde", "TypeNull", "Silvally", "TapuKoko", "TapuLele", "TapuBulu", "TapuFini", "Cosmog", "Cosmoem", "Solgaleo", "Lunala", "Necrozma", "Zacian", "Zamazenta", "Eternatus", "Kubfu", "Urshifu", "Regieleki", "Regidrago", "Glastrier", "Spectrier", "Calyrex", "Enamorus", "WoChien", "ChienPao", "TingLu", "ChiYu", "Koraidon", "Miraidon", "Okidogi", "Munkidori", "Fezandipiti", "Ogerpon", "Terapagos", "Victini", "Keldeo", "Meloetta", "Genesect", "Diancie", "Hoopa", "Volcanion", "Magearna", "Marshadow", "Zeraora", "Meltan", "Melmetal", "Zarude", "Pecharunt", "Mew", "Celebi", "Jirachi", "Deoxys", "Phione", "Manaphy", "Darkrai", "Shaymin", "Arceus"};
    private static final Map<BlockPos, Boolean> hasSpawned = new HashMap<BlockPos, Boolean>();

    public LegendaryBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide && hand == InteractionHand.MAIN_HAND && !hasSpawned.getOrDefault(pos, false).booleanValue()) {
            this.spawnPokemon((ServerLevel)level, pos);
            hasSpawned.put(pos, true);
            level.destroyBlock(pos, false);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (state.getBlock() != newState.getBlock() && !hasSpawned.getOrDefault(pos, false).booleanValue()) {
                this.spawnPokemon(serverLevel, pos);
                hasSpawned.put(pos, true);
            }
        }
        if (state.getBlock() != newState.getBlock()) {
            hasSpawned.remove(pos);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private void spawnPokemon(ServerLevel level, BlockPos pos) {
        int levelValue = new Random().nextInt(100) + 1;
        String pokemon = legendarios[new Random().nextInt(legendarios.length)];
        String command = "/pokespawn " + pokemon + " lvl=" + levelValue;
        CommandSourceStack source = new CommandSourceStack((CommandSource)level.getServer(), pos.getCenter(), new Vec2(0.0f, 0.0f), level, 4, "PokeSpawner", (Component)Component.literal((String)"PokeSpawner"), level.getServer(), null);
        level.getServer().getCommands().performPrefixedCommand(source, command);
    }
}

