/*
 * Decompiled with CFR 0.152.
 */
package com.darsoon.luckycobble.block.custom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class LuckyCobbleMegaBlock
extends Block {
    private static final WeakHashMap<Level, Set<BlockPos>> recentlyUsed = new WeakHashMap();
    private static final Map<String, String[]> POKEMON_MEGA_INFO = new HashMap<String, String[]>();

    public LuckyCobbleMegaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide && hand == InteractionHand.MAIN_HAND && !recentlyUsed.computeIfAbsent(level, w -> Collections.newSetFromMap(new WeakHashMap())).contains(pos)) {
            this.spawnMegaPokemon(level, pos);
            recentlyUsed.computeIfAbsent(level, w -> Collections.newSetFromMap(new WeakHashMap())).add(pos);
            level.destroyBlock(pos, false);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide && level instanceof ServerLevel) {
            Set<BlockPos> used;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!(state.getBlock() == newState.getBlock() || (used = recentlyUsed.get(serverLevel)) != null && used.remove(pos))) {
                this.spawnMegaPokemon((Level)serverLevel, pos);
            }
        }
        if (state.getBlock() != newState.getBlock()) {
            recentlyUsed.computeIfAbsent(level, w -> Collections.newSetFromMap(new WeakHashMap())).remove(pos);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private void spawnMegaPokemon(Level level, BlockPos pos) {
        boolean hasXYForms;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Random rand = new Random();
        int levelValue = rand.nextInt(100) + 1;
        Object[] pokemonNames = POKEMON_MEGA_INFO.keySet().toArray();
        String pokemon = (String)pokemonNames[rand.nextInt(pokemonNames.length)];
        String[] megaInfo = POKEMON_MEGA_INFO.get(pokemon);
        String selectedMegaStone = null;
        Object megaEvolutionSuffix = "";
        boolean bl = hasXYForms = megaInfo.length > 0 && megaInfo[megaInfo.length - 1].equals("x_or_y");
        if (pokemon.equals("Rayquaza")) {
            selectedMegaStone = "rayquaza";
            megaEvolutionSuffix = "";
        } else if (hasXYForms) {
            String chosenForm = rand.nextBoolean() ? "x" : "y";
            selectedMegaStone = chosenForm.equals("x") ? megaInfo[0] : megaInfo[1];
            megaEvolutionSuffix = "_" + chosenForm;
        } else {
            selectedMegaStone = megaInfo[0];
        }
        String command = pokemon.equals("Rayquaza") ? "/pokespawn " + pokemon + " lvl=" + levelValue + " mega_evolution=mega" : "/pokespawn " + pokemon + " lvl=" + levelValue + " mega_evolution=mega" + (String)megaEvolutionSuffix + " held_item=mega_showdown:" + selectedMegaStone;
        CommandSourceStack source = new CommandSourceStack((CommandSource)serverLevel.getServer(), pos.getCenter(), new Vec2(0.0f, 0.0f), serverLevel, 4, "PokeSpawner", (Component)Component.literal((String)"PokeSpawner"), serverLevel.getServer(), null);
        serverLevel.getServer().getCommands().performPrefixedCommand(source, command);
    }

    static {
        POKEMON_MEGA_INFO.put("Venusaur", new String[]{"venusaurite"});
        POKEMON_MEGA_INFO.put("Charizard", new String[]{"charizardite_x", "charizardite_y", "x_or_y"});
        POKEMON_MEGA_INFO.put("Blastoise", new String[]{"blastoisinite"});
        POKEMON_MEGA_INFO.put("Alakazam", new String[]{"alakazite"});
        POKEMON_MEGA_INFO.put("Gengar", new String[]{"gengarite"});
        POKEMON_MEGA_INFO.put("Kangaskhan", new String[]{"kangaskhanite"});
        POKEMON_MEGA_INFO.put("Pinsir", new String[]{"pinsirite"});
        POKEMON_MEGA_INFO.put("Gyarados", new String[]{"gyaradosite"});
        POKEMON_MEGA_INFO.put("Aerodactyl", new String[]{"aerodactylite"});
        POKEMON_MEGA_INFO.put("Mewtwo", new String[]{"mewtwonite_x", "mewtwonite_y", "x_or_y"});
        POKEMON_MEGA_INFO.put("Ampharos", new String[]{"ampharosite"});
        POKEMON_MEGA_INFO.put("Scizor", new String[]{"scizorite"});
        POKEMON_MEGA_INFO.put("Heracross", new String[]{"heracronite"});
        POKEMON_MEGA_INFO.put("Houndoom", new String[]{"houndoominite"});
        POKEMON_MEGA_INFO.put("Tyranitar", new String[]{"tyranitarite"});
        POKEMON_MEGA_INFO.put("Blaziken", new String[]{"blazikenite"});
        POKEMON_MEGA_INFO.put("Gardevoir", new String[]{"gardevoirite"});
        POKEMON_MEGA_INFO.put("Mawile", new String[]{"mawilite"});
        POKEMON_MEGA_INFO.put("Aggron", new String[]{"aggronite"});
        POKEMON_MEGA_INFO.put("Medicham", new String[]{"medichamite"});
        POKEMON_MEGA_INFO.put("Manectric", new String[]{"manectite"});
        POKEMON_MEGA_INFO.put("Banette", new String[]{"banettite"});
        POKEMON_MEGA_INFO.put("Absol", new String[]{"absolite"});
        POKEMON_MEGA_INFO.put("Garchomp", new String[]{"garchompite"});
        POKEMON_MEGA_INFO.put("Lucario", new String[]{"lucarionite"});
        POKEMON_MEGA_INFO.put("Abomasnow", new String[]{"abomasite"});
        POKEMON_MEGA_INFO.put("Beedrill", new String[]{"beedrillite"});
        POKEMON_MEGA_INFO.put("Pidgeot", new String[]{"pidgeotite"});
        POKEMON_MEGA_INFO.put("Slowbro", new String[]{"slowbronite"});
        POKEMON_MEGA_INFO.put("Steelix", new String[]{"steelixite"});
        POKEMON_MEGA_INFO.put("Sceptile", new String[]{"sceptilite"});
        POKEMON_MEGA_INFO.put("Swampert", new String[]{"swampertite"});
        POKEMON_MEGA_INFO.put("Sableye", new String[]{"sablenite"});
        POKEMON_MEGA_INFO.put("Sharpedo", new String[]{"sharpedonite"});
        POKEMON_MEGA_INFO.put("Camerupt", new String[]{"cameruptite"});
        POKEMON_MEGA_INFO.put("Altaria", new String[]{"altarianite"});
        POKEMON_MEGA_INFO.put("Glalie", new String[]{"glalitite"});
        POKEMON_MEGA_INFO.put("Salamence", new String[]{"salamencite"});
        POKEMON_MEGA_INFO.put("Metagross", new String[]{"metagrossite"});
        POKEMON_MEGA_INFO.put("Latias", new String[]{"latiasite"});
        POKEMON_MEGA_INFO.put("Latios", new String[]{"latiosite"});
        POKEMON_MEGA_INFO.put("Rayquaza", new String[]{"rayquaza"});
        POKEMON_MEGA_INFO.put("Lopunny", new String[]{"lopunnite"});
        POKEMON_MEGA_INFO.put("Gallade", new String[]{"galladite"});
        POKEMON_MEGA_INFO.put("Audino", new String[]{"audinite"});
        POKEMON_MEGA_INFO.put("Diancie", new String[]{"diancite"});
        POKEMON_MEGA_INFO.put("Groudon", new String[]{"redorb"});
        POKEMON_MEGA_INFO.put("Kyogre", new String[]{"blueorb"});
    }
}

