/*
 * Decompiled with CFR 0.152.
 */
package com.darsoon.luckycobble.blocks.custom;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class LuckyCobbleItem
extends class_2248 {
    private static final WeakHashMap<class_1937, Set<class_2338>> recentlyUsed = new WeakHashMap();
    private static final class_6862<class_1792> DROPPABLE_ITEMS_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"luckycobble", (String)"lucky_drops"));

    public LuckyCobbleItem(class_4970.class_2251 settings) {
        super(settings);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236) {
            this.dropRandomItem((class_3218)world, pos);
            recentlyUsed.computeIfAbsent(world, w -> Collections.newSetFromMap(new WeakHashMap())).add(pos);
            world.method_22352(pos, false);
        }
        return class_1269.field_5812;
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        class_1937 serverWorld;
        Set<class_2338> used;
        if (!(world.method_8608() || (used = recentlyUsed.get(serverWorld = (class_1937)world)) != null && used.remove(pos))) {
            this.dropRandomItem((class_3218)serverWorld, pos);
        }
        super.method_9585(world, pos, state);
    }

    private void dropRandomItem(class_3218 world, class_2338 pos) {
        boolean isMegaShowdownLoaded = FabricLoader.getInstance().isModLoaded("mega_showdown");
        List items = class_7923.field_41178.method_10220().filter(item -> class_7923.field_41178.method_47983(item).method_40220(DROPPABLE_ITEMS_TAG)).filter(item -> {
            if (!isMegaShowdownLoaded) {
                return !class_7923.field_41178.method_10221(item).method_12836().equals("mega_showdown");
            }
            return true;
        }).collect(Collectors.toList());
        if (items.isEmpty()) {
            System.out.println("[LuckyCobble] No items found in tag 'lucky_drops' after filtering. Using fallback.");
            class_1799 fallback = new class_1799((class_1935)class_1802.field_20412);
            class_1542 fallbackEntity = new class_1542((class_1937)world, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, fallback);
            world.method_8649((class_1297)fallbackEntity);
            return;
        }
        System.out.println("[LuckyCobble] Found items in tag (after filtering):");
        for (class_1792 item2 : items) {
            System.out.println(" - " + String.valueOf(class_7923.field_41178.method_10221((Object)item2)));
        }
        class_1792 randomItem = (class_1792)items.get(new Random().nextInt(items.size()));
        class_1799 stack = new class_1799((class_1935)randomItem);
        class_1542 entity = new class_1542((class_1937)world, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, stack);
        System.out.println("[LuckyCobble] Dropped item: " + String.valueOf(class_7923.field_41178.method_10221((Object)randomItem)));
        world.method_8649((class_1297)entity);
    }
}

