/*
 * Decompiled with CFR 0.152.
 */
package org.lolip_p.blockentitydistance.client;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHolder {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("BlockEntityRenderDistanceConfig.json");
    public static final Map<String, Double> DISTANCE_CONFIG = new HashMap<String, Double>();
    public static boolean isEnabled = true;
    public static boolean UseGlobalValue = false;
    public static int GlobalValue = 40;
    public static int CheckIntervalTicks = 20;

    public static void loadConfig() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            ConfigHolder.saveConfig();
            return;
        }
        try {
            String json = Files.readString(CONFIG_PATH);
            JsonObject config = JsonParser.parseString((String)json).getAsJsonObject();
            if (config.has("isEnabled")) {
                isEnabled = config.get("isEnabled").getAsBoolean();
            }
            if (config.has("UseGlobalValue")) {
                UseGlobalValue = config.get("UseGlobalValue").getAsBoolean();
            }
            if (config.has("GlobalValue")) {
                GlobalValue = config.get("GlobalValue").getAsInt();
            }
            if (config.has("CheckIntervalTicks")) {
                CheckIntervalTicks = config.get("CheckIntervalTicks").getAsInt();
            }
            if (config.has("distances")) {
                JsonObject distances = config.getAsJsonObject("distances");
                for (Map.Entry entry : distances.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    double value = ((JsonElement)entry.getValue()).getAsDouble();
                    DISTANCE_CONFIG.put((String)entry.getKey(), value);
                }
            }
        }
        catch (JsonParseException | IOException e) {
            System.err.println("Failed to load config: " + e.getMessage());
            ConfigHolder.saveConfig();
        }
    }

    public static void saveConfig() {
        try {
            JsonObject config = new JsonObject();
            config.addProperty("isEnabled", Boolean.valueOf(isEnabled));
            config.addProperty("UseGlobalValue", Boolean.valueOf(UseGlobalValue));
            config.addProperty("GlobalValue", (Number)GlobalValue);
            config.addProperty("CheckIntervalTicks", (Number)CheckIntervalTicks);
            JsonObject distances = new JsonObject();
            DISTANCE_CONFIG.forEach((arg_0, arg_1) -> ((JsonObject)distances).addProperty(arg_0, arg_1));
            config.add("distances", (JsonElement)distances);
            Files.writeString(CONFIG_PATH, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)config), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    static {
        DISTANCE_CONFIG.put("minecraft:chest", 48.0);
        DISTANCE_CONFIG.put("minecraft:sign", 32.0);
        DISTANCE_CONFIG.put("minecraft:hanging_sign", 32.0);
        DISTANCE_CONFIG.put("minecraft:banner", 32.0);
        DISTANCE_CONFIG.put("minecraft:trapped_chest", 48.0);
        DISTANCE_CONFIG.put("minecraft:shulker_box", 48.0);
        DISTANCE_CONFIG.put("minecraft:campfire", 24.0);
        DISTANCE_CONFIG.put("minecraft:lectern", 24.0);
        DISTANCE_CONFIG.put("minecraft:beacon", 64.0);
        DISTANCE_CONFIG.put("minecraft:mob_spawner", 32.0);
        DISTANCE_CONFIG.put("minecraft:piston", 24.0);
        DISTANCE_CONFIG.put("minecraft:enchanting_table", 24.0);
        DISTANCE_CONFIG.put("minecraft:end_portal", 32.0);
        DISTANCE_CONFIG.put("minecraft:ender_chest", 48.0);
        DISTANCE_CONFIG.put("minecraft:skull", 24.0);
        DISTANCE_CONFIG.put("minecraft:end_gateway", 32.0);
        DISTANCE_CONFIG.put("minecraft:decorated_pot", 24.0);
        DISTANCE_CONFIG.put("minecraft:bed", 32.0);
        DISTANCE_CONFIG.put("minecraft:conduit", 24.0);
        DISTANCE_CONFIG.put("minecraft:bell", 32.0);
        ConfigHolder.loadConfig();
    }
}

