/*
 * Decompiled with CFR 0.152.
 */
package net.mobilelize.netprodis.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.mobilelize.netprodis.NetprodisLogger;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_DIR = new File(Minecraft.getInstance().gameDirectory, "config/netprodis");
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "netprodis.json");
    public static ConfigData configData = new ConfigData();

    public static void loadConfig() {
        try {
            if (!CONFIG_FILE.exists()) {
                ConfigManager.saveDefaultConfig();
            }
            try (FileReader reader = new FileReader(CONFIG_FILE, StandardCharsets.UTF_8);){
                configData = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            }
        }
        catch (Exception e) {
            NetprodisLogger.LOGGER.error("Failed to load config: {}", (Object)e.getMessage());
        }
    }

    public static void saveConfig() {
        try {
            if (!CONFIG_DIR.exists()) {
                CONFIG_DIR.mkdirs();
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
                GSON.toJson((Object)configData, (Appendable)writer);
            }
        }
        catch (Exception e) {
            NetprodisLogger.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    private static void saveDefaultConfig() {
        ConfigManager.saveConfig();
    }

    public static class ConfigData {
        public boolean modEnabled = true;
        public boolean showLogs = true;
    }
}

