/*
 * Decompiled with CFR 0.152.
 */
package com.prikolz.loggui.screens;

import com.prikolz.loggui.Config;
import com.prikolz.loggui.screens.LogScreen;
import com.prikolz.loggui.util.ColorUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_7529;
import net.minecraft.class_7842;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class LogScreenSettingsScreen
extends class_437 {
    private static final class_2561 TITLE = class_2561.method_43471((String)"loggui.settings.title");
    private static final class_2561 TEXT_SHADOW = class_2561.method_43471((String)"loggui.settings.text_shadow");
    private static final class_2561 COLOR_TITLE = class_2561.method_43471((String)"loggui.settings.color_title");
    private static final class_2561 RED = class_2561.method_43471((String)"loggui.settings.red");
    private static final class_2561 GREEN = class_2561.method_43471((String)"loggui.settings.green");
    private static final class_2561 BLUE = class_2561.method_43471((String)"loggui.settings.blue");
    private static final class_2561 INFO_TITLE = class_2561.method_43471((String)"loggui.settings.info_title");
    private static final class_2561 WARN_TITLE = class_2561.method_43471((String)"loggui.settings.warn_title");
    private static final class_2561 ERR_TITLE = class_2561.method_43471((String)"loggui.settings.err_title");
    private final LogScreen parent;
    public class_4185 doneButton;
    public class_4286 useShadow;
    public IntSlider redSlider;
    public IntSlider greenSlider;
    public IntSlider blueSlider;
    public MultiLineEditBoxHolder preview;
    public EditBoxHolder infoPrefix;
    public EditBoxHolder warnPrefix;
    public EditBoxHolder errPrefix;

    protected LogScreenSettingsScreen(@NotNull LogScreen parent) {
        super(TITLE);
        this.parent = parent;
    }

    private void updatePreview() {
        this.preview.hold = class_7529.method_71507().method_71508(120).method_71512(25).method_71514(Config.LOGGER_TEXT_COLOR).method_71511(Config.LOGGER_TEXT_SHADOW).method_71509(class_310.method_1551().field_39924, 300, 200, (class_2561)class_2561.method_43473());
        this.preview.hold.method_44400(Config.INFO_PREFIX + "[00:00:00] [Example/INFO]\u00a7r (Minecraft) Example output.\n" + Config.WARN_PREFIX + "[00:00:00] [Example/WARN]\u00a7r (Minecraft) Example warn.\n" + Config.ERR_PREFIX + "[00:00:00] [Example/ERROR]\u00a7r (Minecraft) Example error.");
    }

    protected void method_25426() {
        this.doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, b -> class_310.method_1551().method_1507((class_437)this.parent)).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 40, 200, 20).method_46431();
        this.useShadow = class_4286.method_54787((class_2561)TEXT_SHADOW, (class_327)class_310.method_1551().field_39924).method_54791((ch, bl) -> {
            Config.LOGGER_TEXT_SHADOW = bl;
            this.updatePreview();
            Config.save();
        }).method_54794(Config.LOGGER_TEXT_SHADOW).method_54789(5, 20).method_54788();
        this.method_37063((class_364)new class_7842(5, 45, 100, 20, COLOR_TITLE, this.field_22787.field_39924).method_48596());
        int sliderW = 100;
        int sliderH = 20;
        int sliderY = 60;
        int sliderOffset = 5;
        int[] rgba = ColorUtil.toRGBA(Config.LOGGER_TEXT_COLOR);
        this.redSlider = new IntSlider(5, 60, 100, 20, 0, 255, rgba[0], (s, i) -> {
            s.method_25355((class_2561)RED.method_27661().method_27693(": " + i));
            this.changeTextColor();
        });
        this.redSlider.method_25355((class_2561)RED.method_27661().method_27693(": " + this.redSlider.intValue()));
        this.greenSlider = new IntSlider(5, 85, 100, 20, 0, 255, rgba[1], (s, i) -> {
            s.method_25355((class_2561)GREEN.method_27661().method_27693(": " + i));
            this.changeTextColor();
        });
        this.greenSlider.method_25355((class_2561)GREEN.method_27661().method_27693(": " + this.greenSlider.intValue()));
        this.blueSlider = new IntSlider(5, 110, 100, 20, 0, 255, rgba[2], (s, i) -> {
            s.method_25355((class_2561)BLUE.method_27661().method_27693(": " + i));
            this.changeTextColor();
        });
        this.blueSlider.method_25355((class_2561)BLUE.method_27661().method_27693(": " + this.blueSlider.intValue()));
        int prefixY = this.blueSlider.method_46427() + 22;
        this.method_37063((class_364)new class_7842(5, prefixY, 100, 20, INFO_TITLE, this.field_22787.field_39924).method_48596());
        this.infoPrefix = new EditBoxHolder(5, prefixY + 20, 100, 20);
        this.infoPrefix.hold.method_1852(this.prefixFormat(Config.INFO_PREFIX));
        this.infoPrefix.hold.method_1880(128);
        this.infoPrefix.change = e -> {
            Config.INFO_PREFIX = this.prefixConvert(e.hold.method_1882());
            this.updatePreview();
            Config.save();
        };
        this.method_37063((class_364)new class_7842(5, prefixY + 40, 100, 20, WARN_TITLE, this.field_22787.field_39924).method_48596());
        this.warnPrefix = new EditBoxHolder(5, prefixY + 60, 100, 20);
        this.warnPrefix.hold.method_1852(this.prefixFormat(Config.WARN_PREFIX));
        this.warnPrefix.hold.method_1880(128);
        this.warnPrefix.change = e -> {
            Config.WARN_PREFIX = this.prefixConvert(e.hold.method_1882());
            this.updatePreview();
            Config.save();
        };
        this.method_37063((class_364)new class_7842(5, prefixY + 80, 100, 20, ERR_TITLE, this.field_22787.field_39924).method_48596());
        this.errPrefix = new EditBoxHolder(5, prefixY + 100, 100, 20);
        this.errPrefix.hold.method_1852(this.prefixFormat(Config.ERR_PREFIX));
        this.errPrefix.hold.method_1880(128);
        this.errPrefix.change = e -> {
            Config.ERR_PREFIX = this.prefixConvert(e.hold.method_1882());
            this.updatePreview();
            Config.save();
        };
        this.preview = new MultiLineEditBoxHolder(new class_7529.class_11383().method_71509(class_310.method_1551().field_39924, 1, 1, (class_2561)class_2561.method_43473()));
        this.updatePreview();
        this.method_37063((class_364)new class_7842(this.field_22789 / 2 - 100, 5, 200, 20, TITLE, this.field_22787.field_39924));
        this.method_37063((class_364)this.doneButton);
        this.method_37063((class_364)this.useShadow);
        this.method_37063((class_364)this.redSlider);
        this.method_37063((class_364)this.greenSlider);
        this.method_37063((class_364)this.blueSlider);
        this.method_37063((class_364)this.warnPrefix);
        this.method_37063((class_364)this.errPrefix);
        this.method_37063((class_364)this.infoPrefix);
        this.method_37063((class_364)this.preview);
    }

    private String prefixFormat(String prefix) {
        return prefix.replaceAll("\u00a7", "&").replaceAll("\n", "\\\\n");
    }

    private String prefixConvert(String prefix) {
        return prefix.replaceAll("&", "\u00a7").replaceAll("\\\\n", "\n");
    }

    private void changeTextColor() {
        Config.LOGGER_TEXT_COLOR = ColorUtil.fromRGBA(this.redSlider.intValue(), this.greenSlider.intValue(), this.blueSlider.intValue(), 255);
        this.updatePreview();
        Config.save();
    }

    public boolean method_25421() {
        return this.parent.method_25421();
    }

    @Environment(value=EnvType.CLIENT)
    public static class MultiLineEditBoxHolder
    extends class_339 {
        public class_7529 hold;

        public MultiLineEditBoxHolder(class_7529 hold) {
            super(hold.method_46426(), hold.method_46427(), hold.method_25368(), hold.method_25364(), (class_2561)class_2561.method_43473());
            this.hold = hold;
        }

        protected void method_48579(@NotNull class_332 guiGraphics, int i, int j, float f) {
            this.hold.method_48579(guiGraphics, i, j, f);
        }

        protected void method_47399(@NotNull class_6382 narrationElementOutput) {
            this.hold.method_47399(narrationElementOutput);
        }

        public void method_25357(double d, double e) {
            this.hold.method_25357(d, e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class IntSlider
    extends class_357 {
        private final OnChange onChange;
        private final int min;
        private final int max;

        public IntSlider(int x, int y, int w, int h, int min, int max, int instance, @NotNull OnChange onChange) {
            super(x, y, w, h, (class_2561)class_2561.method_43473(), (double)instance / (double)Math.abs(max - min));
            this.onChange = onChange;
            this.min = min;
            this.max = max;
        }

        protected void method_25346() {
        }

        protected void method_25344() {
            this.onChange.onChange(this, this.intValue());
        }

        public int intValue() {
            return (int)(this.field_22753 * (double)Math.abs(this.max - this.min) - (double)this.min);
        }

        @Environment(value=EnvType.CLIENT)
        public static interface OnChange {
            public void onChange(IntSlider var1, int var2);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class EditBoxHolder
    extends class_339 {
        public class_342 hold;
        public OnChange change;

        public EditBoxHolder(int x, int y, int w, int h) {
            super(x, y, w, h, (class_2561)class_2561.method_43473());
            this.hold = new class_342(class_310.method_1551().field_39924, x, y, w, h, (class_2561)class_2561.method_43473());
        }

        protected void method_48579(@NotNull class_332 guiGraphics, int i, int j, float f) {
            this.hold.method_48579(guiGraphics, i, j, f);
        }

        protected void method_47399(@NotNull class_6382 narrationElementOutput) {
            this.hold.method_47399(narrationElementOutput);
        }

        public void method_25348(double d, double e) {
            this.hold.method_25348(d, e);
        }

        public void method_25357(double d, double e) {
            this.hold.method_25357(d, e);
        }

        public boolean method_25404(int i, int j, int k) {
            boolean result = this.hold.method_25404(i, j, k);
            if (result && this.change != null) {
                this.change.onChange(this);
            }
            return result;
        }

        public boolean method_25400(char c, int i) {
            boolean result = this.hold.method_25400(c, i);
            if (result && this.change != null) {
                this.change.onChange(this);
            }
            return result;
        }

        public void method_25365(boolean bl) {
            this.hold.method_25365(bl);
        }

        @Environment(value=EnvType.CLIENT)
        public static interface OnChange {
            public void onChange(EditBoxHolder var1);
        }
    }
}

