/*
 * Decompiled with CFR 0.152.
 */
package com.prikolz.loggui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.prikolz.loggui.LogGUI;
import com.prikolz.loggui.LogGUIClient;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Config {
    public static boolean LOGGER_SPLIT_ON_TIMES = false;
    public static boolean LOGGER_USE_COLORS = true;
    public static int LOGGER_TEXT_COLOR = -1;
    public static boolean LOGGER_TEXT_SHADOW = false;
    public static int KEY_BIND = 96;

    public static void read() {
        File config = new File(LogGUIClient.rootFolder, "config/loggui/config.json");
        if (!config.isFile()) {
            LogGUI.LOGGER.info("Created default file settings");
            Config.save();
            return;
        }
        try (FileReader reader = new FileReader(config);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            KEY_BIND = json.get("settings_key_bind").getAsInt();
            LOGGER_TEXT_SHADOW = json.get("logger_text_shadow").getAsBoolean();
            LOGGER_TEXT_COLOR = json.get("logger_text_color").getAsInt();
            LOGGER_USE_COLORS = json.get("settings_use_colors").getAsBoolean();
            LOGGER_SPLIT_ON_TIMES = json.get("settings_split_messages").getAsBoolean();
        }
        catch (Throwable t) {
            LogGUI.LOGGER.error("Fail to read settings file: " + t.getMessage());
        }
    }

    public static void save() {
        try {
            new File(LogGUIClient.rootFolder, "config/loggui/").mkdirs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File config = new File(LogGUIClient.rootFolder, "config/loggui/config.json");
        JsonObject json = new JsonObject();
        json.add("logger_text_color", (JsonElement)new JsonPrimitive((Number)LOGGER_TEXT_COLOR));
        json.add("logger_text_shadow", (JsonElement)new JsonPrimitive(Boolean.valueOf(LOGGER_TEXT_SHADOW)));
        json.add("settings_key_bind", (JsonElement)new JsonPrimitive((Number)KEY_BIND));
        json.add("settings_use_colors", (JsonElement)new JsonPrimitive(Boolean.valueOf(LOGGER_USE_COLORS)));
        json.add("settings_split_messages", (JsonElement)new JsonPrimitive(Boolean.valueOf(LOGGER_SPLIT_ON_TIMES)));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(config);){
            gson.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (Throwable t) {
            LogGUI.LOGGER.error("Fail to save settings: " + t.getMessage());
        }
    }
}

