/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.growableores.conifg;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skniro.growableores.conifg.Config;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;

public class Configuration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Class clazz;
    private final String modId;

    public Configuration(Class clazz, String modId) {
        this.clazz = clazz;
        this.modId = modId;
        this.setup();
    }

    private void setup() {
        File[] configFiles;
        File configDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), this.modId);
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if ((configFiles = configDir.listFiles()) != null) {
            HashMap<String, JsonObject> configs = new HashMap<String, JsonObject>();
            for (File file : configFiles) {
                String name = file.getName().substring(0, file.getName().length() - ".json".length());
                try {
                    String fileContents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                    JsonObject jsonObject = (JsonObject)GSON.fromJson(fileContents, JsonObject.class);
                    configs.put(name, jsonObject);
                }
                catch (IOException e) {
                    System.err.println("Failed to read config file: " + file.getAbsolutePath());
                    e.printStackTrace();
                }
            }
            this.readFromJson(configs);
        }
        for (Map.Entry<String, JsonObject> entry : this.toJson().entrySet()) {
            File configFile = new File(configDir, entry.getKey() + ".json");
            String jsonStr = GSON.toJson((JsonElement)entry.getValue());
            try {
                FileUtils.writeStringToFile((File)configFile, (String)jsonStr, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write config file: " + configFile.getAbsolutePath(), e);
            }
        }
    }

    private HashMap<Field, Config> getConfigFields() {
        HashMap<Field, Config> fieldMap = new HashMap<Field, Config>();
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Config.class)) continue;
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new UnsupportedOperationException("Config field must be static");
            }
            Config annotation = field.getAnnotation(Config.class);
            fieldMap.put(field, annotation);
        }
        return fieldMap;
    }

    public HashMap<String, JsonObject> toJson() {
        HashMap<Field, Config> fieldMap = this.getConfigFields();
        HashMap<String, JsonObject> configs = new HashMap<String, JsonObject>();
        for (Map.Entry<Field, Config> entry : fieldMap.entrySet()) {
            Object value;
            String key;
            JsonObject categoryObject;
            Field field = entry.getKey();
            Config annotation = entry.getValue();
            JsonObject config = configs.computeIfAbsent(annotation.config(), s -> new JsonObject());
            if (config.has(annotation.category())) {
                categoryObject = config.getAsJsonObject(annotation.category());
            } else {
                categoryObject = new JsonObject();
                config.add(annotation.category(), (JsonElement)categoryObject);
            }
            String string = key = annotation.key().isEmpty() ? field.getName() : annotation.key();
            if (categoryObject.has(key)) {
                throw new UnsupportedOperationException("Something bad happened, duplicate key found: " + key);
            }
            JsonObject fieldObject = new JsonObject();
            fieldObject.addProperty("comment", annotation.comment());
            try {
                value = field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            JsonElement jsonElement = GSON.toJsonTree(value);
            fieldObject.add("value", jsonElement);
            categoryObject.add(key, (JsonElement)fieldObject);
        }
        return configs;
    }

    public void readFromJson(HashMap<String, JsonObject> configs) {
        HashMap<Field, Config> fieldMap = this.getConfigFields();
        for (Map.Entry<Field, Config> entry : fieldMap.entrySet()) {
            JsonObject fieldObject;
            String key;
            JsonObject categoryObject;
            Field field = entry.getKey();
            Config annotation = entry.getValue();
            JsonObject config = configs.get(annotation.config());
            if (config == null || (categoryObject = config.getAsJsonObject(annotation.category())) == null || !categoryObject.has(key = annotation.key().isEmpty() ? field.getName() : annotation.key()) || !(fieldObject = categoryObject.get(key).getAsJsonObject()).has("value")) continue;
            JsonElement jsonValue = fieldObject.get("value");
            Class<?> fieldType = field.getType();
            Object fieldValue = GSON.fromJson(jsonValue, fieldType);
            try {
                field.set(null, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to set field value", e);
            }
        }
    }
}

