/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.growableores.block.init;

import com.mojang.serialization.MapCodec;
import com.skniro.growableores.conifg.GrowableOresConfig;
import com.skniro.growableores.registry.tag.GrowableBlockTags;
import com.skniro.growableores.registry.tag.GrowableFluidTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrowableOreCaneBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<GrowableOreCaneBlock> CODEC = GrowableOreCaneBlock.simpleCodec(GrowableOreCaneBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    protected static final float field_31258 = 6.0f;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public MapCodec<GrowableOreCaneBlock> codec() {
        return CODEC;
    }

    public GrowableOreCaneBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.isEmptyBlock(pos.above())) {
            int i = 1;
            while (world.getBlockState(pos.below(i)).is((Block)this)) {
                ++i;
            }
            if (i < GrowableOresConfig.Ore_Cane_Max_Height) {
                int j = (Integer)state.getValue((Property)AGE);
                if (j == 15) {
                    world.setBlockAndUpdate(pos.above(), this.defaultBlockState());
                    world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
                } else {
                    world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                }
            }
        }
    }

    public BlockState updateShape(BlockState p_57179_, Direction p_57180_, BlockState p_57181_, LevelAccessor p_57182_, BlockPos p_57183_, BlockPos p_57184_) {
        if (!p_57179_.canSurvive((LevelReader)p_57182_, p_57183_)) {
            p_57182_.scheduleTick(p_57183_, (Block)this, 1);
        }
        return super.updateShape(p_57179_, p_57180_, p_57181_, p_57182_, p_57183_, p_57184_);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos.below());
        if (blockState.is((Block)this)) {
            return true;
        }
        if (blockState.is(BlockTags.DIRT) || blockState.is(BlockTags.SAND) || blockState.is(GrowableBlockTags.GrowBlock)) {
            BlockPos blockPos = pos.below();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockState2 = world.getBlockState(blockPos.relative(direction));
                FluidState fluidState = world.getFluidState(blockPos.relative(direction));
                if (!fluidState.is(FluidTags.WATER) && !blockState2.is(Blocks.FROSTED_ICE) && !fluidState.is(GrowableFluidTags.GrowFluid)) continue;
                return true;
            }
        }
        return false;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getAge(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty());
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos pos, BlockState state) {
        if (GrowableOresConfig.Ore_Cane_Bonemeal) {
            return this.getAge(state) < 15;
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return GrowableOresConfig.Ore_Cane_Bonemeal;
    }

    public void performBonemeal(ServerLevel level, RandomSource randomSource, BlockPos pos, BlockState state) {
        if (GrowableOresConfig.Ore_Cane_Bonemeal) {
            for (int y = pos.getY(); y <= level.getHeight(); ++y) {
                BlockPos uppos = new BlockPos(pos.getX(), y, pos.getZ());
                Block block = level.getBlockState(uppos).getBlock();
                if (block == this) continue;
                if (!block.equals(Blocks.AIR)) break;
                level.setBlockAndUpdate(uppos, this.defaultBlockState());
                level.levelEvent(2005, uppos, 0);
                level.levelEvent(2005, uppos.above(), 0);
                break;
            }
        }
    }
}

