/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.growableores.block.init;

import com.skniro.growableores.conifg.GrowableOresConfig;
import com.skniro.growableores.registry.tag.GrowableBlockTags;
import com.skniro.growableores.registry.tag.GrowableFluidTags;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class GrowableOreCaneBlock
extends Block
implements IGrowable,
IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    protected static final float field_31258 = 6.0f;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public GrowableOreCaneBlock(AbstractBlock.Properties settings) {
        super(settings);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        } else if (world.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (world.func_180495_p(pos.func_177979_c(i)).func_203425_a((Block)this)) {
                ++i;
            }
            if (i < GrowableOresConfig.Ore_Cane_Max_Height) {
                int j = (Integer)state.func_177229_b((Property)AGE);
                if (j == 15) {
                    world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
                } else {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                }
            }
        }
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
        return super.func_196271_a(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos.func_177977_b());
        if (blockState.func_203425_a((Block)this)) {
            return true;
        }
        if (blockState.func_203425_a(Blocks.field_196658_i) || blockState.func_203425_a(Blocks.field_150346_d) || blockState.func_203425_a(Blocks.field_196660_k) || blockState.func_203425_a(Blocks.field_196661_l) || blockState.func_203425_a(Blocks.field_150354_m) || blockState.func_203425_a(Blocks.field_196611_F) || blockState.func_235714_a_(GrowableBlockTags.GrowBlock)) {
            BlockPos blockPos = pos.func_177977_b();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockState2 = world.func_180495_p(blockPos.func_177972_a(direction));
                FluidState fluidState = world.func_204610_c(blockPos.func_177972_a(direction));
                if (!fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && !blockState2.func_203425_a(Blocks.field_185778_de) && !fluidState.func_206884_a(GrowableFluidTags.GrowFluid)) continue;
                return true;
            }
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.BEACH;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }

    public boolean func_176473_a(IBlockReader IBlockReader2, BlockPos pos, BlockState state, boolean includeData) {
        if (GrowableOresConfig.Ore_Cane_Bonemeal) {
            return this.getAge(state) < 15;
        }
        return false;
    }

    public boolean func_180670_a(World level, Random random, BlockPos pos, BlockState state) {
        return GrowableOresConfig.Ore_Cane_Bonemeal;
    }

    public void func_225535_a_(ServerWorld level, Random randomSource, BlockPos pos, BlockState state) {
        if (GrowableOresConfig.Ore_Cane_Bonemeal) {
            for (int y = pos.func_177956_o(); y <= level.func_234938_ad_(); ++y) {
                BlockPos uppos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                Block block = level.func_180495_p(uppos).func_177230_c();
                if (block == this) continue;
                if (!block.equals(Blocks.field_150350_a)) break;
                level.func_175656_a(uppos, this.func_176223_P());
                level.func_217379_c(2005, uppos, 0);
                level.func_217379_c(2005, uppos.func_177984_a(), 0);
                break;
            }
        }
    }
}

