/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.growableores.block.init;

import com.skniro.growableores.conifg.GrowableOresConfig;
import com.skniro.growableores.registry.tag.GrowableBlockTags;
import com.skniro.growableores.registry.tag.GrowableFluidTags;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrowableOreCaneBlock
extends Block
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    protected static final float field_31258 = 6.0f;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public GrowableOreCaneBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (world.m_46859_(pos.m_7494_())) {
            int i = 1;
            while (world.m_8055_(pos.m_6625_(i)).m_60713_((Block)this)) {
                ++i;
            }
            if (i < GrowableOresConfig.Ore_Cane_Max_Height) {
                int j = (Integer)state.m_61143_((Property)AGE);
                if (j == 15) {
                    world.m_46597_(pos.m_7494_(), this.m_49966_());
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
                } else {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                }
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos.m_7495_());
        if (blockState.m_60713_((Block)this)) {
            return true;
        }
        if (blockState.m_204336_(BlockTags.f_144274_) || blockState.m_204336_(BlockTags.f_13029_) || blockState.m_204336_(GrowableBlockTags.GrowBlock)) {
            BlockPos blockPos = pos.m_7495_();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockState2 = world.m_8055_(blockPos.m_142300_(direction));
                FluidState fluidState = world.m_6425_(blockPos.m_142300_(direction));
                if (!fluidState.m_205070_(FluidTags.f_13131_) && !blockState2.m_60713_(Blocks.f_50449_) && !fluidState.m_205070_(GrowableFluidTags.GrowFluid)) continue;
                return true;
            }
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public boolean m_7370_(BlockGetter blockGetter, BlockPos pos, BlockState state, boolean includeData) {
        if (GrowableOresConfig.Ore_Cane_Bonemeal) {
            return this.getAge(state) < 15;
        }
        return false;
    }

    public boolean m_5491_(Level level, Random random, BlockPos pos, BlockState state) {
        return GrowableOresConfig.Ore_Cane_Bonemeal;
    }

    public void m_7719_(ServerLevel level, Random randomSource, BlockPos pos, BlockState state) {
        if (GrowableOresConfig.Ore_Cane_Bonemeal) {
            for (int y = pos.m_123342_(); y <= level.m_141928_(); ++y) {
                BlockPos uppos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                Block block = level.m_8055_(uppos).m_60734_();
                if (block == this) continue;
                if (!block.equals(Blocks.f_50016_)) break;
                level.m_46597_(uppos, this.m_49966_());
                level.m_46796_(2005, uppos, 0);
                level.m_46796_(2005, uppos.m_7494_(), 0);
                break;
            }
        }
    }
}

