/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.client.renderer;

import java.time.LocalDate;
import java.time.Month;
import net.deadlydiamond98.entities.HeartPickupEntity;
import net.deadlydiamond98.misc.HealPGoodConfig;
import net.deadlydiamond98.util.SeasonalHeart;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class HeartPickupEntityRenderer
extends class_897<HeartPickupEntity> {
    private static final class_2960 NUMBER = new class_2960("healpgood", "textures/entity/heart/heart_number.png");
    private static int frame = 0;
    private static int frontAlpha = 0;
    private static boolean isJune;
    private static boolean isChristmas;
    public static boolean isApril;

    public HeartPickupEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx);
        this.field_4673 = 0.15f;
        this.field_4672 = 0.75f;
        SeasonalHeart season = HealPGoodConfig.Main.seasonalHearts;
        LocalDate date = LocalDate.now();
        isApril = date.getMonth() == Month.APRIL && date.getDayOfMonth() == 1 && season.canChange();
        isJune = date.getMonth() == Month.JUNE && season.canChange();
        isChristmas = date.getMonth() == Month.DECEMBER && season.canChange();
    }

    protected int getBlockLight(HeartPickupEntity entity, class_2338 blockPos) {
        return class_3532.method_15340((int)(super.method_24087((class_1297)entity, blockPos) + 7), (int)0, (int)15);
    }

    public void render(HeartPickupEntity entity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        matrixStack.method_22903();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        matrixStack.method_22907(class_7833.field_40715.rotationDegrees(camera.method_19330()));
        matrixStack.method_22904(-0.1328125, 0.1, 0.0);
        int maxAngle = 60;
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15363((float)camera.method_19329(), (float)(-maxAngle), (float)maxAngle)));
        double bob = (Math.sin((double)entity.field_6012 / 10.0) * 0.1 + 0.1) / 8.0;
        matrixStack.method_22904(0.0, bob - 0.1, 0.0);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_29379((class_2960)this.getTexture(entity)));
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        Matrix3f matrix3f = entry.method_23762();
        matrixStack.method_22905(0.25f, 0.25f, 1.0f);
        if (++frontAlpha >= 275) {
            frontAlpha = 0;
            frame = (frame + 1) % this.getFrames();
        }
        float textureHeight = 1.0f / (float)this.getFrames();
        float minV = textureHeight * (float)frame;
        float maxV = minV + textureHeight;
        HeartPickupEntityRenderer.renderFace(vertexConsumer, matrix4f, matrix3f, 255, minV, maxV, 0.0f, i);
        HeartPickupEntityRenderer.renderFace(vertexConsumer, matrix4f, matrix3f, Math.min(frontAlpha, 255), minV + textureHeight, maxV + textureHeight, -1.0E-4f, i);
        float numTextureHeight = 0.11111111f;
        float numMinV = numTextureHeight * (float)(entity.getHealAmount() - 1);
        float numMaxV = numMinV + numTextureHeight;
        class_4588 vertexConsumerNumber = vertexConsumerProvider.getBuffer(class_1921.method_29379((class_2960)NUMBER));
        HeartPickupEntityRenderer.renderFace(vertexConsumerNumber, matrix4f, matrix3f, 255, numMinV, numMaxV, -2.0E-4f, i);
        matrixStack.method_22909();
        super.method_3936((class_1297)entity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    private static void renderFace(class_4588 vertexConsumer, Matrix4f positionMatrix, Matrix3f normalMatrix, int alpha, float minV, float maxV, float z, int i) {
        HeartPickupEntityRenderer.vertex(vertexConsumer, positionMatrix, normalMatrix, 1.0f, 0.0f, z, alpha, 0.0f, maxV, i);
        HeartPickupEntityRenderer.vertex(vertexConsumer, positionMatrix, normalMatrix, 0.0f, 0.0f, z, alpha, 1.0f, maxV, i);
        HeartPickupEntityRenderer.vertex(vertexConsumer, positionMatrix, normalMatrix, 0.0f, 1.0f, z, alpha, 1.0f, minV, i);
        HeartPickupEntityRenderer.vertex(vertexConsumer, positionMatrix, normalMatrix, 1.0f, 1.0f, z, alpha, 0.0f, minV, i);
    }

    private static void vertex(class_4588 vertexConsumer, Matrix4f positionMatrix, Matrix3f normalMatrix, float x, float y, float z, int alpha, float u, float v, int light) {
        vertexConsumer.method_22918(positionMatrix, x, y, z).method_1336(255, 255, 255, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
    }

    private int getFrames() {
        SeasonalHeart season = HealPGoodConfig.Main.seasonalHearts;
        if (season.canChange()) {
            return isJune ? 20 : season.frames;
        }
        return season.frames;
    }

    public class_2960 getTexture(HeartPickupEntity entity) {
        SeasonalHeart season = HealPGoodConfig.Main.seasonalHearts;
        if (season.canChange()) {
            if (isApril) {
                return this.getTexture("april");
            }
            if (isJune) {
                return this.getTexture("pride");
            }
            if (isChristmas) {
                return this.getTexture("christmas");
            }
        }
        return this.getTexture(season.texture);
    }

    private class_2960 getTexture(String name) {
        return new class_2960("healpgood", "textures/entity/heart/" + name + ".png");
    }
}

