/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.eclipce.transpondersnails.block.ModBlocks;
import net.eclipce.transpondersnails.block.entity.ModBlockEntities;
import net.eclipce.transpondersnails.block.entity.TransponderSnailBlockEntity;
import net.eclipce.transpondersnails.commands.CallCommand;
import net.eclipce.transpondersnails.commands.SnailNumberCommand;
import net.eclipce.transpondersnails.commands.SpawnTestCommand;
import net.eclipce.transpondersnails.commands.TransponderSnailItemCommand;
import net.eclipce.transpondersnails.config.ModConfig;
import net.eclipce.transpondersnails.entity.ModEntities;
import net.eclipce.transpondersnails.entity.client.DenDenMushiRenderer;
import net.eclipce.transpondersnails.item.ModCreativeModeTabs;
import net.eclipce.transpondersnails.item.ModItems;
import net.eclipce.transpondersnails.network.ModPackets;
import net.eclipce.transpondersnails.recipe.ModRecipeSerializers;
import net.eclipce.transpondersnails.screen.ModMenuTypes;
import net.eclipce.transpondersnails.sound.ModSounds;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="transpondersnails")
@Mod.EventBusSubscriber
public class TransponderSnails {
    public static final String MOD_ID = "transpondersnails";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static TransponderCallManager callManager;
    public static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;

    public TransponderSnails(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModRecipeSerializers.register(modEventBus);
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfig.CLIENT_SPEC, "transpondersnails-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModConfig.SERVER_SPEC, "transpondersnails-server.toml");
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        event.enqueueWork(() -> {
            ModPackets.init();
            LOGGER.info("ModPackets Initialized");
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        TransponderSnailBlockEntity.setServerStartingUp();
        System.out.println("TransponderSnails: Server starting - reset block entity state");
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        TransponderSnailBlockEntity.setServerShuttingDown();
        System.out.println("TransponderSnails: Server stopping - preventing block entity loops");
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CallCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SnailNumberCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        TransponderSnailItemCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SpawnTestCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    public static void setCallManager(TransponderCallManager manager) {
        callManager = manager;
        LOGGER.info("Call manager initialized successfully!");
    }

    public static TransponderCallManager getCallManager() {
        if (callManager == null) {
            LOGGER.warn("Call manager not initialized! Make sure Simple Voice Chat is installed and the server has started.");
            return null;
        }
        return callManager;
    }

    static {
        workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    }

    @Mod.EventBusSubscriber(modid="transpondersnails", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.DEN_DEN_MUSHI.get()), DenDenMushiRenderer::new);
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }
    }
}

