/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.block.entity;

import java.io.Serializable;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.eclipce.transpondersnails.TransponderSnails;
import net.eclipce.transpondersnails.block.custom.TransponderSnailBlock;
import net.eclipce.transpondersnails.block.entity.ModBlockEntities;
import net.eclipce.transpondersnails.data.SnailNumberRegistry;
import net.eclipce.transpondersnails.item.DenDenMushiItem;
import net.eclipce.transpondersnails.item.ModItems;
import net.eclipce.transpondersnails.network.ModPackets;
import net.eclipce.transpondersnails.network.packets.CallStateSyncPacket;
import net.eclipce.transpondersnails.network.packets.SnailNumberSyncPacket;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.eclipce.transpondersnails.voice.VoiceChatConstants;
import net.eclipce.transpondersnails.voice.server.CallSession;
import net.eclipce.transpondersnails.voice.server.CallSoundManager;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TransponderSnailBlockEntity
extends BlockEntity
implements MenuProvider,
CallSoundManager.BlockstateUpdateCallback {
    private static boolean isServerShuttingDown = false;
    private static final Set<BlockPos> processedPositions = ConcurrentHashMap.newKeySet();
    private UUID activeCallId;
    private boolean isRinging = false;
    private String dialedNumber = "";
    public UUID snailUUID = null;
    public int assignedSnailNumber = -1;
    public boolean initialized = false;
    private boolean needsValidation = false;
    private CallStateSyncPacket.CallState currentCallState = CallStateSyncPacket.CallState.IDLE;
    private long ringStartTime = 0L;
    private boolean hasAmbientSound = false;
    private boolean inActiveCall = false;
    private long lastBlockstateUpdate = 0L;
    private boolean isUnloading = false;
    private boolean hasBeenLoaded = false;
    private boolean validationCompleted = false;
    private CallSession currentCallSession = null;
    private boolean audioReady = false;
    public int bodyColor = -1;
    public int shellColor = 0;
    public boolean colorsInitialized = false;
    private static final ResourceLocation UV_MASK_TEXTURE = new ResourceLocation("transpondersnails:block/transpondersnail/snail/transponder_snail_uv_mask");

    public TransponderSnailBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TRANSPONDER_SNAIL_BE.get(), pPos, pBlockState);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.transpondersnails.dialing");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory pInventory, Player pPlayer) {
        if (!pPlayer.m_9236_().f_46443_) {
            this.ensureSnailNumberAssigned(pPlayer);
        }
        return new DialingMenu(containerId, pInventory, this);
    }

    private void updateBlockstateVisuals() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        String targetModel = this.determineModelFromCallSession();
        boolean newHasSound = this.shouldHaveSoundState(targetModel);
        boolean newInCall = this.shouldHaveCallState(targetModel);
        boolean currentHasSound = this.getCurrentVisualSoundState();
        boolean currentInCall = this.getCurrentVisualCallState();
        long now = System.currentTimeMillis();
        if (currentHasSound != newHasSound || currentInCall != newInCall) {
            TransponderSnailBlock.updateVisualState(this.f_58857_, this.f_58858_, newHasSound, newInCall);
            this.lastBlockstateUpdate = now;
            System.out.println("TransponderSnailBlockEntity: Updated blockstate to " + targetModel + " (Sound: " + newHasSound + ", Call: " + newInCall + ") for CallSession state: " + (Serializable)(this.currentCallSession != null ? this.currentCallSession.getState() : "NO_SESSION") + " at " + this.f_58858_);
        }
    }

    private String determineModelFromCallSession() {
        if (this.currentCallSession == null) {
            if (this.hasAmbientSound) {
                return "transponder_snail_sound";
            }
            return "transponder_snail";
        }
        switch (this.currentCallSession.getState()) {
            case INITIATING: {
                return "transponder_snail";
            }
            case RINGING: {
                if (this.isThisSnailBeingCalled()) {
                    return "transponder_snail_sound";
                }
                return "transponder_snail";
            }
            case CONNECTED: {
                if (this.hasAmbientSound) {
                    return "transponder_snail_active";
                }
                return "transponder_snail_call";
            }
            case ENDING: {
                return "transponder_snail_sound";
            }
            case ENDED: {
                if (this.hasAmbientSound) {
                    return "transponder_snail_sound";
                }
                return "transponder_snail";
            }
        }
        return "transponder_snail";
    }

    private boolean isThisSnailBeingCalled() {
        if (this.currentCallSession == null || this.assignedSnailNumber == -1) {
            return false;
        }
        return this.currentCallSession.isParticipant(this.assignedSnailNumber) && this.isRinging;
    }

    private boolean shouldHaveSoundState(String modelName) {
        switch (modelName) {
            case "transponder_snail": {
                return false;
            }
            case "transponder_snail_sound": {
                return true;
            }
            case "transponder_snail_call": {
                return false;
            }
            case "transponder_snail_active": {
                return true;
            }
        }
        return false;
    }

    private boolean shouldHaveCallState(String modelName) {
        switch (modelName) {
            case "transponder_snail": {
                return false;
            }
            case "transponder_snail_sound": {
                return false;
            }
            case "transponder_snail_call": {
                return true;
            }
            case "transponder_snail_active": {
                return true;
            }
        }
        return false;
    }

    public void setCallSession(CallSession callSession) {
        this.currentCallSession = callSession;
        this.updateBlockstateVisuals();
        System.out.println("TransponderSnailBlockEntity: Call session set to " + (Serializable)(callSession != null ? callSession.getState() : "null") + " for snail #" + this.assignedSnailNumber);
    }

    public void clearCallSession() {
        this.currentCallSession = null;
        this.updateBlockstateVisuals();
        System.out.println("TransponderSnailBlockEntity: Call session cleared for snail #" + this.assignedSnailNumber);
    }

    public CallSession getCallSession() {
        return this.currentCallSession;
    }

    private boolean getCurrentVisualSoundState() {
        BlockState state;
        if (this.f_58857_ != null && (state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() instanceof TransponderSnailBlock) {
            return (Boolean)state.m_61143_((Property)TransponderSnailBlock.HAS_SOUND);
        }
        return false;
    }

    public boolean getCurrentVisualCallState() {
        BlockState state;
        if (this.f_58857_ != null && (state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() instanceof TransponderSnailBlock) {
            return (Boolean)state.m_61143_((Property)TransponderSnailBlock.IN_CALL);
        }
        return false;
    }

    @Override
    public void onSoundStateChanged(BlockPos pos, boolean hasAmbientSound) {
        if (pos.equals((Object)this.f_58858_)) {
            this.hasAmbientSound = hasAmbientSound;
            this.updateBlockstateVisuals();
            String soundType = "unknown";
            if (this.currentCallSession != null) {
                switch (this.currentCallSession.getState()) {
                    case RINGING: {
                        soundType = hasAmbientSound ? "incoming ring" : "ring stopped";
                        break;
                    }
                    case CONNECTED: {
                        soundType = hasAmbientSound ? "call audio" : "call audio stopped";
                        break;
                    }
                    case ENDING: 
                    case ENDED: {
                        soundType = hasAmbientSound ? "disconnect sound" : "disconnect sound ended";
                    }
                }
            } else if (hasAmbientSound) {
                soundType = "ambient sound (no session)";
            }
            System.out.println("TransponderSnailBlockEntity: Sound state changed - " + soundType + " hasAmbientSound: " + hasAmbientSound + " sessionState: " + (Serializable)(this.currentCallSession != null ? this.currentCallSession.getState() : "NO_SESSION"));
        }
    }

    public static void setServerShuttingDown() {
        isServerShuttingDown = true;
        processedPositions.clear();
    }

    public static void setServerStartingUp() {
        isServerShuttingDown = false;
        processedPositions.clear();
    }

    private TransponderCallManager getCallManager() {
        return TransponderSnails.getCallManager();
    }

    private boolean isCallManagerAvailable() {
        return this.getCallManager() != null;
    }

    public InteractionResult onPlayerInteraction(ServerPlayer player, boolean isSneaking) {
        if (!this.isCallManagerAvailable()) {
            player.m_213846_((Component)Component.m_237113_((String)"Voice chat system not available!").m_130940_(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        TransponderCallManager callManager = this.getCallManager();
        if (this.isRinging && this.activeCallId != null) {
            if (isSneaking) {
                player.m_5893_((MenuProvider)this);
                return InteractionResult.SUCCESS;
            }
            if (callManager.acceptCall(player, this.activeCallId)) {
                this.setRinging(false);
                this.setCallState(CallStateSyncPacket.CallState.CONNECTED);
                player.m_213846_((Component)Component.m_237113_((String)"Call answered!").m_130940_(ChatFormatting.GREEN));
                return InteractionResult.SUCCESS;
            }
            player.m_213846_((Component)Component.m_237113_((String)"Failed to answer call!").m_130940_(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        if (this.activeCallId != null && this.currentCallState == CallStateSyncPacket.CallState.CONNECTED) {
            if (isSneaking) {
                player.m_5893_((MenuProvider)this);
                return InteractionResult.SUCCESS;
            }
            if (callManager.isInCall(player.m_20148_())) {
                callManager.endCall(player);
                player.m_213846_((Component)Component.m_237113_((String)"Call ended!").m_130940_(ChatFormatting.YELLOW));
                return InteractionResult.SUCCESS;
            }
            player.m_213846_((Component)Component.m_237113_((String)"Transponder Snail is busy!").m_130940_(ChatFormatting.YELLOW));
            return InteractionResult.FAIL;
        }
        if (this.currentCallState == CallStateSyncPacket.CallState.IDLE) {
            player.m_5893_((MenuProvider)this);
            return InteractionResult.SUCCESS;
        }
        if (isSneaking) {
            player.m_5893_((MenuProvider)this);
            return InteractionResult.SUCCESS;
        }
        player.m_213846_((Component)Component.m_237113_((String)"Transponder Snail is busy!").m_130940_(ChatFormatting.YELLOW));
        return InteractionResult.FAIL;
    }

    public InteractionResult onUse(ServerPlayer player) {
        return this.onPlayerInteraction(player, false);
    }

    private void resetAudioReadiness() {
        this.audioReady = false;
    }

    public void onIncomingCall(UUID callId, int callerSnailNumber, CallSession callSession) {
        this.activeCallId = callId;
        this.setRinging(true);
        this.m_6596_();
        this.setCallState(CallStateSyncPacket.CallState.RINGING_IN);
        this.ringStartTime = System.currentTimeMillis();
        this.setCallSession(callSession);
        List<ServerPlayer> nearbyPlayers = this.getNearbyListeners();
        for (ServerPlayer player : nearbyPlayers) {
            CallSoundManager soundManager;
            player.m_213846_((Component)Component.m_237113_((String)("Transponder Snail #" + this.assignedSnailNumber + " is ringing! (Call from #" + callerSnailNumber + ")")).m_130940_(ChatFormatting.YELLOW));
            TransponderCallManager callManager = this.getCallManager();
            if (callManager == null || (soundManager = callManager.getSoundManager()) == null) continue;
            soundManager.playLocationalRingTone(player, this.f_58858_);
        }
        CallStateSyncPacket packet = new CallStateSyncPacket(CallStateSyncPacket.CallState.RINGING_IN, callId, callerSnailNumber, "Incoming from #" + callerSnailNumber);
        if (this.f_58857_ instanceof ServerLevel) {
            for (ServerPlayer player : nearbyPlayers) {
                DialingMenu dialingMenu;
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (!(abstractContainerMenu instanceof DialingMenu) || (dialingMenu = (DialingMenu)abstractContainerMenu).getBlockEntity() != this) continue;
                ModPackets.sendToPlayer(packet, player);
            }
        }
        System.out.println("TransponderSnailBlockEntity: Snail #" + this.assignedSnailNumber + " receiving call from #" + callerSnailNumber);
    }

    public void onCallConnected(UUID callId, CallSession callSession) {
        this.activeCallId = callId;
        this.setRinging(false);
        this.m_6596_();
        this.setCallState(CallStateSyncPacket.CallState.CONNECTED);
        this.setCallSession(callSession);
        List<ServerPlayer> nearbyPlayers = this.getNearbyListeners();
        for (ServerPlayer player : nearbyPlayers) {
            player.m_213846_((Component)Component.m_237113_((String)"Call connected!").m_130940_(ChatFormatting.GREEN));
        }
        System.out.println("TransponderSnailBlockEntity: Snail #" + this.assignedSnailNumber + " call connected");
    }

    public void onCallFullyConnected(UUID callId) {
        if (this.activeCallId != null && this.activeCallId.equals(callId)) {
            this.audioReady = true;
            this.m_6596_();
            System.out.println("TransponderSnailBlockEntity: Snail #" + this.assignedSnailNumber + " is now ready for audio transmission");
        }
    }

    public void onCallEnded(UUID callId) {
        boolean wasRinging = this.isRinging;
        this.activeCallId = null;
        this.setRinging(false);
        this.clearDialedNumber();
        this.resetAudioReadiness();
        this.m_6596_();
        this.setCallState(CallStateSyncPacket.CallState.IDLE);
        this.clearCallSession();
        List<ServerPlayer> nearbyPlayers = this.getNearbyListeners();
        for (ServerPlayer player : nearbyPlayers) {
            if (wasRinging) {
                player.m_213846_((Component)Component.m_237113_((String)"Incoming call ended.").m_130940_(ChatFormatting.GRAY));
                continue;
            }
            player.m_213846_((Component)Component.m_237113_((String)"Call ended.").m_130940_(ChatFormatting.GRAY));
        }
        System.out.println("TransponderSnailBlockEntity: Snail #" + this.assignedSnailNumber + " call ended");
    }

    public void onCallFailed(String reason) {
        this.setCallState(CallStateSyncPacket.CallState.IDLE);
        this.clearCallSession();
        List<ServerPlayer> nearbyPlayers = this.getNearbyListeners();
        for (ServerPlayer player : nearbyPlayers) {
            player.m_213846_((Component)Component.m_237113_((String)("Call failed: " + reason)).m_130940_(ChatFormatting.RED));
        }
        System.out.println("TransponderSnailBlockEntity: Snail #" + this.assignedSnailNumber + " call failed: " + reason);
    }

    public void onTargetBusy(int targetNumber) {
        this.setCallState(CallStateSyncPacket.CallState.BUSY);
        this.updateBlockstateVisuals();
        List<ServerPlayer> nearbyPlayers = this.getNearbyListeners();
        for (ServerPlayer player : nearbyPlayers) {
            player.m_213846_((Component)Component.m_237113_((String)("Snail #" + targetNumber + " is busy!")).m_130940_(ChatFormatting.YELLOW));
        }
        if (this.f_58857_ instanceof ServerLevel) {
            this.f_58857_.m_7654_().execute(() -> {
                try {
                    Thread.sleep(2000L);
                    this.setCallState(CallStateSyncPacket.CallState.IDLE);
                    this.clearCallSession();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    public boolean isAudioReady() {
        return this.audioReady && this.currentCallState == CallStateSyncPacket.CallState.CONNECTED && this.getCurrentVisualCallState();
    }

    private void setCallState(CallStateSyncPacket.CallState newState) {
        if (newState != this.currentCallState) {
            CallStateSyncPacket.CallState oldState = this.currentCallState;
            this.currentCallState = newState;
            this.m_6596_();
            this.updateBlockstateVisuals();
            if (this.f_58857_ instanceof ServerLevel) {
                List<ServerPlayer> nearbyPlayers = this.getNearbyListeners();
                for (ServerPlayer player : nearbyPlayers) {
                    DialingMenu dialingMenu;
                    AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                    if (!(abstractContainerMenu instanceof DialingMenu) || (dialingMenu = (DialingMenu)abstractContainerMenu).getBlockEntity() != this) continue;
                    ModPackets.sendToPlayer(new CallStateSyncPacket(newState, this.activeCallId, -1, this.getStateMessage(newState)), player);
                }
            }
            System.out.println("TransponderSnailBlockEntity: Call state changed from " + oldState + " to " + newState);
        }
    }

    private String getStateMessage(CallStateSyncPacket.CallState state) {
        switch (state) {
            case IDLE: {
                return "";
            }
            case DIALING: {
                return "Dialing...";
            }
            case RINGING_OUT: {
                return "Calling...";
            }
            case RINGING_IN: {
                return "Incoming call";
            }
            case CONNECTED: {
                return "Connected";
            }
            case BUSY: {
                return "Busy";
            }
            case DISCONNECTED: {
                return "Disconnected";
            }
        }
        return "";
    }

    public CallStateSyncPacket.CallState getCurrentCallState() {
        return this.currentCallState;
    }

    public void transferColorsFromDenDenMushi(ItemStack denDenMushiItem) {
        if (denDenMushiItem.m_41720_() instanceof DenDenMushiItem && DenDenMushiItem.isCaptured(denDenMushiItem)) {
            this.bodyColor = DenDenMushiItem.getBodyColor(denDenMushiItem);
            this.shellColor = DenDenMushiItem.getShellColor(denDenMushiItem);
            this.colorsInitialized = true;
            this.m_6596_();
            System.out.println("TransponderSnailBlockEntity: Transferred colors from Den Den Mushi - Body: #" + Integer.toHexString(this.bodyColor) + ", Shell: " + DyeColor.m_41053_((int)this.shellColor).m_41065_());
        }
    }

    public ItemStack createDenDenMushiWithColors() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.DEN_DEN_MUSHI.get());
        if (this.colorsInitialized) {
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128405_("BodyColor", this.bodyColor);
            nbt.m_128405_("ShellColor", this.shellColor);
        }
        return stack;
    }

    public boolean isColorsInitialized() {
        return this.colorsInitialized;
    }

    public boolean canBeDyed() {
        return this.colorsInitialized || this.hasAssignedNumber();
    }

    public boolean applyDye(Item dyeItem, @Nullable Player player) {
        if (dyeItem instanceof DyeItem) {
            DyeItem dye = (DyeItem)dyeItem;
            int newColor = dye.m_41089_().m_41060_();
            if (newColor != this.shellColor) {
                this.setShellColor(newColor);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_213846_((Component)Component.m_237113_((String)("Transponder Snail shell dyed " + dye.m_41089_().m_41065_().replace("_", " ") + "!")).m_130940_(ChatFormatting.GREEN));
                }
                return true;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_213846_((Component)Component.m_237113_((String)("Transponder Snail is already " + dye.m_41089_().m_41065_().replace("_", " ") + "!")).m_130940_(ChatFormatting.YELLOW));
            }
        }
        return false;
    }

    public CompoundTag getColorData() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("BodyColor", this.getBodyColor());
        data.m_128405_("ShellColor", this.shellColor);
        data.m_128379_("ColorsInitialized", this.colorsInitialized);
        return data;
    }

    public CompoundTag getBlockEntityRenderData() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("BodyColor", this.getBodyColor());
        data.m_128405_("ShellColor", this.shellColor);
        data.m_128379_("ColorsInitialized", this.colorsInitialized);
        return data;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void testColorSystem() {
        System.out.println("=== TransponderSnail Color Debug ===");
        System.out.println("Colors initialized: " + this.colorsInitialized);
        System.out.println("Body color: #" + Integer.toHexString(this.bodyColor));
        System.out.println("Shell color: " + this.shellColor + " (" + DyeColor.m_41053_((int)this.shellColor).m_41065_() + ")");
        System.out.println("Level client side: " + (Serializable)(this.f_58857_ != null ? Boolean.valueOf(this.f_58857_.f_46443_) : "null"));
        System.out.println("===================================");
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && !this.colorsInitialized) {
            this.m_6596_();
        }
        if (!this.f_58857_.f_46443_ && !this.isUnloading) {
            CallSoundManager soundManager;
            System.out.println("TransponderSnailBlockEntity: onLoad called for position " + this.f_58858_);
            if (processedPositions.contains(this.f_58858_)) {
                System.out.println("TransponderSnailBlockEntity: Skipping duplicate onLoad for position " + this.f_58858_);
                return;
            }
            processedPositions.add(this.f_58858_);
            this.hasBeenLoaded = true;
            if (this.isCallManagerAvailable() && (soundManager = this.getCallManager().getSoundManager()) != null) {
                soundManager.registerBlockstateCallback(this);
                System.out.println("TransponderSnailBlockEntity: Registered blockstate callback for position " + this.f_58858_);
            }
            if (this.needsValidation && !this.validationCompleted) {
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_7654_().execute(() -> {
                        if (!this.isUnloading && !isServerShuttingDown && this.needsValidation && !this.validationCompleted) {
                            this.performDeferredValidation();
                        }
                    });
                }
            } else if (this.hasAssignedNumber() && !this.isUnloading) {
                this.registerWithCallManager();
            }
        }
    }

    public void m_7651_() {
        if (this.isUnloading) {
            return;
        }
        this.isUnloading = true;
        processedPositions.remove(this.f_58858_);
        if (!this.f_58857_.f_46443_) {
            CallSoundManager soundManager;
            System.out.println("TransponderSnailBlockEntity: setRemoved called for position " + this.f_58858_);
            this.unregisterFromCallManager();
            if (this.isCallManagerAvailable() && (soundManager = this.getCallManager().getSoundManager()) != null) {
                soundManager.unregisterBlockstateCallback(this);
                System.out.println("TransponderSnailBlockEntity: Unregistered blockstate callback for position " + this.f_58858_);
            }
            if (this.activeCallId != null && this.isCallManagerAvailable()) {
                TransponderCallManager callManager = this.getCallManager();
                callManager.endCallBySnailNumber(this.assignedSnailNumber);
            }
            if (!isServerShuttingDown && this.f_58857_ != null && this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof TransponderSnailBlock) {
                TransponderSnailBlock.updateVisualState(this.f_58857_, this.f_58858_, false, false);
            }
        }
        super.m_7651_();
    }

    private void performDeferredValidation() {
        if (!this.needsValidation || this.f_58857_.f_46443_ || this.isUnloading || isServerShuttingDown || this.validationCompleted) {
            return;
        }
        this.validationCompleted = true;
        System.out.println("TransponderSnailBlockEntity: Starting deferred validation for snail at " + this.f_58858_);
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry == null) {
            System.err.println("TransponderSnailBlockEntity: Registry not available - skipping validation");
            this.needsValidation = false;
            return;
        }
        boolean restored = false;
        if (this.snailUUID != null && this.assignedSnailNumber != -1 && this.initialized) {
            UUID registryUUID = registry.getSnailByNumber(this.assignedSnailNumber);
            if (registryUUID != null && registryUUID.equals(this.snailUUID)) {
                System.out.println("TransponderSnailBlockEntity: Validation passed - snail #" + this.assignedSnailNumber + " matches registry");
                restored = true;
            } else {
                System.out.println("TransponderSnailBlockEntity: Data mismatch detected - attempting restoration");
                int restoredNumber = registry.assignNumberToSnail(this.snailUUID);
                if (restoredNumber != -1) {
                    this.assignedSnailNumber = restoredNumber;
                    this.initialized = true;
                    this.m_6596_();
                    restored = true;
                    System.out.println("TransponderSnailBlockEntity: Successfully restored with number #" + restoredNumber);
                }
            }
        } else if (!(this.snailUUID == null || this.assignedSnailNumber != -1 && this.initialized)) {
            System.out.println("TransponderSnailBlockEntity: Found UUID without number - attempting restoration");
            int registryNumber = registry.getSnailNumber(this.snailUUID);
            if (registryNumber != -1) {
                this.assignedSnailNumber = registryNumber;
                this.initialized = true;
                this.m_6596_();
                restored = true;
                System.out.println("TransponderSnailBlockEntity: Restored existing assignment #" + registryNumber);
            } else {
                int restoredNumber = registry.assignNumberToSnail(this.snailUUID);
                if (restoredNumber != -1) {
                    this.assignedSnailNumber = restoredNumber;
                    this.initialized = true;
                    this.m_6596_();
                    restored = true;
                    System.out.println("TransponderSnailBlockEntity: Restored new assignment #" + restoredNumber);
                }
            }
        }
        if (restored && !this.isUnloading && !isServerShuttingDown) {
            this.registerWithCallManager();
            System.out.println("TransponderSnailBlockEntity: Deferred validation completed successfully");
        } else if (!restored) {
            System.err.println("TransponderSnailBlockEntity: Deferred validation failed - snail will need manual reassignment");
            this.initialized = false;
            this.assignedSnailNumber = -1;
            this.m_6596_();
        }
        this.needsValidation = false;
    }

    public void ensureSnailNumberAssigned(Player player) {
        SnailNumberRegistry registry;
        System.out.println("TransponderSnailBlockEntity: ensureSnailNumberAssigned called for snail at " + this.f_58858_ + " (initialized: " + this.initialized + ", number: " + this.assignedSnailNumber + ")");
        if (this.needsValidation) {
            this.performDeferredValidation();
        }
        if (this.initialized && this.snailUUID != null && this.assignedSnailNumber != -1 && (registry = SnailNumberRegistry.getInstance()) != null) {
            UUID registryUUID = registry.getSnailByNumber(this.assignedSnailNumber);
            if (registryUUID != null && registryUUID.equals(this.snailUUID)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModPackets.sendToPlayer(new SnailNumberSyncPacket(this.assignedSnailNumber), serverPlayer);
                    System.out.println("TransponderSnailBlockEntity: Re-syncing existing valid number #" + this.assignedSnailNumber + " to client");
                }
                return;
            }
            System.out.println("TransponderSnailBlockEntity: Number #" + this.assignedSnailNumber + " no longer valid, attempting restoration");
            int restoredNumber = registry.assignNumberToSnail(this.snailUUID);
            if (restoredNumber != -1) {
                this.assignedSnailNumber = restoredNumber;
                this.m_6596_();
                this.registerWithCallManager();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModPackets.sendToPlayer(new SnailNumberSyncPacket(restoredNumber), serverPlayer);
                    MutableComponent message = Component.m_237113_((String)("Your Transponder Snail number has been restored to #" + restoredNumber)).m_130940_(ChatFormatting.GREEN);
                    serverPlayer.m_213846_((Component)message);
                }
                return;
            }
            System.err.println("TransponderSnailBlockEntity: Failed to restore number - will assign new one");
            this.initialized = false;
            this.assignedSnailNumber = -1;
        }
        try {
            if (this.snailUUID == null) {
                this.snailUUID = UUID.randomUUID();
                System.out.println("TransponderSnailBlockEntity: Generated new UUID: " + this.snailUUID);
            }
            if ((registry = SnailNumberRegistry.getInstance()) != null) {
                int newNumber = registry.assignNumberToSnail(this.snailUUID);
                if (newNumber != -1) {
                    this.assignedSnailNumber = newNumber;
                    this.initialized = true;
                    this.initializeSnailColors();
                    this.m_6596_();
                    if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                        BlockState currentState = this.f_58857_.m_8055_(this.f_58858_);
                        this.f_58857_.m_7260_(this.f_58858_, currentState, currentState, 3);
                        System.out.println("TransponderSnailBlock: Assigned number and forced color sync");
                    }
                    this.registerWithCallManager();
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        MutableComponent message = Component.m_237113_((String)("Your Transponder Snail has been assigned number #" + this.assignedSnailNumber)).m_130940_(ChatFormatting.GREEN);
                        serverPlayer.m_213846_((Component)message);
                        ModPackets.sendToPlayer(new SnailNumberSyncPacket(this.assignedSnailNumber), serverPlayer);
                        System.out.println("TransponderSnailBlockEntity: Assigned new number #" + this.assignedSnailNumber + " and synced to client");
                    }
                    System.out.println("TransponderSnailBlockEntity: Successfully assigned new number #" + this.assignedSnailNumber + " to snail at " + this.f_58858_);
                } else {
                    System.err.println("TransponderSnailBlockEntity: Failed to assign number - registry may be full");
                }
            } else {
                System.err.println("TransponderSnailBlockEntity: Registry not available for number assignment");
            }
        }
        catch (Exception e) {
            System.err.println("TransponderSnailBlockEntity: Error assigning snail number: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void registerWithCallManager() {
        if (!this.isCallManagerAvailable() || !this.hasAssignedNumber() || this.isUnloading) {
            return;
        }
        TransponderCallManager callManager = this.getCallManager();
        if (!callManager.isSnailBlockRegistered(this.assignedSnailNumber)) {
            callManager.registerSnailBlock(this.assignedSnailNumber, this);
            System.out.println("TransponderSnailBlockEntity: Registered snail #" + this.assignedSnailNumber + " with call manager");
        }
    }

    public void unregisterFromCallManager() {
        if (!this.isCallManagerAvailable() || !this.hasAssignedNumber()) {
            return;
        }
        TransponderCallManager callManager = this.getCallManager();
        if (callManager.isSnailBlockRegistered(this.assignedSnailNumber)) {
            callManager.unregisterSnailBlock(this.assignedSnailNumber);
            System.out.println("TransponderSnailBlockEntity: Unregistered snail #" + this.assignedSnailNumber + " from call manager");
        }
    }

    public int getSnailNumber() {
        return this.assignedSnailNumber;
    }

    public UUID getSnailUUID() {
        return this.snailUUID;
    }

    public boolean hasAssignedNumber() {
        return this.initialized && this.assignedSnailNumber != -1 && this.snailUUID != null;
    }

    public ItemStack getSnailItemStack() {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_().m_5456_());
        if (this.hasAssignedNumber()) {
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128362_("snail_uuid", this.snailUUID);
            nbt.m_128405_("cached_snail_number", this.assignedSnailNumber);
            nbt.m_128356_("activation_time", System.currentTimeMillis());
            nbt.m_128359_("snail_type", "BLOCK");
        }
        return stack;
    }

    public void m_187476_(ItemStack stack) {
        this.unregisterFromCallManager();
        if (this.activeCallId != null && this.isCallManagerAvailable()) {
            TransponderCallManager callManager = this.getCallManager();
            callManager.endCallBySnailNumber(this.assignedSnailNumber);
        }
        if (this.hasAssignedNumber()) {
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128362_("snail_uuid", this.snailUUID);
            nbt.m_128405_("cached_snail_number", this.assignedSnailNumber);
            nbt.m_128356_("activation_time", System.currentTimeMillis());
            nbt.m_128359_("snail_type", "BLOCK");
            CompoundTag blockEntityTag = new CompoundTag();
            blockEntityTag.m_128362_("SnailUUID", this.snailUUID);
            blockEntityTag.m_128405_("AssignedNumber", this.assignedSnailNumber);
            blockEntityTag.m_128379_("Initialized", this.initialized);
            int shellColorToSave = this.shellColor;
            if (this.colorsInitialized) {
                BlockState state;
                if (this.f_58857_ != null && (state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() instanceof TransponderSnailBlock) {
                    shellColorToSave = (Integer)state.m_61143_((Property)TransponderSnailBlock.SHELL_COLOR);
                }
                nbt.m_128405_("body_color", this.bodyColor);
                nbt.m_128405_("shell_color", shellColorToSave);
                blockEntityTag.m_128405_("BodyColor", this.bodyColor);
                blockEntityTag.m_128405_("ShellColor", shellColorToSave);
                blockEntityTag.m_128379_("ColorsInitialized", this.colorsInitialized);
            }
            nbt.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
            System.out.println("TransponderSnailBlockEntity: Saved snail data to item - UUID: " + this.snailUUID + ", Number: #" + this.assignedSnailNumber + (String)(this.colorsInitialized ? ", Colors: #" + Integer.toHexString(this.bodyColor) + "/" + DyeColor.m_41053_((int)shellColorToSave).m_41065_() : ""));
        }
    }

    public void loadFromItem(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag blockEntityTag;
            CompoundTag nbt = stack.m_41783_();
            if (nbt.m_128441_("BlockEntityTag") && (blockEntityTag = nbt.m_128469_("BlockEntityTag")).m_128403_("SnailUUID")) {
                this.snailUUID = blockEntityTag.m_128342_("SnailUUID");
                this.assignedSnailNumber = blockEntityTag.m_128451_("AssignedNumber");
                this.initialized = blockEntityTag.m_128471_("Initialized");
                this.needsValidation = true;
                this.m_6596_();
                System.out.println("TransponderSnailBlockEntity: Loaded from BlockEntityTag - UUID: " + this.snailUUID + ", Number: #" + this.assignedSnailNumber);
                return;
            }
            if (nbt.m_128403_("snail_uuid")) {
                this.snailUUID = nbt.m_128342_("snail_uuid");
                this.assignedSnailNumber = nbt.m_128451_("cached_snail_number");
                this.initialized = true;
                this.needsValidation = true;
                this.m_6596_();
                System.out.println("TransponderSnailBlockEntity: Loaded from NBT - UUID: " + this.snailUUID + ", Number: #" + this.assignedSnailNumber);
            }
            if (nbt.m_128441_("body_color")) {
                this.bodyColor = nbt.m_128451_("body_color");
                this.shellColor = nbt.m_128451_("shell_color");
                this.colorsInitialized = true;
            }
        }
    }

    public void dialDigit(int digit) {
        if (this.dialedNumber.length() < 4) {
            this.dialedNumber = this.dialedNumber + digit;
            this.m_6596_();
        }
    }

    public void clearDialedNumber() {
        this.dialedNumber = "";
        this.m_6596_();
    }

    public String getDialedNumber() {
        return this.dialedNumber;
    }

    public void setDialedNumber(String number) {
        this.dialedNumber = number;
        this.m_6596_();
    }

    @Nullable
    public ServerPlayer findNearbyPlayer() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = this.m_58899_();
        ServerPlayer closestPlayer = null;
        double closestDistance = Double.MAX_VALUE;
        for (ServerPlayer player : serverLevel.m_6907_()) {
            double distance = player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            if (!(distance <= VoiceChatConstants.getSnailInteractionRange() * VoiceChatConstants.getSnailInteractionRange()) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestPlayer = player;
        }
        return closestPlayer;
    }

    public List<ServerPlayer> getNearbyListeners() {
        Level level;
        if (this.isCallManagerAvailable() && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.getCallManager().getPlayersNearSnail(serverLevel, this.f_58858_, VoiceChatConstants.getSnailInteractionRange());
        }
        return List.of();
    }

    public void setRinging(boolean ringing) {
        if (this.isRinging != ringing) {
            this.isRinging = ringing;
            this.ringStartTime = ringing ? System.currentTimeMillis() : 0L;
            this.m_6596_();
            this.updateBlockstateVisuals();
        }
    }

    public void setActiveCall(UUID callId) {
        this.activeCallId = callId;
        this.m_6596_();
        this.updateBlockstateVisuals();
    }

    public UUID getActiveCallId() {
        return this.activeCallId;
    }

    public boolean isRinging() {
        return this.isRinging;
    }

    public long getRingStartTime() {
        return this.ringStartTime;
    }

    public void setShellColor(int dyeColor) {
        if (dyeColor >= 0 && dyeColor <= 15 && dyeColor != this.shellColor) {
            this.shellColor = dyeColor;
            this.m_6596_();
            System.out.println("TransponderSnailBlockEntity: Shell color updated to " + DyeColor.m_41053_((int)dyeColor).m_41065_());
        }
    }

    private void initializeSnailColors() {
        if (this.colorsInitialized) {
            return;
        }
        this.bodyColor = this.generateRandomPastelColor();
        this.shellColor = 0;
        this.colorsInitialized = true;
        this.m_6596_();
        System.out.println("TransponderSnailBlockEntity: Generated colors - Body: #" + Integer.toHexString(this.bodyColor) + " at " + this.f_58858_);
    }

    private int generateRandomPastelColor() {
        Random random = new Random();
        float hue = random.nextFloat();
        float saturation = 0.3f + random.nextFloat() * 0.3f;
        float lightness = 0.7f + random.nextFloat() * 0.2f;
        return this.hslToRgb(hue, saturation, lightness);
    }

    private int hslToRgb(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = this.hueToRgb(p, q, h + 0.33333334f);
            g = this.hueToRgb(p, q, h);
            b = this.hueToRgb(p, q, h - 0.33333334f);
        }
        int red = Math.round(r * 255.0f);
        int green = Math.round(g * 255.0f);
        int blue = Math.round(b * 255.0f);
        return red << 16 | green << 8 | blue;
    }

    private float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public int getBodyColor() {
        if (!this.colorsInitialized) {
            return 0xFFFFFF;
        }
        return this.bodyColor;
    }

    public int getShellColor() {
        BlockState state;
        if (this.f_58857_ != null && (state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() instanceof TransponderSnailBlock) {
            return (Integer)state.m_61143_((Property)TransponderSnailBlock.SHELL_COLOR);
        }
        return this.shellColor;
    }

    public void ensureColorsInitialized() {
        if (!this.colorsInitialized) {
            this.initializeSnailColors();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                BlockState state = this.f_58857_.m_8055_(this.f_58858_);
                this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        System.out.println("TransponderSnailBlockEntity: Saving additional data - UUID: " + this.snailUUID + ", Number: #" + this.assignedSnailNumber + ", Initialized: " + this.initialized);
        if (this.snailUUID != null) {
            tag.m_128362_("SnailUUID", this.snailUUID);
        }
        tag.m_128405_("AssignedNumber", this.assignedSnailNumber);
        tag.m_128379_("Initialized", this.initialized);
        if (this.activeCallId != null) {
            tag.m_128362_("ActiveCallId", this.activeCallId);
        }
        tag.m_128379_("IsRinging", this.isRinging);
        tag.m_128359_("DialedNumber", this.dialedNumber);
        tag.m_128359_("CallState", this.currentCallState.name());
        tag.m_128356_("RingStartTime", this.ringStartTime);
        tag.m_128379_("HasAmbientSound", this.hasAmbientSound);
        tag.m_128379_("InActiveCall", this.inActiveCall);
        tag.m_128379_("AudioReady", this.audioReady);
        tag.m_128405_("BodyColor", this.bodyColor);
        tag.m_128405_("ShellColor", this.shellColor);
        tag.m_128379_("ColorsInitialized", this.colorsInitialized);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("BodyColor")) {
            this.bodyColor = tag.m_128451_("BodyColor");
            this.shellColor = tag.m_128451_("ShellColor");
            this.colorsInitialized = tag.m_128471_("ColorsInitialized");
            System.out.println((this.f_58857_ != null && this.f_58857_.f_46443_ ? "CLIENT" : "SERVER") + ": Loaded colors - Body: #" + Integer.toHexString(this.bodyColor) + ", Shell: " + this.shellColor + ", Initialized: " + this.colorsInitialized);
            if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.colorsInitialized) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128403_("SnailUUID")) {
            this.snailUUID = tag.m_128342_("SnailUUID");
        }
        this.assignedSnailNumber = tag.m_128451_("AssignedNumber");
        this.initialized = tag.m_128471_("Initialized");
        System.out.println("TransponderSnailBlockEntity: Loaded from NBT - UUID: " + this.snailUUID + ", Number: #" + this.assignedSnailNumber + ", Initialized: " + this.initialized);
        if (!(isServerShuttingDown || this.validationCompleted || this.snailUUID == null || this.assignedSnailNumber == -1 && !this.initialized)) {
            this.needsValidation = true;
            System.out.println("TransponderSnailBlockEntity: Marked for deferred validation");
        }
        if (tag.m_128403_("ActiveCallId")) {
            this.activeCallId = tag.m_128342_("ActiveCallId");
        }
        this.isRinging = tag.m_128471_("IsRinging");
        this.dialedNumber = tag.m_128461_("DialedNumber");
        this.ringStartTime = tag.m_128454_("RingStartTime");
        try {
            String stateStr = tag.m_128461_("CallState");
            if (!stateStr.isEmpty()) {
                this.currentCallState = CallStateSyncPacket.CallState.valueOf(stateStr);
            }
        }
        catch (IllegalArgumentException e) {
            this.currentCallState = CallStateSyncPacket.CallState.IDLE;
        }
        this.hasAmbientSound = tag.m_128471_("HasAmbientSound");
        this.inActiveCall = tag.m_128471_("InActiveCall");
        this.audioReady = tag.m_128471_("AudioReady");
    }
}

