/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="transpondersnails", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfig {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    private static final boolean DEFAULT_ENABLE_NUMPAD = false;
    private static final double DEFAULT_LOCATIONAL_RANGE = 10.0;
    private static final double DEFAULT_HANDHELD_RANGE = 3.0;
    private static final long DEFAULT_RING_TIMEOUT = 30000L;
    private static final double DEFAULT_INTERACTION_RANGE = 10.0;
    private static boolean cachedEnableNumpad;
    private static double cachedLocationalRange;
    private static double cachedHandheldRange;
    private static long cachedRingTimeout;
    private static double cachedInteractionRange;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            cachedEnableNumpad = (Boolean)ModConfig.CLIENT.enableNumpadSupport.get();
            System.out.println("TransponderSnails client config loaded:");
            System.out.println("  Numpad Enabled: " + cachedEnableNumpad);
        } else if (event.getConfig().getSpec() == SERVER_SPEC) {
            cachedLocationalRange = ModConfig.getValidatedValue((Double)ModConfig.SERVER.locationalSnailRange.get(), 10.0, 1.0, 100.0);
            cachedHandheldRange = ModConfig.getValidatedValue((Double)ModConfig.SERVER.handheldSnailRange.get(), 3.0, 1.0, 50.0);
            cachedRingTimeout = ModConfig.getValidatedValue((Long)ModConfig.SERVER.ringTimeoutMs.get(), 30000L, 5000L, 300000L);
            cachedInteractionRange = ModConfig.getValidatedValue((Double)ModConfig.SERVER.snailInteractionRange.get(), 10.0, 1.0, 50.0);
            System.out.println("TransponderSnails server config loaded:");
            System.out.println("  Locational Snail Range: " + cachedLocationalRange);
            System.out.println("  Handheld Snail Range: " + cachedHandheldRange);
            System.out.println("  Ring Timeout: " + cachedRingTimeout + "ms");
            System.out.println("  Interaction Range: " + cachedInteractionRange);
        }
    }

    private static double getValidatedValue(double value, double defaultValue, double min, double max) {
        if (Double.isNaN(value) || Double.isInfinite(value) || value < min || value > max) {
            System.out.println("TransponderSnails: Invalid config value " + value + ", using default " + defaultValue);
            return defaultValue;
        }
        return value;
    }

    private static long getValidatedValue(long value, long defaultValue, long min, long max) {
        if (value < min || value > max) {
            System.out.println("TransponderSnails: Invalid config value " + value + ", using default " + defaultValue);
            return defaultValue;
        }
        return value;
    }

    public static boolean isNumpadEnabled() {
        return cachedEnableNumpad;
    }

    public static void setNumpadEnabled(boolean enabled) {
        ModConfig.CLIENT.enableNumpadSupport.set((Object)enabled);
        cachedEnableNumpad = enabled;
        CLIENT_SPEC.save();
    }

    public static double getLocationalSnailRange() {
        if (cachedLocationalRange <= 0.0 || Double.isNaN(cachedLocationalRange)) {
            System.out.println("TransponderSnails: Cached locational range invalid, using default");
            return 10.0;
        }
        return cachedLocationalRange;
    }

    public static double getHandheldSnailRange() {
        if (cachedHandheldRange <= 0.0 || Double.isNaN(cachedHandheldRange)) {
            System.out.println("TransponderSnails: Cached handheld range invalid, using default");
            return 3.0;
        }
        return cachedHandheldRange;
    }

    public static long getRingTimeoutMs() {
        if (cachedRingTimeout <= 0L) {
            System.out.println("TransponderSnails: Cached ring timeout invalid, using default");
            return 30000L;
        }
        return cachedRingTimeout;
    }

    public static double getSnailInteractionRange() {
        if (cachedInteractionRange <= 0.0 || Double.isNaN(cachedInteractionRange)) {
            System.out.println("TransponderSnails: Cached interaction range invalid, using default");
            return 10.0;
        }
        return cachedInteractionRange;
    }

    static {
        Pair clientPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (ClientConfig)clientPair.getLeft();
        Pair serverPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)serverPair.getRight();
        SERVER = (ServerConfig)serverPair.getLeft();
        cachedEnableNumpad = false;
        cachedLocationalRange = 10.0;
        cachedHandheldRange = 3.0;
        cachedRingTimeout = 30000L;
        cachedInteractionRange = 10.0;
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue enableNumpadSupport;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Transponder Snails Client Configuration").comment("These settings are per-player and affect input/GUI preferences").push("client");
            this.enableNumpadSupport = builder.comment("Enable numpad keys for dialing in addition to number row keys").comment("This is a client-side preference that doesn't affect gameplay").define("enable_numpad", false);
            builder.pop();
        }
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.DoubleValue locationalSnailRange;
        public final ForgeConfigSpec.DoubleValue handheldSnailRange;
        public final ForgeConfigSpec.LongValue ringTimeoutMs;
        public final ForgeConfigSpec.DoubleValue snailInteractionRange;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Transponder Snails Server Configuration").comment("   =%%% :%%%: %@@@@@@@# ").comment(" :@=  .@#   *%%#######%%= ").comment(" :@=   @#   :-#*::::-#*:*@: ").comment("   =@: @# =@#*:-#=:+*:-#%@: ").comment("   =@: @# +@%#:::=#=:.-#%@: ").comment("   =@:    =@%#:-#=:+*:-#%@: ").comment("   =@:      +##*::::-*#*%@: ").comment("   =@:      .:*#*****#*:*@: ").comment("   =@:                :@= ").comment("   =@=:               :@= ").comment("     *%-::::::::::::::=@= ").comment("      .%%%%%%%%%%%%%%%* ").comment("These settings control gameplay mechanics and are synced to all players").push("gameplay");
            this.locationalSnailRange = builder.comment("Range in blocks for voice chat through placed Transponder Snail blocks").comment("Players within this range can hear each other through the snail").defineInRange("locational_snail_range", 10.0, 1.0, 100.0);
            this.handheldSnailRange = builder.comment("Range in blocks for voice chat through handheld Transponder Snails").comment("Players within this range can hear each other through handheld snails").defineInRange("handheld_snail_range", 3.0, 1.0, 50.0);
            this.ringTimeoutMs = builder.comment("How long (in milliseconds) a snail will ring before timing out").comment("30000 ms = 30 seconds").defineInRange("ring_timeout_ms", 30000L, 5000L, 300000L);
            this.snailInteractionRange = builder.comment("Range in blocks for interacting with Transponder Snail blocks").comment("Players must be within this range to use snail blocks").defineInRange("snail_interaction_range", 10.0, 1.0, 50.0);
            builder.pop();
        }
    }
}

